<?php

namespace App\Models;

use CodeIgniter\Model;

class Transaccionmodel extends Model
{
    protected $table = 'transaccion_cabecera';
    protected $primaryKey = 'trc_id';
    protected $allowedFields = [
        'trc_dispatch_id',
        'trc_nombre_almacen',
        'trc_punto_emision',
        'trc_fecha_transaccion',
        'trc_secuencial',
        'trc_dni_cliente',
        'trc_nombre_cliente',
        'trc_metodo_pago',
        'trc_total',
        'trc_monto_metodo_pago'
    ];

    protected $db;  // Para usar la conexión PostgreSQL

    /**
     * Constructor para inicializar la conexión PostgreSQL.
     */
    public function __construct()
    {
        parent::__construct();
        // Conectar a la base de datos PostgreSQL
        $this->db = \Config\Database::connect('postgres');
    }

    /**
     * Inserta una nueva transacción si no existe ya una transacción
     * con el mismo secuencial.
     *
     * @param array $data
     * @return bool
     */
    public function insertarTransaccionSiNoExiste($data)
{
    $db = \Config\Database::connect('postgres');

    // Verificar si ya existe una transacción con el mismo secuencial y almacén
    $query = $db->table('transaccion_cabecera')
                ->where('trc_secuencial', $data['trc_secuencial'])
                ->where('trc_nombre_almacen', $data['trc_nombre_almacen'])
                ->where('trc_fecha_transaccion', $data['trc_fecha_transaccion'])
                ->where('trc_dni_cliente', $data['trc_dni_cliente'])
                ->get();

    if ($query->getNumRows() > 0) {
        // Si la transacción ya existe, devolver su ID
        return null;
    }

    // Insertar nueva transacción y obtener el ID generado
    $builder = $db->table('transaccion_cabecera');
    $builder->insert($data);

    return $db->insertID(); // ✅ Esto obtiene el ID de la secuencia correctamente
}

    public function insertarTransaccionTipoPagoSiNoExiste($data)
    {
        // Verificar si ya existe una transacción con el mismo 'trc_secuencial'
        $existing = $this->db->table('transaccion_pago')
            ->where('trp_nombre_almacen', $data['trp_nombre_almacen'])
            ->where('trp_fecha_transaccion', $data['trp_fecha_transaccion'])
            ->where('trp_secuencial', $data['trp_secuencial'])
            ->where('trp_metodo_pago', $data['trp_metodo_pago'])
            ->where('trp_nombre_cliente', $data['trp_nombre_cliente'])
            ->where('trp_total', $data['trp_total'])
            ->where('trp_monto_metodo_pago', $data['trp_monto_metodo_pago'])
            ->get()
            ->getRow();

        if ($existing) {
            // Si ya existe, no insertar y devolver el ID de la transacción existente
            
            return '';
        }

        // Si no existe, realizar la inserción
        $this->db->table('transaccion_pago')->insert($data);

        // Imprimir la consulta ejecutada
       // echo $this->db->getLastQuery();

        // Verificar si ocurrió un error durante la inserción
        $error = $this->db->error();
        if ($error['code'] != 0) {
            // Imprimir el mensaje de error en caso de fallo
            echo "Error al insertar: " . $error['message'];
            return false;
        }

        // Retornar el ID insertado
        return $this->db->insertID();
    }
}
