<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class UsuarioModel extends Model
{
    public function Login($usu_correo,$usu_clave)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario as u');
        $builder->select('u.*, d.DAP_NOMBRES');     
        $builder->join('tbl_datos_personales as d','d.DAP_ID=u.DAP_ID');
        $builder->where('u.USU_CORREO', $usu_correo); 
        $builder->where('u.USU_CLAVE', $usu_clave);  
        $builder-> where('u.USU_ESTADO',1);
        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function buscarRolMenu($rol){
        $db = \Config\Database::connect();
        $builder = $db->table('rel_rol_menu');
        $builder->where('ROL_ID', $rol);
        $builder->where('ROM_ESTADO', 1);
        $query = $builder->get();
        $est = $query->getResultArray();
        return $est;
    }
    
    public function selectMenu(){
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_menu');
        $builder->where('MEN_ESTADO', 1);
        $query = $builder->get();
        $est = $query->getResultArray();
        return $est;
    }
    
    public function getUsuario()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*');    
        $builder->join('tbl_rol', 'tbl_usuario.ROL_ID=tbl_rol.ROL_ID'); 
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID AND tbl_datos_personales.DAP_ESTADO=1');
        $builder->join('tbl_cargo', 'tbl_usuario.CAR_ID=tbl_cargo.CAR_ID');   
        $builder->where('tbl_datos_personales.DAP_ESTADO', 1);
        $builder->where('tbl_usuario.usu_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUsuarioComisiones()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*');    
        $builder->join('tbl_rol', 'tbl_usuario.ROL_ID=tbl_rol.ROL_ID'); 
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID'); 
        $builder->where('tbl_usuario.sis_id', 2);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getCoordinador()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*');    
        $builder->join('tbl_rol', 'tbl_usuario.ROL_ID=tbl_rol.ROL_ID'); 
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');
        $builder->join('tbl_cargo', 'tbl_usuario.CAR_ID=tbl_cargo.CAR_ID');   
        $builder->join('tbl_contrato_negociador', 'tbl_usuario.USU_ID=tbl_contrato_negociador.usu_id'); 
        $builder->where('tbl_contrato_negociador.cne_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->set($data);
		$builder->insert();

    }
    public function actualizar($USU_ID,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->where('tbl_usuario.USU_ID', $USU_ID);
		return $builder->update($data);        
    }
    public function getUsuarioPlan()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*');    
        $builder->join('tbl_rol', 'tbl_usuario.ROL_ID=tbl_rol.ROL_ID'); 
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');
        $builder->join('tbl_cargo', 'tbl_usuario.CAR_ID=tbl_cargo.CAR_ID');
        $builder->join('tbl_canal', 'tbl_usuario.CAN_ID=tbl_canal.can_id');  
        $builder->join('tbl_area', 'tbl_usuario.are_id=tbl_area.are_id'); 
        $builder->where('tbl_usuario.sis_id', 1);
        $builder->where('tbl_datos_personales.DAP_ESTADO', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUsuarioCoordinador()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*'); 
        $builder->join('tbl_datos_personales', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID');
        $builder->where('tbl_usuario.usu_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUsuarioDescuentos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*'); 
        $builder->join('tbl_datos_personales', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID');
        $builder->where('tbl_usuario.usu_estado', 1);
        $builder->where('tbl_usuario.rol_id', 29);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUsuarioDescuentosList()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_usuario');
        $builder->select('*'); 
        $builder->join('tbl_datos_personales', 'tbl_datos_personales.DAP_ID = tbl_usuario.DAP_ID', 'inner');
        $builder->join('tbl_asignacion_descuento', 'tbl_usuario.USU_ID = tbl_asignacion_descuento.USU_ID', 'inner');
        $builder->join('tbl_descuentos_mensuales', 'tbl_asignacion_descuento.DEM_ID = tbl_descuentos_mensuales.DEM_ID', 'inner');
        $builder->where('tbl_usuario.usu_estado', 1);
    
        // Imprimir la consulta SQL generada para depuración
        //echo $builder->getCompiledSelect(); die();
        
        $query = $builder->get();
        $resultado = $query->getResultArray();//print_r($resultado);die();
        return $resultado;
    }

    
}