<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Ventamodel extends Model
{
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->set($data);
		$builder->insert();

    }

    public function getVentasegunpuvidmes($puv_id,$mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.puv_id', $puv_id); 
        $builder->where('tbl_venta.ven_mes', $mes );
        $builder->orderBy('tbl_venta.ven_fecha_contable' );
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getVentaspormes($mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.ven_mes', $mes );
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function actualizar($ven_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_id', $ven_id);
        return $builder->update($data);        
    }
    public function eliminarpormes($ven_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_mes', $ven_mes);
        return $builder->delete();        
    }
    
    public function getTotalVentasMes()
    {
        $db = \Config\Database::connect('postgres');
        $builder = $db->table('transaccion_pago');
        $builder->select("sum(trp_monto_metodo_pago) as valor, TO_CHAR(trp_fecha_transaccion, 'Month') as mes");    
        $builder->where("EXTRACT(YEAR FROM trp_fecha_transaccion) = EXTRACT(YEAR FROM CURRENT_DATE)");
        $builder->groupBy('mes');
        $builder->orderBy('MIN(trp_fecha_transaccion)', 'asc');  // Asegura el orden correcto
        $query = $builder->get();
        return $query->getResultArray();
    }

    public function getTotalVentasMesPDV()
    {
        $db = \Config\Database::connect('postgres');
        $builder = $db->table('transaccion_pago');
        $builder->select("trp_nombre_almacen as pdv, SUM(trp_monto_metodo_pago) as valor, TO_CHAR(trp_fecha_transaccion, 'Month') as mes");    
        $builder->where("EXTRACT(YEAR FROM trp_fecha_transaccion) = EXTRACT(YEAR FROM CURRENT_DATE)");
        $builder->where("EXTRACT(MONTH FROM trp_fecha_transaccion) = EXTRACT(MONTH FROM CURRENT_DATE)");
        $builder->groupBy("trp_nombre_almacen, mes");
        $builder->orderBy("MIN(trp_fecha_transaccion)", "asc");  // Para mantener el orden correcto
        $query = $builder->get();
        return $query->getResultArray();
    }


}