<script src="https://unpkg.com/read-excel-file@5.x/bundle/read-excel-file.min.js"></script>
<script>

    class Excel {
        constructor(content) {
            this.content = content;
        }
        // Usamos las dos primeras filas como encabezados
        header() {
            return [this.content[0], this.content[1]];
        }
        rows() {
            return new RowCollection(this.content.slice(2, this.content.length)); // El contenido empieza después de los encabezados
        }
    }

    class RowCollection {
        constructor(rows) {
            this.rows = rows;
        }
        get(index) {
            return new Row(this.rows[index]);
        }
        count() {
            return this.rows.length;
        }
    }

    class Row {
        constructor(row) {
            this.row = row;
        }
        getCell(index) {
            // Si la celda está vacía o es undefined, devuelve 0
            const value = (this.row[index] !== undefined && this.row[index] !== '') ? this.row[index] : 0;
            
            // Verificar si el valor es numérico y devolverlo con formato monetario si es así
            if (typeof value === 'number') {
                return USDollar.format(value);
            }
            return value;
        }
        count() {
            return this.row.length;
        }
    }

    class ExcelPrinter {
    static async print(tableId, excel) {
        const table = document.getElementById(tableId);
        const alertDiv = document.getElementById('alertDiv'); // Div para mostrar alertas
        const loadingDiv = document.getElementById('loading'); // Div para mostrar el "loading"
        
        // Mostrar el "loading"
        loadingDiv.style.display = 'block';

        alertDiv.innerHTML = ''; // Limpiar alertas previas
        const headerRows = excel.header();

        // Limpiar contenido previo
        table.querySelector("thead").innerHTML = '';
        table.querySelector("tbody").innerHTML = '';

        // Crear la primera fila de encabezado (con rowspan en la primera celda, mostrando "PDV")
        let firstHeaderRowHtml = '<tr>';
        firstHeaderRowHtml += `<th rowspan="2">PDV</th>`;

        // Recorremos las columnas
        for (let i = 1; i < headerRows[0].length; i++) {
            firstHeaderRowHtml += `<th>${headerRows[0][i]}</th>`;
            if (headerRows[0][i] === 'Descuento') {
                // Verificar descuento
                const descuento = (await comprobarDescuento(headerRows[1][i])).trim();  // Asegurarse de que no haya espacios
                
                if (descuento !== 'no') {  // Comparación estricta para evitar errores
                    alertDiv.innerHTML += `<p style="color: red;">Error: Descuento '${headerRows[1][i]}' no encontrado.</p>`;
                }
            } else {
                if (headerRows[0][i] === 'Convenio') {
                    // Verificar convenio
                    const convenio = await comprobarConvenio(headerRows[1][i]);
                    if (convenio != '') {
                        alertDiv.innerHTML += `<p style="color: red;">Error: Convenio '${headerRows[1][i]}' no encontrado.</p>`;
                    }
                } else if (headerRows[0][i] === 'Postconvenio') {
                    // Verificar postconvenio
                    const postconvenio = await comprobarPostconvenio(headerRows[1][i]);
                    if (postconvenio != '') {
                        alertDiv.innerHTML += `<p style="color: red;">Error: Postconvenio '${headerRows[1][i]}' no encontrado.</p>`;
                    }
                } else {
                    alertDiv.innerHTML += `<p style="color: red;">Error:'${headerRows[0][i]}' no encontrado.</p>`;
                }
            }
        }
        firstHeaderRowHtml += '</tr>';
        table.querySelector("thead").innerHTML += firstHeaderRowHtml;

        // Crear la segunda fila de encabezado
        let secondHeaderRowHtml = '<tr>';
        for (let i = 1; i < headerRows[1].length; i++) {
            secondHeaderRowHtml += `<th>${headerRows[1][i]}</th>`;
        }
        secondHeaderRowHtml += '</tr>';
        table.querySelector("thead").innerHTML += secondHeaderRowHtml;

        // Crear filas dinámicamente
        for (let index = 0; index < excel.rows().count(); index++) {
            const row = excel.rows().get(index);
            let rowHtml = '<tr>';

            // Recorrer las celdas de cada fila
            for (let cellIndex = 0; cellIndex < 1; cellIndex++) {
                rowHtml += `<td>${row.getCell(cellIndex)}</td>`;
                var pdv1 = row.getCell(cellIndex);
                const pdv = await comprobarPDV(pdv1);
                if (pdv != '') {
                    alertDiv.innerHTML += '<p style="color: red;">Error: PDV ' + pdv1 + ' no encontrado.</p>';
                }
            }
            for (let cellIndex = 1; cellIndex < row.count(); cellIndex++) {
                rowHtml += `<td style="text-align: right">${row.getCell(cellIndex)}</td>`;
            }

            rowHtml += '</tr>';
            table.querySelector("tbody").innerHTML += rowHtml;
        }

        document.getElementById('datosdetalleproducto').value = JSON.stringify(excel.rows()); // Actualizar el valor del campo oculto
        document.getElementById('cabecera1').value = JSON.stringify(excel.header());

        // Ocultar el "loading" al finalizar
        loadingDiv.style.display = 'none';
    }
}

var excelInput = document.getElementById('detalleproducto');
excelInput.addEventListener('change', async function () {
    const table = document.getElementById("detalle");
    const loadingDiv = document.getElementById('loading'); // Div para mostrar el "loading"
    
    // Mostrar el "loading"
    loadingDiv.style.display = 'block';
    
    if (typeof (excelInput.files[0]) != 'undefined') {
        const content = await readXlsxFile(excelInput.files[0]);
        const excel = new Excel(content);
        await ExcelPrinter.print("detalle", excel);
    } else {
        table.querySelector("thead").innerHTML = '';
        table.querySelector("tbody").innerHTML = '';
        document.getElementById('detalle').value = '';
    }
    
    // Ocultar el "loading" cuando se termine el proceso
    loadingDiv.style.display = 'none';
});

    let USDollar = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD',
    });
    
    
    async function comprobarDescuento(nombreDescuento) {
    return new Promise((resolve, reject) => {
        $.ajax({		    
            url : '<?php echo base_url();?>'+'/Descuentos/comprobarExisteDescuento',
            data : {nombreDescuento:nombreDescuento},
            type : 'POST',
            success : function(json) {
                if (json !== [] && json !== null) {
                    resolve(json);
                } else {
                    resolve("");
                }
            },
            error : function(xhr, status) {
                alert('Disculpe, existió un problema');
                reject(status);
            }
        });
    });
}

async function comprobarConvenio(nombreConvenio) {
    return new Promise((resolve, reject) => {
        $.ajax({		    
            url : '<?php echo base_url();?>'+'/Convenios/comprobarExisteConvenio',
            data : {nombreConvenio:nombreConvenio},
            type : 'POST',
            success : function(json) {
                if (json !== [] && json !== null) {
                    resolve(json);
                } else {
                    resolve("");
                }
            },
            error : function(xhr, status) {
                alert('Disculpe, existió un problema');
                reject(status);
            }
        });
    });
}
async function comprobarPostconvenio(nombrePostconvenio) {
    return new Promise((resolve, reject) => {
        $.ajax({		    
            url : '<?php echo base_url();?>'+'/Postconvenio/comprobarExistePostconvenio',
            data : {nombrePostconvenio:nombrePostconvenio},
            type : 'POST',
            success : function(json) {
                if (json !== [] && json !== null) {
                    resolve(json);
                } else {
                    resolve("");
                }
            },
            error : function(xhr, status) {
                alert('Disculpe, existió un problema');
                reject(status);
            }
        });
    });
}
async function comprobarPDV(nombrePDV) {
    return new Promise((resolve, reject) => {
        $.ajax({		    
            url : '<?php echo base_url();?>'+'/Puntoventa/comprobarExistePDV',
            data : {nombrePDV:nombrePDV},
            type : 'POST',
            success : function(json) {
                if (json !== [] && json !== null) {
                    resolve(json);
                } else {
                    resolve("");
                }
            },
            error : function(xhr, status) {
                alert('Disculpe, existió un problema');
                reject(status);
            }
        });
    });
}

</script>
