<script src="https://unpkg.com/read-excel-file@5.x/bundle/read-excel-file.min.js"></script>
<script>
    class Excel{
        constructor(content){
            this.content=content;
        }
        header(){
            return this.content[0];
        }
        rows(){
            return new RowCollection(this.content.slice(1,this.content.length));
        }
    }
    class RowCollection{
        constructor(rows){
            this.rows=rows;
        }
        get(index){
            return new Row(this.rows[index]);
        }
        count(){
            return this.rows.length;
        }
    }
    class Row{
        constructor(row){
            this.row=row;
        }
        mesEstimado(){
            return (this.row[0]).toString();
        }
        anoEstimado(){
            return this.row[1];
        }
        numeroCuota(){
            return this.row[2];
        }
        valorCapital(){
            return this.row[3];
        }
        valorInteres(){
            return this.row[4];
        }
        valorCuotaTotal(){
            return this.row[5];
        }
        count(){
            return this.row.length;
        }
    }
    class ExcelPrinter{
        static print(tableId, excel){
            const table=document.getElementById(tableId);
            var mes='';
            var valor=0;
            var cuotas=excel.rows().count();
            document.getElementById('cuotas').value=cuotas;
            if(excel.header().length==6 && excel.header()[0]=='MES DE DESCUENTO ESTIMADO' && excel.header()[1]=='AÑO DESCUENTO' && excel.header()[2]=='NÚMERO DE CUOTA' && excel.header()[3]=='VALOR DE CAPITAL' && excel.header()[4]=='VALOR DE INTERĖS' && excel.header()[5]=='VALOR DE CUOTA TOTAL' ){
                excel.header().forEach(title=>(
                    table.querySelector("thead>tr").innerHTML+=`<th>${title}</th>`
                    ))
                table.querySelector("tbody").innerHTML='';    
                for(let index=0; index<excel.rows().count();index++)
                {
                    const row=excel.rows().get(index);
                    valor=valor+row.valorCuotaTotal();
                    if(index==0){
                        if(row.mesEstimado().length<2)
                        {
                            mes='0'+row.mesEstimado();
                        }
                        else
                        {
                            mes=row.mesEstimado();
                        }
                        document.getElementById('fechadesde').value=row.anoEstimado()+'-'+mes+'-01';
                    }
                    if(index==excel.rows().count()-1){
                        if(row.mesEstimado().length<2)
                        {
                            mes='0'+row.mesEstimado();
                        }
                        else
                        {
                            mes=row.mesEstimado();
                        }
                        document.getElementById('fechahasta').value=row.anoEstimado()+'-'+mes+'-01';
                        
                    }
                    table.querySelector("tbody").innerHTML+=`
                    <tr>
                    <td>${obtenerNombreMes(row.mesEstimado())}</td> 
                    <td>${row.anoEstimado()}</td>
                    <td>${row.numeroCuota()}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCapital())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorInteres())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCuotaTotal())}</td>
                    </tr>`
                }
                document.getElementById('valor').value=valor;
                document.getElementById('detalleamortizacion').value=(JSON.stringify(excel.rows()));
            }
            else{
                alert("Error en el archivo");
                document.getElementById('tablaamortizacion').value='';
            }
        }
        
    }
    class ExcelPrinter2{
        static print(tableId, excel){
            const table=document.getElementById(tableId);
            var mes='';
            var valor=0;
            var cuotas=excel.rows().count(); 
            document.getElementById('refcuotas').value=cuotas;
            if(excel.header().length==6 && excel.header()[0]=='MES DE DESCUENTO ESTIMADO' && excel.header()[1]=='AÑO DESCUENTO' && excel.header()[2]=='NÚMERO DE CUOTA' && excel.header()[3]=='VALOR DE CAPITAL' && excel.header()[4]=='VALOR DE INTERĖS' && excel.header()[5]=='VALOR DE CUOTA TOTAL' ){
                excel.header().forEach(title=>(
                    table.querySelector("thead>tr").innerHTML+=`<th>${title}</th>`
                    ))
                table.querySelector("tbody").innerHTML='';    
                for(let index=0; index<excel.rows().count();index++)
                {
                    const row=excel.rows().get(index);
                    valor=valor+row.valorCuotaTotal();
                    
                    if(index==0){
                        if(row.mesEstimado().length<2)
                        {
                            mes='0'+row.mesEstimado();
                        }
                        else
                        {
                            mes=row.mesEstimado();
                        }
                        document.getElementById('reffechadesde').value=row.anoEstimado()+'-'+mes+'-01';
                    }
                    if(index==excel.rows().count()-1){
                        if(row.mesEstimado().length<2)
                        {
                            mes='0'+row.mesEstimado();
                        }
                        else
                        {
                            mes=row.mesEstimado();
                        }
                        document.getElementById('reffechahasta').value=row.anoEstimado()+'-'+mes+'-01';
                       
                    }
                    table.querySelector("tbody").innerHTML+=`
                    <tr>
                    <td>${obtenerNombreMes(row.mesEstimado())}</td>
                    <td>${row.anoEstimado()}</td>
                    <td>${row.numeroCuota()}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCapital())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorInteres())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCuotaTotal())}</td>
                    </tr>`
                }
                document.getElementById('refvalor').value=valor; 
                document.getElementById('refdetalleamortizacion').value=(JSON.stringify(excel.rows())); 
            }
            else{
                alert("Error en el archivo");
                document.getElementById('tablaamortizacion').value='';
            }
        }
        
    }
    var excelInput=document.getElementById('tablaamortizacion');
    var excelInput2=document.getElementById('reftablaamortizacion');
    excelInput.addEventListener('change',async function(){
        const content=await readXlsxFile(excelInput.files[0]);
        const excel=new Excel(content);
        //console.log(excel.header());
        //console.log(excel.rows().rows);
        //console.log(excel.rows().get());
        console.log(ExcelPrinter.print("amortizacion",excel));
    });
    excelInput2.addEventListener('change',async function(){
        const content=await readXlsxFile(excelInput2.files[0]);
        const excel=new Excel(content);
        //console.log(excel.header());
        //console.log(excel.rows().rows);
        //console.log(excel.rows().get());
        console.log(ExcelPrinter2.print("refamortizacion",excel));
    });
    let USDollar = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD',
    });

</script>