<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Areamodel;
use App\Models\Planmodel;
use App\Models\Empresamodel;
class Auth extends BaseController
{
	public $session = null;
	public  $usuario_model = null;
	public  $area_model = null;

	public function __construct()
	{
		$this->session = \Config\Services::session();
		$this->usuario_model = new UsuarioModel();
	}

	public function index(){	
	    $session = \Config\Services::session();
	    $empresa_model= new Empresamodel();
	    $datos_empresa=$empresa_model->getEmpresa();
	    $session->set('nombreempresa', $datos_empresa[0]['emp_nombre']);
	    $session->set('ruc', $datos_empresa[0]['emp_ruc']);
	    $session->set('logo',  $datos_empresa[0]['emp_logo']);
	    //echo $session->get('nombreempresa');
		echo view("Login/login");
	}
	

	public function login(){
	    
	    $session = \Config\Services::session();
		$correo = '';
		$clave = '';	
		
		if(!empty($this->request->getPost('correo')) && !empty($this->request->getPost('clave'))){
			$correo = $this->request->getPost('correo');
			$clave = $this->request->getPost('clave');
		}else{
			$this->session->setFlashdata('mensaje_malo', 'Ingrese usuario y clave');
			return redirect()->to(base_url()); 
		}

		$resultado_login = $this->getlogin($correo,$clave);
        
		if(!empty($resultado_login)){	
		    $area_model= new Areamodel();
		    
		    /*$resultado_presupuesto=$area_model->getPresupuestoAreaYearActual($resultado_login[0]['are_id']); 
		    if(count($resultado_presupuesto)>0)
		    {
		        $resultado_presupuesto=$resultado_presupuesto[0]['arp_presupuesto'];
		    }
		    else
		    {
		        $resultado_presupuesto=0;
		    }
		    $resultado_presupuesto_usado=$area_model->getPresupuestoAreaUsadoYearActual($resultado_login[0]['are_id']);
		    if(count($resultado_presupuesto_usado)>0)
		    {
    		    $diferencia=$resultado_presupuesto_usado[0]['mat']-$resultado_presupuesto_usado[0]['aup'];
    		    $presupuesto_restante=$resultado_presupuesto-$diferencia;
		    }
		    else
		    {
		        $presupuesto_restante=$resultado_presupuesto;
		    }
		    $p=''.$presupuesto_restante.'';
		    
		    $session->set('presupuesto', $p);*/
		    $session->set('areid', $resultado_login[0]['are_id']);
		    $this->session->set($resultado_login[0]);
		    $r=$this->archivarPLMTiempo();
		    if($r!=0){
		        $session->setFlashdata('mensaje_bueno', 'Se han archivado uno o varios planes de mercadeo');
		    }
		    return redirect()->to(base_url('Home')); 
		}else{
			$this->session->setFlashdata('mensaje_malo', 'Usuario o contraseña errónea');
			return redirect()->to(base_url()); 
		}

	}

	public function getlogin($usu_correo,$usu_clave){		
		$resultado = $this->usuario_model->Login($usu_correo,$usu_clave);		
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}
	
	public function getPresupuestoArea($are_id){		
		$resultado = $this->area_model->getPresupuestoAreaYearActual($are_id);		
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}

	public function logout(){
		$this->session->stop();
		$this->session->destroy();	
		return redirect()->to(base_url()); 
		
	}
	
	public function archivarPLMTiempo()
    {
        $session = \Config\Services::session();
		
		$plan_model=new PlanModel();
		
		$fecha_actual = date("Y-m-d");
		$fecha_plm=date("Y-m-d",strtotime($fecha_actual."- 1 month")); 
		$datos_plan_mercadeo=array(			

                'plm_archivar'=>'1',
                'esp_id'=>10,
				
			);
		$usuario=$session->get('USU_ID');
		$r=$plan_model->ArchivarPlanTiempo($fecha_plm,$usuario,$datos_plan_mercadeo);
		
		return $r;
		//return redirect()->to(base_url('Plan')); 
    }
}
