<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Categoriaproductomodel;

class Categoriaproducto extends BaseController
{

	public function index(){
		$categoria_producto_model= new Categoriaproductomodel();
		$datos_categoria_producto=$categoria_producto_model->getCategoriaproducto();

		$enviar_datos=array(
			'datos_categoria_producto' => !empty($datos_categoria_producto)?$datos_categoria_producto:null , 
		);

        $datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("categoriaproducto/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$categoria_producto_model= new Categoriaproductomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('categoria'))){
				$cap_categoria=$this->request->getPost('categoria');
				$ingresar_datos=array(
					'cap_categoria'=>$cap_categoria,
					'cap_estado'=>1
				);
				$categoria_producto_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Categoriaproducto')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Categoriaproducto')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$categoria_producto_model= new Categoriaproductomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editcategoria')) && !empty($this->request->getPost('editcapid'))){
				$cap_categoria=$this->request->getPost('editcategoria');
				$cap_id=$this->request->getPost('editcapid');
				$editar_datos=array(
					'cap_categoria'=>$cap_categoria,
					'cap_estado'=>1
				);
				$categoria_producto_model->actualizar($cap_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Categoriaproducto')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Categoriaproducto')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$categoria_producto_model= new Categoriaproductomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'cap_estado'=>0
				);
				$categoria_producto_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Categoriaproducto')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Categoriaproducto')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}