<?php

namespace App\Controllers;
use App\Models\Areamodel;
use App\Models\Proveedormodel;
use App\Models\UsuarioModel;
use App\Models\Tiponegociomodel;
use App\Models\Periodicidadmodel;
use App\Models\Categoriaproductomodel;
use App\Models\Contratocabeceramodel;
use App\Models\Contratodetallemodel;
use App\Models\Proyeccioncontratomodel;
use App\Models\Contratocompramodel;
use App\Models\Contratodocumentacionmodel;
use App\Models\Cuentacontablemodel;
use App\Models\Contratocobrogananciamodel;
use App\Models\Negociacionesganadomodel;
use App\Models\Proyeccioncompramodel;
use App\Models\Contratoestadomodel;
class Contrato extends BaseController
{
	public function index(){
		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$proveedor_model=new Proveedormodel();
		$tipo_negocio_model= new Tiponegociomodel();
		$contrato_estado_model= new Contratoestadomodel();

		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_usuario=$usuario_model->getUsuario();
		$datos_tipo_negocio=$tipo_negocio_model->getTiponegocio();
		$datos_contrato_estado=$contrato_estado_model->getContratoestado();

		$enviar_datos=array(
			'datos_proveedor'=>$datos_proveedor,
			'datos_usuario'=>$datos_usuario,
			'datos_tipo_negocio'=>$datos_tipo_negocio,
			'datos_contrato_estado'=>$datos_contrato_estado,
			'rol_id'=>$session->get('ROL_ID'),
		);

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("contrato/opciones",$enviar_datos);
		echo view("layouts/footer");
		
	}
	public function mostraradd(){
		$proveedor_model= new Proveedormodel();
		$usuario_model= new UsuarioModel();
		$tipo_negocio_model= new Tiponegociomodel();
		$periodicidad_model= new Periodicidadmodel();
		$categoria_producto_model= new Categoriaproductomodel();
		
		$contrato_detalle_model= new Contratodetallemodel();
		$cuenta_contable_model= new Cuentacontablemodel();

		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_usuario=$usuario_model->getCoordinador();
		$datos_tipo_negocio=$tipo_negocio_model->getTiponegocio();
		$datos_periodicidad=$periodicidad_model->getPeriodicidad();
		$datos_categoria_producto=$categoria_producto_model->getCategoriaproducto();
		
		$enviar_datos=array(			
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:null , 
			'datos_usuario' => !empty($datos_usuario)?$datos_usuario:null , 
			'datos_tipo_negocio' => !empty($datos_tipo_negocio)?$datos_tipo_negocio:null , 
			'datos_periodicidad' => !empty($datos_periodicidad)?$datos_periodicidad:null , 
			'datos_categoria_producto' => !empty($datos_categoria_producto)?$datos_categoria_producto:null , 
			
			
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("contrato/add",$enviar_datos);
		echo view("layouts/footer");
	}
	public function mostrarlist(){
		$session = \Config\Services::session();
		
		$cuenta_contable_model= new Cuentacontablemodel();
		$contrato_detalle_model= new Contratodetallemodel();

		$datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();


		$cod_desde= $this->request->getPost('fecha');
		$pro_id= $this->request->getPost('proid');
		$cod_negociador_interno= $this->request->getPost('usuid');
		$tin_id= $this->request->getPost('tinid');
		//$cod_desde= $this->request->getPost('costo');
		//$cod_desde= $this->request->getPost('gasto');
		$esc_id= $this->request->getPost('escid');

		$rol_id=$session->get('ROL_ID');
		if($rol_id==1){
			$can_id=null;
		}else{
			$can_id=$session->get('CAN_ID'); 
		}
		if($rol_id==4){
			$resultado_contrato_detalle=$contrato_detalle_model->getContratodetalleAutorizador($cod_desde,$pro_id,$cod_negociador_interno,$tin_id);
		}else{
			$resultado_contrato_detalle=$contrato_detalle_model->getContratodetalle($cod_desde,$pro_id,$cod_negociador_interno,$tin_id,$esc_id,$can_id);
		}

		//print_r($resultado_contrato_detalle);

		$enviar_datos=array(		
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:null ,
			'resultado_contrato_detalle' => !empty($resultado_contrato_detalle)?$resultado_contrato_detalle:null ,
			'rol_id'=>$session->get('ROL_ID'),
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("contrato/list",$enviar_datos);
		echo view("layouts/footer");
	}
	

	public function actualizarEditableProyeccion()
	{
		$proyeccion_compra_model= new Proyeccioncompramodel();
		if(empty($this->request->getPost('pceid'))){
			echo false;
		}
		if(empty($this->request->getPost('data'))){
			echo false;
		}
		$pce_id = $this->request->getPost('pceid');
		$data = $this->request->getPost('data');
		return $proyeccion_compra_model->updateProyeccionEditable(array(
			"pce_json"=>$data
		),$pce_id);
	}
	
	public function agregarValorVenta()
	{
		$contrato_detalle_model= new Contratodetallemodel();
		if(empty($this->request->getPost('codid'))){
		    $cod_id=$this->request->getPost('codid');
		    $cod_valorfinalventa=$this->request->getPost('addvalorventa');
		    $datos_editar[]=array(
				'cod_valorfinalventa'=>$cod_valorfinalventa,
			);//print_r($datos_editar);
		    $contrato_detalle_model->actualizar($cod_id,$datos_editar);
		    //$session->setFlashdata('mensaje_bueno', 'Valor de venta agregado satisfactoriamente');
			$this->index();
		}
		else
		{
		    
		}
	}
	
	public function mostrarContrato(){
		$contrato_detalle_model= new Contratodetallemodel();
		$contrato_cabecera_model= new Contratocabeceramodel();
		$proyeccion_contrato_model= new Proyeccioncontratomodel();
		$contrato_compra_model= new Contratocompramodel();
		$proyeccion_compra_model= new Proyeccioncompramodel();

		if(empty($this->request->getPost('conid'))){
			echo json_encode([]);
		}

		$con_id=$this->request->getPost('conid');
		
		$resultado_cabecera=$contrato_cabecera_model->getContratocabeceraID($con_id);
		$datos_contrato_detalle=[];
		$datos_cabecera=[];
		foreach ($resultado_cabecera as $value) {
			$resultado_detalle=$contrato_detalle_model->getContratodetallesegunconid($value['con_id']);
			
			foreach ($resultado_detalle as $itemdetalle) {
				$lista_compra=$contrato_compra_model->getContratocompraseguncodid($itemdetalle['cod_id']);
				$lista_proyeccion=$proyeccion_contrato_model-> getProyeccioncontratoseguncodid($itemdetalle['cod_id']);
				$datos_contrato_detalle[]=array(
					'con_id'=>$itemdetalle['con_id'],
					'per_periodicidad'=>$itemdetalle['per_periodicidad'],
					'DAP_NOMBRES'=>$itemdetalle['DAP_NOMBRES'],
					'cod_observacion'=>$itemdetalle['cod_observacion'],
					'esc_estadocontrato'=>$itemdetalle['esc_estadocontrato'],
					'cod_desde'=>$itemdetalle['cod_desde'],
					'cod_hasta'=>$itemdetalle['cod_hasta'],
					'tin_tipo'=>$itemdetalle['tin_tipo'],
					'cod_porcentajenegociado'=>$itemdetalle['cod_porcentajenegociado'],
					'cod_valornegociado'=>$itemdetalle['cod_valornegociado'],
					'cod_objetivocomprasnegociado'=>$itemdetalle['cod_objetivocomprasnegociado'],
					'cod_objetivoventasnegociado'=>$itemdetalle['cod_objetivoventasnegociado'],
					'cod_observacionproductos'=>$itemdetalle['cod_observacionproductos'],
					

					'datos_lista_compra'=>$lista_compra,
					'datos_lista_proyeccion'=>$lista_proyeccion,
				);
			}

			$respuesta_proyeccion = $proyeccion_compra_model->getProyeccioncompraseginconid($con_id);
			$datos_salida_proyeccion=[];
			if(!empty($respuesta_proyeccion)){
				for ($i=0; $i < sizeof($respuesta_proyeccion) ; $i++) { 
					$datos_salida_proyeccion[$i][0]=$respuesta_proyeccion[$i]['prc_mes'];
					$datos_salida_proyeccion[$i][1]=$respuesta_proyeccion[$i]['prc_inventario_inicial_proyectado'];
					$datos_salida_proyeccion[$i][2]=$respuesta_proyeccion[$i]['prc_ponderacion_mensual'];
					$datos_salida_proyeccion[$i][3]=$respuesta_proyeccion[$i]['prc_ponderacion_acumulada'];
					$datos_salida_proyeccion[$i][4]=$respuesta_proyeccion[$i]['prc_cumplimiento_acumulado'];
					$datos_salida_proyeccion[$i][5]=$respuesta_proyeccion[$i]['prc_compra_estimada'];
					$datos_salida_proyeccion[$i][6]=$respuesta_proyeccion[$i]['prc_compra_acumulada'];
					$datos_salida_proyeccion[$i][7]=$respuesta_proyeccion[$i]['prc_saldo'];
					$datos_salida_proyeccion[$i][8]=$respuesta_proyeccion[$i]['prc_venta'];
					$datos_salida_proyeccion[$i][9]=$respuesta_proyeccion[$i]['prc_vta_acumulada'];
					$datos_salida_proyeccion[$i][10]=$respuesta_proyeccion[$i]['prc_inv_proyectado_cierre'];
					$datos_salida_proyeccion[$i][11]=$respuesta_proyeccion[$i]['prc_dias_stock_proyectado'];
					$datos_salida_proyeccion[$i][12]=$respuesta_proyeccion[$i]['prc_vta_dist'];
					$datos_salida_proyeccion[$i][13]=$respuesta_proyeccion[$i]['prc_derecha_vta_dist'];
					$datos_salida_proyeccion[$i][14]=$respuesta_proyeccion[$i]['prc_vta_pdv'];
					$datos_salida_proyeccion[$i][15]=$respuesta_proyeccion[$i]['prc_derecha_vta_pdv'];
				}
			}

			$respuesta_proyeccion_editable = $proyeccion_compra_model->getProyeccioncompraeditableconid($con_id, json_encode($datos_salida_proyeccion));
			$editable = json_decode($respuesta_proyeccion_editable[0]["pce_json"]);
			$respuesta_proyeccion_editable[0]["pce_json"]=$editable;

			$datos_cabecera[]=array(
				'con_id'=>$value['con_id'],
				'pro_nombre'=>$value['pro_nombre'],
				'con_observacion'=>$value['con_observacion'],
				'con_dias_pago'=>$value['con_dias_pago'],
				'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				'esc_estadocontrato'=>$value['esc_estadocontrato'],
				'datos_detalle'=>$datos_contrato_detalle,
				'datos_salida_proyeccion'=>$datos_salida_proyeccion,
				'datos_salida_proyeccion_editable'=>$respuesta_proyeccion_editable,
			);
			$datos_contrato_detalle=[];
			$datos_salida_proyeccion=[];
			$respuesta_proyeccion=[];
		}

		echo json_encode($datos_cabecera);

	}

	public function datosaeditar($con_id){
		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		$contrato_detalle_model= new Contratodetallemodel();
		$contrato_cabecera_model= new Contratocabeceramodel();
		$proyeccion_contrato_model= new Proyeccioncontratomodel();
		$contrato_compra_model= new Contratocompramodel();
		$proyeccion_compra_model= new Proyeccioncompramodel();

		$proveedor_model= new Proveedormodel();
		$usuario_model= new UsuarioModel();
		$tipo_negocio_model= new Tiponegociomodel();
		$periodicidad_model= new Periodicidadmodel();
		$categoria_producto_model= new Categoriaproductomodel();
		
		$contrato_detalle_model= new Contratodetallemodel();
		$cuenta_contable_model= new Cuentacontablemodel();

		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_usuario=$usuario_model->getCoordinador();
		$datos_tipo_negocio=$tipo_negocio_model->getTiponegocio();
		$datos_periodicidad=$periodicidad_model->getPeriodicidad();
		$datos_categoria_producto=$categoria_producto_model->getCategoriaproducto();

		if(empty($con_id)){
			$session->setFlashdata('mensaje_malo', 'No hay Identificador');
			return redirect()->to(base_url('Contrato'));
		}
		
		
		$resultado_cabecera=$contrato_cabecera_model->getContratocabeceraID($con_id);
		$datos_contrato_detalle=[];
		$datos_cabecera=[];
		foreach ($resultado_cabecera as $value) {
			$resultado_detalle=$contrato_detalle_model->getContratodetallesegunconid($value['con_id']);
			
			foreach ($resultado_detalle as $itemdetalle) {
				
				if($itemdetalle['esc_id']==4 || $itemdetalle['esc_id']==5 ){
					$session->setFlashdata('mensaje_malo', 'No se puede editar los datos con estado '.$itemdetalle['esc_estadocontrato']);
					return redirect()->to(base_url('Contrato'));
				}
				$lista_compra=$contrato_compra_model->getContratocompraseguncodid($itemdetalle['cod_id']);
				$lista_proyeccion=$proyeccion_contrato_model-> getProyeccioncontratoseguncodid($itemdetalle['cod_id']);
				$datos_contrato_detalle[]=array(
					'con_id'=>$itemdetalle['con_id'],
					'per_periodicidad'=>$itemdetalle['per_periodicidad'],
					'per_id'=>$itemdetalle['per_id'],
					'DAP_NOMBRES'=>$itemdetalle['DAP_NOMBRES'],
					'USU_ID'=>$itemdetalle['USU_ID'],
					'cod_observacion'=>$itemdetalle['cod_observacion'],
					'esc_estadocontrato'=>$itemdetalle['esc_estadocontrato'],
					'cod_desde'=>$itemdetalle['cod_desde'],
					'cod_hasta'=>$itemdetalle['cod_hasta'],
					'tin_tipo'=>$itemdetalle['tin_tipo'],
					'tin_id'=>$itemdetalle['tin_id'],
					'cod_porcentajenegociado'=>$itemdetalle['cod_porcentajenegociado'],
					'cod_valornegociado'=>$itemdetalle['cod_valornegociado'],
					'cod_objetivocomprasnegociado'=>$itemdetalle['cod_objetivocomprasnegociado'],
					'cod_objetivoventasnegociado'=>$itemdetalle['cod_objetivoventasnegociado'],

					'datos_lista_compra'=>$lista_compra,
					'datos_lista_proyeccion'=>$lista_proyeccion,
				);
			}

			$respuesta_proyeccion=$proyeccion_compra_model->getProyeccioncompraseginconid($con_id);
			$datos_salida_proyeccion=[];
			if(!empty($respuesta_proyeccion)){
				for ($i=0; $i < sizeof($respuesta_proyeccion) ; $i++) { 
					$datos_salida_proyeccion[$i][0]=$respuesta_proyeccion[$i]['prc_mes'];
					$datos_salida_proyeccion[$i][1]=$respuesta_proyeccion[$i]['prc_inventario_inicial_proyectado'];
					$datos_salida_proyeccion[$i][2]=$respuesta_proyeccion[$i]['prc_ponderacion_mensual'];
					$datos_salida_proyeccion[$i][3]=$respuesta_proyeccion[$i]['prc_ponderacion_acumulada'];
					$datos_salida_proyeccion[$i][4]=$respuesta_proyeccion[$i]['prc_cumplimiento_acumulado'];
					$datos_salida_proyeccion[$i][5]=$respuesta_proyeccion[$i]['prc_compra_estimada'];
					$datos_salida_proyeccion[$i][6]=$respuesta_proyeccion[$i]['prc_compra_acumulada'];
					$datos_salida_proyeccion[$i][7]=$respuesta_proyeccion[$i]['prc_saldo'];
					$datos_salida_proyeccion[$i][8]=$respuesta_proyeccion[$i]['prc_venta'];
					$datos_salida_proyeccion[$i][9]=$respuesta_proyeccion[$i]['prc_vta_acumulada'];
					$datos_salida_proyeccion[$i][10]=$respuesta_proyeccion[$i]['prc_inv_proyectado_cierre'];
					$datos_salida_proyeccion[$i][11]=$respuesta_proyeccion[$i]['prc_dias_stock_proyectado'];
					$datos_salida_proyeccion[$i][12]=$respuesta_proyeccion[$i]['prc_vta_dist'];
					$datos_salida_proyeccion[$i][13]=$respuesta_proyeccion[$i]['prc_derecha_vta_dist'];
					$datos_salida_proyeccion[$i][14]=$respuesta_proyeccion[$i]['prc_vta_pdv'];
					$datos_salida_proyeccion[$i][15]=$respuesta_proyeccion[$i]['prc_derecha_vta_pdv'];
				}
			}

			$datos_cabecera[]=array(
				'con_id'=>$value['con_id'],
				'pro_nombre'=>$value['pro_nombre'],
				'pro_id'=>$value['pro_id'],
				'con_observacion'=>$value['con_observacion'],
				'con_dias_pago'=>$value['con_dias_pago'],
				'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				'USU_ID'=>$value['USU_ID'],				
				'esc_estadocontrato'=>$value['esc_estadocontrato'],
				'datos_detalle'=>$datos_contrato_detalle,
				'datos_salida_proyeccion'=>$datos_salida_proyeccion,
			);
			$datos_contrato_detalle=[];
			$datos_salida_proyeccion=[];
			$respuesta_proyeccion=[];
		}

		$enviar_datos=array(			
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:null , 
			'datos_usuario' => !empty($datos_usuario)?$datos_usuario:null , 
			'datos_tipo_negocio' => !empty($datos_tipo_negocio)?$datos_tipo_negocio:null , 
			'datos_periodicidad' => !empty($datos_periodicidad)?$datos_periodicidad:null , 
			'datos_categoria_producto' => !empty($datos_categoria_producto)?$datos_categoria_producto:null , 
			'datos_contrato_detalle'=>$datos_cabecera,
			
		);

		//echo '<pre>'; print_r($enviar_datos); echo '</pre>';
		//return;

		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("contrato/mostrareditar",$enviar_datos);
		echo view("layouts/footer");

	}


	public function add(){
		$session = \Config\Services::session();
		$contrato_cabecera_model= new Contratocabeceramodel();
		$contrato_detalle_model= new Contratodetallemodel();
		$proyeccion_contrato_model= new Proyeccioncontratomodel();
		$contrato_compra_model= new Contratocompramodel();
		$proyeccion_compra_model= new Proyeccioncompramodel();
		if(!empty($this->request->getPost('proid')) && !empty($this->request->getPost('usuidcoordinador'))){
			$pro_id_tipo=$this->request->getPost('proid');
			$pro_id=explode("/", $pro_id_tipo);
			$pro_id=$pro_id[0];

			$con_observacion=$this->request->getPost('observacion');
			$con_dias_pago=$this->request->getPost('diaspago');		
			$con_coordinador=$this->request->getPost('usuidcoordinador');
			$array_contrato=$this->request->getPost('arraycontrato');
			$array_contrato=json_decode($this->request->getPost('arraycontrato'),true);

			$datos_contrato_cabecera=array(
				'pro_id'=>$pro_id,
				'con_observacion'=>$con_observacion,
				'con_dias_pago'=>$con_dias_pago,
				'con_coordinador'=>$con_coordinador,
				'esc_id'=>4,
				'con_creadopor'=>$session->get('USU_ID')
			);
			$con_id=$contrato_cabecera_model->insertar($datos_contrato_cabecera);
			$con_id=$con_id[0]['con_id'];
            
			foreach ($array_contrato as $value) {
				$datos_contrato_detalle=array(
					'per_id'=>$value['per_id'],
					'cod_negociador_interno'=>$value['usuidnegociadorinterno'],
					'cod_observacion'=>$value['observacionesgenerales'],
					'esc_id'=>1,
					'cod_desde'=>$value['fecha_desde'],
					'cod_hasta'=>$value['fecha_hasta'],
					'tin_id'=>$value['tin_id'],
					'con_id'=>$con_id,
					'cod_porcentajenegociado'=>$value['porcentaje'],
					'cod_valornegociado'=>$value['valor'],
					'cod_objetivocomprasnegociado'=>$value['objetivocomprasnegociado'],
					'cod_objetivoventasnegociado'=>$value['objetivoventasnegociado'],
					'cod_observacionproductos'=>$value['cap_categoria'],
					'cap_id'=>1,//$value['cap'],
				);print_r($datos_contrato_detalle);
				$cod_id=$contrato_detalle_model->insertar($datos_contrato_detalle);
				$cod_id=$cod_id[0]['cod_id'];
				
				foreach ($value['listaproyeccion'] as $itemproyeccion) {
					$datos_proyeccion=array(
						'cod_id'=>$cod_id,
						'pry_valorventa'=>$itemproyeccion['venta'],
						'pry_valorcompra'=>$itemproyeccion['compra'],
						'pry_valorcobrado'=>0,
						'pry_stock'=>$itemproyeccion['stock'],
					);
					$proyeccion_contrato_model->insertar($datos_proyeccion);

				}

				foreach ($value['listacompra'] as $itemcompra) {
					$datos_contrato_compra=array(
						'cod_id'=>$cod_id,
						'coc_cantidad'=>$itemcompra['cantidad'],
						'coc_nombre'=>$itemcompra['nombre'],
						'coc_estado'=>1,
					);
					$contrato_compra_model->insertar($datos_contrato_compra);

				}


			}
			
			$matriz_proyeccion_compra=json_decode($this->request->getPost('matrizcontratocabecera'),true);
			
			if(!empty($matriz_proyeccion_compra)){
				for ($i=0; $i < sizeof($matriz_proyeccion_compra) ; $i++) { 
					
					$datos_proyeccion_compra=array(
						'prc_mes'=>$matriz_proyeccion_compra[$i][0],
						'prc_inventario_inicial_proyectado'=>$matriz_proyeccion_compra[$i][1],
						'prc_ponderacion_mensual'=>$matriz_proyeccion_compra[$i][2],
						'prc_ponderacion_acumulada'=>$matriz_proyeccion_compra[$i][3],
						'prc_cumplimiento_acumulado'=>$matriz_proyeccion_compra[$i][4],
						'prc_compra_estimada'=>$matriz_proyeccion_compra[$i][5],
						'prc_compra_acumulada'=>$matriz_proyeccion_compra[$i][6],
						'prc_saldo'=>$matriz_proyeccion_compra[$i][7],
						'prc_venta'=>$matriz_proyeccion_compra[$i][8],
						'prc_vta_acumulada'=>$matriz_proyeccion_compra[$i][9],
						'prc_inv_proyectado_cierre'=>$matriz_proyeccion_compra[$i][10],
						'prc_dias_stock_proyectado'=>$matriz_proyeccion_compra[$i][11],
						'prc_vta_dist'=>$matriz_proyeccion_compra[$i][12],
						'prc_derecha_vta_dist'=>$matriz_proyeccion_compra[$i][13],
						'prc_vta_pdv'=>$matriz_proyeccion_compra[$i][14],
						'prc_derecha_vta_pdv'=>$matriz_proyeccion_compra[$i][15],
						'con_id'=>$con_id,

					);
					$proyeccion_compra_model->insertar($datos_proyeccion_compra);

				}
			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Contrato')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No, Ingresado');
			return redirect()->to(base_url('Contrato')); 
		}

	}
	public function edit(){
		$session = \Config\Services::session();
		$contrato_cabecera_model= new Contratocabeceramodel();
		$contrato_detalle_model= new Contratodetallemodel();
		$proyeccion_contrato_model= new Proyeccioncontratomodel();
		$contrato_compra_model= new Contratocompramodel();
		$proyeccion_compra_model= new Proyeccioncompramodel();
		if(!empty($this->request->getPost('diaspago'))){
			$con_id=$this->request->getPost('editconid');


			$pro_id=0;
			
			$pro_id_antiguo=$this->request->getPost('editproid');
			$pro_id_tipo=$this->request->getPost('proid');

			if(!empty($pro_id_tipo)){
				$pro_id=explode("/", $pro_id_tipo);
				$pro_id=$pro_id[0];
			}else{
				$pro_id=$pro_id_antiguo;
			}
			
			

			$con_coordinador_nuevo=$this->request->getPost('usuidcoordinador');
			$con_coordinador_antiguo=$this->request->getPost('editusuid');
			$con_coordinador=0;
			
			if(!empty($con_coordinador_nuevo)){
				$con_coordinador=$con_coordinador_nuevo;
			}else{
				$con_coordinador=$con_coordinador_antiguo;
			}
			

			$con_observacion=$this->request->getPost('observacion');
			$con_dias_pago=$this->request->getPost('diaspago');		
			$array_contrato=$this->request->getPost('arraycontrato');
			$array_contrato=json_decode($this->request->getPost('arraycontrato'),true);

			$datos_contrato_cabecera=array(
				'pro_id'=>$pro_id,
				'con_observacion'=>$con_observacion,
				'con_dias_pago'=>$con_dias_pago,
				'con_coordinador'=>$con_coordinador,
				'esc_id'=>1,
			);
			$contrato_cabecera_model->actualizar($con_id,$datos_contrato_cabecera);

			$contrato_detalle=$contrato_detalle_model->getContratodetallesegunconid($con_id);

			
			foreach ($contrato_detalle as $valuedetallecontrato) {
				

				$proyeccion_contrato_model->Deleteproyeccioncontratosegunconid($valuedetallecontrato['cod_id']);
			}
			foreach ($contrato_detalle as $valuedetallecontrato) {
				$contrato_compra_model->Deletecontratocompraegunconid($valuedetallecontrato['cod_id']);
			}

			$contrato_detalle_model->Deletecontradodetallemodelsegunconid($con_id);
			

			foreach ($array_contrato as $value) {
				$datos_contrato_detalle=array(
					'per_id'=>$value['per_id'],
					'cod_negociador_interno'=>$value['usuidnegociadorinterno'],
					'cod_observacion'=>$value['observacionesgenerales'],
					'esc_id'=>1,
					'cod_desde'=>$value['fecha_desde'],
					'cod_hasta'=>$value['fecha_hasta'],
					'tin_id'=>$value['tin_id'],
					'con_id'=>$con_id,
					'cod_porcentajenegociado'=>$value['porcentaje'],
					'cod_valornegociado'=>$value['valor'],
					'cod_objetivocomprasnegociado'=>$value['objetivocomprasnegociado'],
					'cod_objetivoventasnegociado'=>$value['objetivoventasnegociado'],
				);
				$cod_id=$contrato_detalle_model->insertar($datos_contrato_detalle);
				$cod_id=$cod_id[0]['cod_id'];
				
				foreach ($value['listaproyeccion'] as $itemproyeccion) {
					$datos_proyeccion=array(
						'cod_id'=>$cod_id,
						'pry_valorventa'=>$itemproyeccion['venta'],
						'pry_valorcompra'=>$itemproyeccion['compra'],
						'pry_valorcobrado'=>0,
						'pry_stock'=>$itemproyeccion['stock'],
					);
					$proyeccion_contrato_model->insertar($datos_proyeccion);

				}

				foreach ($value['listacompra'] as $itemcompra) {
					$datos_contrato_compra=array(
						'cod_id'=>$cod_id,
						'coc_cantidad'=>$itemcompra['cantidad'],
						'coc_nombre'=>$itemcompra['nombre'],
						'coc_estado'=>1,
					);
					$contrato_compra_model->insertar($datos_contrato_compra);

				}


			}
			
			$matriz_proyeccion_compra=json_decode($this->request->getPost('matrizcontratocabecera'),true);

			$proyeccion_compra_model->Deleteproyeccioncomprasegunconid($con_id);
			
			if(!empty($matriz_proyeccion_compra)){
				for ($i=0; $i < sizeof($matriz_proyeccion_compra) ; $i++) { 
					
					$datos_proyeccion_compra=array(
						'prc_mes'=>$matriz_proyeccion_compra[$i][0],
						'prc_inventario_inicial_proyectado'=>$matriz_proyeccion_compra[$i][1],
						'prc_ponderacion_mensual'=>$matriz_proyeccion_compra[$i][2],
						'prc_ponderacion_acumulada'=>$matriz_proyeccion_compra[$i][3],
						'prc_cumplimiento_acumulado'=>$matriz_proyeccion_compra[$i][4],
						'prc_compra_estimada'=>$matriz_proyeccion_compra[$i][5],
						'prc_compra_acumulada'=>$matriz_proyeccion_compra[$i][6],
						'prc_saldo'=>$matriz_proyeccion_compra[$i][7],
						'prc_venta'=>$matriz_proyeccion_compra[$i][8],
						'prc_vta_acumulada'=>$matriz_proyeccion_compra[$i][9],
						'prc_inv_proyectado_cierre'=>$matriz_proyeccion_compra[$i][10],
						'prc_dias_stock_proyectado'=>$matriz_proyeccion_compra[$i][11],
						'prc_vta_dist'=>$matriz_proyeccion_compra[$i][12],
						'prc_derecha_vta_dist'=>$matriz_proyeccion_compra[$i][13],
						'prc_vta_pdv'=>$matriz_proyeccion_compra[$i][14],
						'prc_derecha_vta_pdv'=>$matriz_proyeccion_compra[$i][15],
						'con_id'=>$con_id,

					);
					$proyeccion_compra_model->insertar($datos_proyeccion_compra);

				}
			}

			$session->setFlashdata('mensaje_bueno', 'Dato actualizado');
			return redirect()->to(base_url('Contrato')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No, Ingresado');
			return redirect()->to(base_url('Contrato')); 
		}

	}
	public function agregardocumento(){
		$session = \Config\Services::session();
		$contrato_documento_model= new Contratodocumentacionmodel();
		if(!empty($this->request->getPost('conid'))){	
			$con_id=$this->request->getPost('conid');	
			if(!empty($this->request->getFiles())){
				if($imagefile = $this->request->getFiles()){						
					$iterator=0;
					foreach($imagefile['archivo'] as $img){

						if ($img->isValid() && ! $img->hasMoved()){							

							$iterator=1;								
							$nombre_documento = $img->getRandomName();
							$img->move(ROOTPATH.'public/upload/documentos', $nombre_documento);
							$datos_contrato_documento=array(
								'con_id'=>$con_id,
								'doc_nombredocumento'=>$nombre_documento,
								'doc_estado'=>1,
							);

							$contrato_documento_model->insertar($datos_contrato_documento);	
							
						}
						if($iterator==0){
							$session->setFlashdata('mensaje_malo', 'Ingrese archivos');
							return redirect()->to(base_url('Contrato')); 
						}
					}
					if($iterator==1){
						$session->setFlashdata('mensaje_bueno', 'Documentos registrados correctamente');
						return redirect()->to(base_url('Contrato')); 
					}

				}else{
					$session->setFlashdata('mensaje_malo', 'Ingrese archivos');
					return redirect()->to(base_url('Contrato')); 
				}			
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Contrato')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Contrato')); 
		}
		
	}
	public function obtenerdocumentosegunconid(){

		if(!empty($this->request->getPost('conid'))){
			$contrato_documento_model= new Contratodocumentacionmodel();

			$con_id=$this->request->getPost('conid');	
			$salida=[];
			
			$salida=$contrato_documento_model->getContratodocumentosegunconid($con_id);


			echo json_encode($salida);
		}else{
			echo json_encode('INGRESE DATOS');
		}
		
	}

	public function enviar($cod_id){

		$session = \Config\Services::session();
		if(empty($cod_id)){			
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Contrato'));
		}

		$contrato_detalle_model=new Contratodetallemodel();

		$resultado=$contrato_detalle_model->getUnContratodetalle($cod_id);
		
		

		if(empty($resultado)){			
			$session->setFlashdata('mensaje_malo', 'Dato no encontrado');
			return redirect()->to(base_url('Contrato'));
		}
		
		if($resultado[0]['esc_id']==1 ||$resultado[0]['esc_id']==3){				
			$data=array(
				'esc_id'=>2,
			);
			$contrato_detalle_model->actualizarsegunconid($resultado[0]['con_id'],$data);

			$session->setFlashdata('mensaje_bueno', 'Documento enviado a revisin');
			return redirect()->to(base_url('Contrato'));
		}else{
			$session->setFlashdata('mensaje_malo', 'Documento esta en estado: '.$resultado[0]['esc_estadocontrato']);
			return redirect()->to(base_url('Contrato'));
		}


	}

	public function autorizador(){
		$session = \Config\Services::session();
		if(!empty($this->request->getPost('codid'))&&!empty($this->request->getPost('idautorizacion'))){
			$contrato_detalle_model=new Contratodetallemodel();
			$cod_id=$this->request->getPost('codid');
			$id_autorizacion=$this->request->getPost('idautorizacion');		
			$observacion=$this->request->getPost('observacionautorizacion');

			$resultado=$contrato_detalle_model->getUnContratodetalle($cod_id);
			if(empty($resultado)){			
				$session->setFlashdata('mensaje_malo', 'Dato no encontrado');
				return redirect()->to(base_url('Contrato'));
			}
			
			$data=array(
				'esc_id'=>$id_autorizacion,
			);			
			$contrato_detalle_model->actualizarsegunconid($resultado[0]['con_id'],$data);

			$data=array(
				'con_observacion_autorizador'=>$observacion,
			);
			$contrato_cabecera_model= new Contratocabeceramodel();
			$contrato_cabecera_model->actualizar($resultado[0]['con_id'],$data);

			$session->setFlashdata('mensaje_bueno', 'Guardado');
			return redirect()->to(base_url('Contrato'));
		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Contrato'));
		}
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}

	public function addcobroganancia(){
		$session = \Config\Services::session();
		$contrato_cobro_ganancia_model= new Contratocobrogananciamodel();
		if(!empty($this->request->getPost('cgccodid')) && !empty($this->request->getPost('fechacobro')) && !empty($this->request->getPost('numerocomprobante')) && !empty($this->request->getPost('ctaid')) && !empty($this->request->getPost('cgcvalor'))){
			
			$fecha_ingreso=date('Y-m-d H:i:s');	
			$cod_id=$this->request->getPost('cgccodid');
			$cgc_fechacobro=$this->request->getPost('fechacobro');
			$cgc_numerocomprobante=$this->request->getPost('numerocomprobante');
			$cgc_cuentacontable=$this->request->getPost('ctaid');
			$cgc_valor=$this->request->getPost('cgcvalor');

			$datos_contrato_cobro_ganancia=array(

				'cgc_fechaingreso'=>$fecha_ingreso,
				'cgc_fechacobro'=>$cgc_fechacobro,
				'cgc_numerocomprobante'=>$cgc_numerocomprobante,
				'cgc_cuentacontable'=>$cgc_cuentacontable,
				'cod_id'=>$cod_id,
				'cgc_valor'=>$cgc_valor,
			);


			$contrato_cobro_ganancia_model->insertar($datos_contrato_cobro_ganancia);

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Contrato')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No, Ingresado');
			return redirect()->to(base_url('Contrato')); 
		}

	}
	
	public function negociacionespagado(){
		$contrato_detalle_model= new Contratodetallemodel();
		$contrato_cobro_ganancia_model= new Contratocobrogananciamodel();
		$cuenta_contable_model= new Cuentacontablemodel();

		$datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();

		$resultado_contrato_detalle=$contrato_detalle_model->getContratodetalle();

		$datos_detalle=[];
		$datos_cobro_ganancia=[];
		foreach ($resultado_contrato_detalle as $value) {
			$datos_cobro_ganancia =$contrato_cobro_ganancia_model->getcobrogananciaseguncodid($value['cod_id']);


			$valor_enero=0;			
			$valor_febrero=0;
			$valor_marzo=0;
			$valor_abril=0;
			$valor_mayo=0;
			$valor_junio=0;
			$valor_julio=0;
			$valor_agosto=0;
			$valor_septiembre=0;
			$valor_octubre=0;
			$valor_noviembre=0;
			$valor_diciembre=0;

			$numero_comprobante_enero='';			
			$numero_comprobante_febrero='';
			$numero_comprobante_marzo='';
			$numero_comprobante_abril='';
			$numero_comprobante_mayo='';
			$numero_comprobante_junio='';
			$numero_comprobante_julio='';
			$numero_comprobante_agosto='';
			$numero_comprobante_septiembre='';
			$numero_comprobante_octubre='';
			$numero_comprobante_noviembre='';
			$numero_comprobante_diciembre='';

			$cta_id_enero=0;			
			$cta_id_febrero=0;
			$cta_id_marzo=0;
			$cta_id_abril=0;
			$cta_id_mayo=0;
			$cta_id_junio=0;
			$cta_id_julio=0;
			$cta_id_agosto=0;
			$cta_id_septiembre=0;
			$cta_id_octubre=0;
			$cta_id_noviembre=0;
			$cta_id_diciembre=0;

			foreach ($datos_cobro_ganancia as  $valuecgc) {
				if($valuecgc['cgc_mescorrespondiente']=='ENERO'){
					$valor_enero=$valuecgc['cgc_valor'];
					$numero_comprobante_enero=$valuecgc['cgc_numerocomprobante'];
					$cta_id_enero=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='FEBRERO'){
					$valor_febrero=$valuecgc['cgc_valor'];
					$numero_comprobante_febrero=$valuecgc['cgc_numerocomprobante'];
					$cta_id_febrero=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='MARZO'){
					$valor_marzo=$valuecgc['cgc_valor'];
					$numero_comprobante_marzo=$valuecgc['cgc_numerocomprobante'];
					$cta_id_marzo=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='ABRIL'){
					$valor_abril=$valuecgc['cgc_valor'];
					$numero_comprobante_abril=$valuecgc['cgc_numerocomprobante'];
					$cta_id_abril=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='MAYO'){
					$valor_mayo=$valuecgc['cgc_valor'];
					$numero_comprobante_mayo=$valuecgc['cgc_numerocomprobante'];
					$cta_id_mayo=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='JUNIO'){
					$valor_junio=$valuecgc['cgc_valor'];
					$numero_comprobante_junio=$valuecgc['cgc_numerocomprobante'];
					$cta_id_junio=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='JULIO'){
					$valor_julio=$valuecgc['cgc_valor'];
					$numero_comprobante_julio=$valuecgc['cgc_numerocomprobante'];
					$cta_id_julio=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='AGOSTO'){
					$valor_agosto=$valuecgc['cgc_valor'];
					$numero_comprobante_agosto=$valuecgc['cgc_numerocomprobante'];
					$cta_id_agosto=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='SEPTIEMBRE'){
					$valor_septiembre=$valuecgc['cgc_valor'];
					$numero_comprobante_septiembre=$valuecgc['cgc_numerocomprobante'];
					$cta_id_septiembre=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='OCTUBRE'){
					$valor_octubre=$valuecgc['cgc_valor'];
					$numero_comprobante_octubre=$valuecgc['cgc_numerocomprobante'];
					$cta_id_octubre=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='NOVIEMBRE'){
					$valor_noviembre=$valuecgc['cgc_valor'];
					$numero_comprobante_noviembre=$valuecgc['cgc_numerocomprobante'];
					$cta_id_noviembre=$valuecgc['cgc_cuentacontable'];
				}
				if($valuecgc['cgc_mescorrespondiente']=='DICIEMBRE'){
					$valor_diciembre=$valuecgc['cgc_valor'];
					$numero_comprobante_diciembre=$valuecgc['cgc_numerocomprobante'];
					$cta_id_diciembre=$valuecgc['cgc_cuentacontable'];
				}
			}



			$datos_detalle[]=array(


				'cod_id'=>$value['cod_id'],
				'pro_nombre'=>$value['pro_nombre'],
				'tin_tipo'=>$value['tin_tipo'],
				'cod_porcentajenegociado'=>$value['cod_porcentajenegociado'],
				'cod_valornegociado'=>$value['cod_valornegociado'],
				'valor_enero'=>$valor_enero,
				'valor_febrero'=>$valor_febrero,
				'valor_marzo'=>$valor_marzo,
				'valor_abril'=>$valor_abril,
				'valor_mayo'=>$valor_mayo,
				'valor_junio'=>$valor_junio,
				'valor_julio'=>$valor_julio,
				'valor_agosto'=>$valor_agosto,
				'valor_septiembre'=>$valor_septiembre,
				'valor_octubre'=>$valor_octubre,
				'valor_noviembre'=>$valor_noviembre,
				'valor_diciembre'=>$valor_diciembre,

				'numero_comprobante_enero'=>$numero_comprobante_enero,
				'numero_comprobante_febrero'=>$numero_comprobante_febrero,
				'numero_comprobante_marzo'=>$numero_comprobante_marzo,
				'numero_comprobante_abril'=>$numero_comprobante_abril,
				'numero_comprobante_mayo'=>$numero_comprobante_mayo,
				'numero_comprobante_junio'=>$numero_comprobante_junio,
				'numero_comprobante_julio'=>$numero_comprobante_julio,
				'numero_comprobante_agosto'=>$numero_comprobante_agosto,
				'numero_comprobante_septiembre'=>$numero_comprobante_septiembre,
				'numero_comprobante_octubre'=>$numero_comprobante_octubre,
				'numero_comprobante_noviembre'=>$numero_comprobante_noviembre,
				'numero_comprobante_diciembre'=>$numero_comprobante_diciembre,

				'cta_id_enero'=>$cta_id_enero,
				'cta_id_febrero'=>$cta_id_febrero,
				'cta_id_marzo'=>$cta_id_marzo,
				'cta_id_abril'=>$cta_id_abril,
				'cta_id_mayo'=>$cta_id_mayo,
				'cta_id_junio'=>$cta_id_junio,
				'cta_id_julio'=>$cta_id_julio,
				'cta_id_agosto'=>$cta_id_agosto,
				'cta_id_septiembre'=>$cta_id_septiembre,
				'cta_id_octubre'=>$cta_id_octubre,
				'cta_id_noviembre'=>$cta_id_noviembre,
				'cta_id_diciembre'=>$cta_id_diciembre,
				
			);
			$datos_cobro_ganancia=[];
			$valor_enero=0;
			$valor_febrero=0;
			$valor_marzo=0;
			$valor_abril=0;
			$valor_mayo=0;
			$valor_junio=0;
			$valor_julio=0;
			$valor_agosto=0;
			$valor_septiembre=0;
			$valor_octubre=0;
			$valor_noviembre=0;
			$valor_diciembre=0;

			$numero_comprobante_enero='';			
			$numero_comprobante_febrero='';
			$numero_comprobante_marzo='';
			$numero_comprobante_abril='';
			$numero_comprobante_mayo='';
			$numero_comprobante_junio='';
			$numero_comprobante_julio='';
			$numero_comprobante_agosto='';
			$numero_comprobante_septiembre='';
			$numero_comprobante_octubre='';
			$numero_comprobante_noviembre='';
			$numero_comprobante_diciembre='';

			$cta_id_enero=0;			
			$cta_id_febrero=0;
			$cta_id_marzo=0;
			$cta_id_abril=0;
			$cta_id_mayo=0;
			$cta_id_junio=0;
			$cta_id_julio=0;
			$cta_id_agosto=0;
			$cta_id_septiembre=0;
			$cta_id_octubre=0;
			$cta_id_noviembre=0;
			$cta_id_diciembre=0;
		}
		
		$enviar_datos=array(			
			'resultado_contrato_detalle' => !empty($datos_detalle)?$datos_detalle:null ,
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:null , 
			
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("contrato/negociacionpagado",$enviar_datos);
		echo view("layouts/footer");
		
	}


	public function addnegocionespagado(){	

		$session = \Config\Services::session();

		if(!empty($this->request->getPost('codid')) && !empty($this->request->getPost('mes')) && !empty($this->request->getPost('valor')) && !empty($this->request->getPost('numerocomprobante')) && !empty($this->request->getPost('ctaid'))){

			$cod_id=$this->request->getPost('codid');
			
			$cgc_mescorrespondiente=$this->request->getPost('mes');
			$cgc_anocorrespondiente=date('Y');
			
			$cgc_valor=$this->request->getPost('valor');

			$cgc_numerocomprobante=$this->request->getPost('numerocomprobante');

			$cgc_cuentacontable=$this->request->getPost('ctaid');
			

			$contrato_cobro_ganancia_model= new Contratocobrogananciamodel();

			$resultado=$contrato_cobro_ganancia_model->getUncobrogananciaseguncodidmes($cod_id,$cgc_mescorrespondiente);
			

			if(!empty($resultado)){
				$resultado[0]['cgc_valor']=$cgc_valor;
				$resultado[0]['cgc_numerocomprobante']=$cgc_numerocomprobante;
				$resultado[0]['cgc_cuentacontable']=$cgc_cuentacontable;
				$resultado[0]['cgc_anocorrespondiente']=$cgc_anocorrespondiente;

				$contrato_cobro_ganancia_model->actualizar($cod_id,$cgc_mescorrespondiente,$resultado[0]);
				$session->setFlashdata('mensaje_bueno', 'Actualizado');
				return redirect()->to(base_url('Contrato/negociacionespagado')); 
			}else{

				$datos=array(
					'cod_id'=>$cod_id,
					'cgc_mescorrespondiente'=>$cgc_mescorrespondiente,
					'cgc_valor'=>$cgc_valor,
					'cgc_numerocomprobante'=>$cgc_numerocomprobante,
					'cgc_cuentacontable'=>$cgc_cuentacontable,
					'cgc_anocorrespondiente'=>$cgc_anocorrespondiente,
				);
				$contrato_cobro_ganancia_model->insertar($datos);
				$session->setFlashdata('mensaje_bueno', 'Ingresado');
				return redirect()->to(base_url('Contrato/negociacionespagado')); 

			}

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Contrato/negociacionespagado')); 
		}

	}
	
	public function negociacionesganado(){
		$contrato_detalle_model= new Contratodetallemodel();
		
		$negociaciones_ganado_model= new Negociacionesganadomodel();
		
		

		$resultado_contrato_detalle=$contrato_detalle_model->getContratodetalle();

		$datos_detalle=[];
		$datos_negociacion_ganado=[];
		foreach ($resultado_contrato_detalle as $value) {

			$datos_negociacion_ganado =$negociaciones_ganado_model->getnegociacionganadaseguncodid($value['cod_id']);


			$valor_enero=0;			
			$valor_febrero=0;
			$valor_marzo=0;
			$valor_abril=0;
			$valor_mayo=0;
			$valor_junio=0;
			$valor_julio=0;
			$valor_agosto=0;
			$valor_septiembre=0;
			$valor_octubre=0;
			$valor_noviembre=0;
			$valor_diciembre=0;

			

			foreach ($datos_negociacion_ganado as  $valuecgc) {
				if($valuecgc['neg_mes']=='ENERO'){
					$valor_enero=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='FEBRERO'){
					$valor_febrero=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='MARZO'){
					$valor_marzo=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='ABRIL'){
					$valor_abril=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='MAYO'){
					$valor_mayo=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='JUNIO'){
					$valor_junio=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='JULIO'){
					$valor_julio=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='AGOSTO'){
					$valor_agosto=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='SEPTIEMBRE'){
					$valor_septiembre=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='OCTUBRE'){
					$valor_octubre=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='NOVIEMBRE'){
					$valor_noviembre=$valuecgc['neg_valor'];
					
				}
				if($valuecgc['neg_mes']=='DICIEMBRE'){
					$valor_diciembre=$valuecgc['neg_valor'];
					
				}
			}



			$datos_detalle[]=array(


				'cod_id'=>$value['cod_id'],
				'pro_nombre'=>$value['pro_nombre'],
				'tin_tipo'=>$value['tin_tipo'],
				'tin_id'=>$value['tin_id'],
				'cod_porcentajenegociado'=>$value['cod_porcentajenegociado'],
				'cod_valornegociado'=>$value['cod_valornegociado'],
				'valor_enero'=>$valor_enero,
				'valor_febrero'=>$valor_febrero,
				'valor_marzo'=>$valor_marzo,
				'valor_abril'=>$valor_abril,
				'valor_mayo'=>$valor_mayo,
				'valor_junio'=>$valor_junio,
				'valor_julio'=>$valor_julio,
				'valor_agosto'=>$valor_agosto,
				'valor_septiembre'=>$valor_septiembre,
				'valor_octubre'=>$valor_octubre,
				'valor_noviembre'=>$valor_noviembre,
				'valor_diciembre'=>$valor_diciembre,

				
			);
			$datos_cobro_ganancia=[];
			$valor_enero=0;
			$valor_febrero=0;
			$valor_marzo=0;
			$valor_abril=0;
			$valor_mayo=0;
			$valor_junio=0;
			$valor_julio=0;
			$valor_agosto=0;
			$valor_septiembre=0;
			$valor_octubre=0;
			$valor_noviembre=0;
			$valor_diciembre=0;
			
		}
		
		$enviar_datos=array(			
			'resultado_contrato_detalle' => !empty($datos_detalle)?$datos_detalle:null ,
			
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("contrato/negociacionganado",$enviar_datos);
		echo view("layouts/footer");
		
	}


	public function addnegocionesganado(){	

		$session = \Config\Services::session();

		if(!empty($this->request->getPost('codid')) && !empty($this->request->getPost('mes')) && !empty($this->request->getPost('valor')) ){

			$cod_id=$this->request->getPost('codid');
			
			$neg_mes=$this->request->getPost('mes');
			$neg_anio=date('Y');
			
			$neg_valor=$this->request->getPost('valor');

			
			

			$negociaciones_ganado_model= new Negociacionesganadomodel();

			$resultado=$negociaciones_ganado_model->getUnnegociacionganadoseguncodidmes($cod_id,$neg_mes);
			

			if(!empty($resultado)){
				$resultado[0]['neg_valor']=$neg_valor;
				$resultado[0]['neg_anio']=$neg_anio;

				$negociaciones_ganado_model->actualizar($cod_id,$neg_mes,$resultado[0]);
				$session->setFlashdata('mensaje_bueno', 'Actualizado');
				return redirect()->to(base_url('Contrato/negociacionesganado')); 
			}else{

				$datos=array(
					'cod_id'=>$cod_id,
					'neg_mes'=>$neg_mes,
					'neg_valor'=>$neg_valor,					
					'neg_anio'=>$neg_anio,
				);
				$negociaciones_ganado_model->insertar($datos);
				$session->setFlashdata('mensaje_bueno', 'Ingresado');
				return redirect()->to(base_url('Contrato/negociacionesganado')); 

			}

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Contrato/negociacionesganado')); 
		}

	}


	
}