<?php

namespace App\Controllers;
use App\Models\Cuentacontablemodel;
use App\Models\UsuarioModel;

class Cuentacontable extends BaseController
{

	public function index(){
		$cuenta_contable_model= new Cuentacontablemodel();
		$datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();
		
		


		$enviar_datos=array(
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:null , 
		);
        $datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cuentacontable/list",$enviar_datos);
		echo view("layouts/footer");
	}
    
	
	public function add(){
		$session = \Config\Services::session();
		$cuenta_contable_model= new Cuentacontablemodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('cuentacontable')) && !empty($this->request->getPost('numerocuentacontable'))){
				$cta_cuenta=$this->request->getPost('cuentacontable');
				$cta_codigo=$this->request->getPost('numerocuentacontable');
				$ingresar_datos=array(
				
					'cta_cuenta'=>$cta_cuenta,
					'cta_codigo'=>$cta_codigo,
					'cta_estado'=>1
				);
				$cuenta_contable_model->insertar($ingresar_datos);
				
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Cuentacontable')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cuentacontable')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$cuenta_contable_model= new Cuentacontablemodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editcuentacontable')) && !empty($this->request->getPost('editctaid')) && !empty($this->request->getPost('editnumerocuentacontable'))){
				$cta_cuenta=$this->request->getPost('editcuentacontable');
				$cta_id=$this->request->getPost('editctaid');
				$cta_codigo=$this->request->getPost('editnumerocuentacontable');
				$editar_datos=array(
					'cta_cuenta'=>$cta_cuenta,
					'cta_codigo'=>$cta_codigo,
					'cta_estado'=>1
				);
				$cuenta_contable_model->actualizar($cta_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Cuentacontable')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cuentacontable')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$cuenta_contable_model= new Cuentacontablemodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'cta_estado'=>0
				);
				$cuenta_contable_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Cuentacontable')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cuentacontable')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}