<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Descuentosmodel;
use App\Models\Tipofranquiciacomisionesmodel;
use App\Models\Descuentospdvtipofranquiciamodel;

class Descuentos extends BaseController
{

	public function index(){
		$datos = $this->datosMenu();
		$punto_venta_model=new Puntoventamodel();
		$descuentos_model=new Descuentosmodel();
		$tipo_franquicia_comisiones_model=new Tipofranquiciacomisionesmodel();

		$datos_punto_venta = $punto_venta_model->getPuntoventa();
		$datos_descuento= $descuentos_model->getDescuentos();
		$datos_tipo_franquicia_comisiones= $tipo_franquicia_comisiones_model->getTipofranquiciacomisiones();

		$enviar_datos=array(
			'datos_punto_venta'=>$datos_punto_venta,
			'datos_descuento'=>$datos_descuento,
			'datos_tipo_franquicia_comisiones'=>$datos_tipo_franquicia_comisiones,
		);

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("descuentos/list",$enviar_datos);
		echo view("layouts/footer");
	}

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('arraylistadescuento'))){

			$descuentos_model=new Descuentosmodel();
			$descuentos_pdv_tipo_franquicia_model= new Descuentospdvtipofranquiciamodel();
			$lista_descuento=json_decode($this->request->getPost('arraylistadescuento'),true);
			$todos_nombre='';
			foreach ($lista_descuento as $value) {

				
				$busqueda='';
				if($value['lista_franquicias'][0]=='Todos'){
					$busqueda='Tipo Franquicia';
				}else{
					$busqueda='PDV';
					
				}
				
				$datos=array(
					'des_nombre'=>$value['nombre_descuento'],
					'des_fecha_inicio'=>$value['fecha_inicio'],
					'des_frecuencia'=>$value['frecuencia'],
					'des_fecha_desde'=>$value['fecha_desde'],
					'des_fecha_hasta'=>$value['fecha_hasta'],
					'des_nombre_franquicias'=>$busqueda,
					'des_tipo'=>$value['tipo'],
					'des_valor'=>$value['valor'],
					'des_estado'=>1,
				);
				$descuentos_model->insertar($datos);
				$des_id =$descuentos_model->getDescuentosmaxid();
				$des_id =$des_id[0]['des_id'];
				

				if($busqueda=='Tipo Franquicia'){
					foreach ($value['lista_tipos_franquicias'] as $item) {
						$descuento_pdv_tipo_franquicia=array(
							'tfc_id'=>$item['tfc_id'],
							'puv_id'=>0,
							'des_id'=>$des_id,
						);
						$descuentos_pdv_tipo_franquicia_model->insertar($descuento_pdv_tipo_franquicia);
					}
				}
				if($busqueda=='PDV'){
					foreach ($value['lista_franquicias'] as $item) {
						$descuento_pdv_tipo_franquicia=array(
							'tfc_id'=>0,
							'puv_id'=>$item['puv_id'],
							'des_id'=>$des_id,
						);
						$descuentos_pdv_tipo_franquicia_model->insertar($descuento_pdv_tipo_franquicia);
					}
				}
			}
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos')); 
		}
	}
	public function edit(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('editdesid')) && !empty($this->request->getPost('editdescuento')) && !empty($this->request->getPost('editfechainiciodescuento')) && !empty($this->request->getPost('editfrecuencia')) && !empty($this->request->getPost('editvalordescuento')) && !empty($this->request->getPost('tipo'))  ){

			$descuentos_model=new Descuentosmodel();
			$des_id=$this->request->getPost('editdesid');
			$des_nombre=$this->request->getPost('editdescuento');
			$des_fecha_inicio=$this->request->getPost('editfechainiciodescuento');
			$des_frecuencia=$this->request->getPost('editfrecuencia');
			$des_tipo=$this->request->getPost('tipo');
			$des_valor=$this->request->getPost('editvalordescuento');

			if($des_frecuencia=='mensual'){
				if(empty($this->request->getPost('editfechadesde')) && empty($this->request->getPost('editfechahasta'))){
					$session->setFlashdata('mensaje_malo', 'No hay Fechas');
					return redirect()->to(base_url('Descuentos')); 
				}
				$des_fecha_desde=$this->request->getPost('editfechadesde');
				$des_fecha_hasta=$this->request->getPost('editfechahasta');

			}else{
				$des_fecha_desde='0000-00-00';
				$des_fecha_hasta='0000-00-00';
			}

			$datos=array(

				'des_nombre'=>$des_nombre,
				'des_fecha_inicio'=>$des_fecha_inicio,
				'des_frecuencia'=>$des_frecuencia,
				'des_fecha_desde'=>$des_fecha_desde,
				'des_fecha_hasta'=>$des_fecha_hasta,
				'des_tipo'=>$des_tipo,
				'des_valor'=>$des_valor,
				'des_estado'=>1,
			);

			$descuentos_model->actualizar($des_id,$datos);
			$session->setFlashdata('mensaje_bueno', 'Dato Editado');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentos')); 
		}
	}
	public function eliminar($des_id){
		$session = \Config\Services::session();
		
		if(!empty($des_id)){

			$descuentos_model=new Descuentosmodel();
			$descuentos_model->eliminar($des_id);
			$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentos')); 
		}
	}

	public function leerdescuento(){
		$datos = $this->datosMenu();		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("descuentos/leerdescuento");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		

		
		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('DESCUENTOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "DESCUENTOS"');
				return redirect()->to(base_url('Descuentos/leerdescuento'));
			}    

			$data=[];

			$pdv_no_encontrados='';
			$des_nombre_franquicias='';
			$des_nombre='';
			$des_fecha_inicio= '';
			$des_frecuencia=  '';
			$des_fecha_desde=  '';
			$des_fecha_has= '';
			$des_tipo=  '';
			$des_valor=  '';
			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{

					

					if($row==2){
						$des_nombre = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
						$des_fecha_inicio= $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						if(empty($des_fecha_inicio)){
							$session->setFlashdata('mensaje_malo', 'Ingrese fecha de inicio');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						if(empty($des_nombre)){
							$session->setFlashdata('mensaje_malo', 'Ingrese nombre del descuento');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						$des_fecha_inicio = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_inicio);            
						$des_fecha_inicio =$des_fecha_inicio->format('Y-m-d');



						$des_frecuencia= $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						if($des_frecuencia=='indefinido'||$des_frecuencia=='mensual'){
							
						}else{
							$session->setFlashdata('mensaje_malo', 'Frecuencia : indefinido o  mensual');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						
						if($des_frecuencia=='mensual'){
							$des_fecha_desde= $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
							if(empty($des_fecha_desde)){
								$session->setFlashdata('mensaje_malo', 'Ingrese fecha desde');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
							$des_fecha_desde = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_desde);           
							$des_fecha_desde =$des_fecha_desde->format('Y-m-d');
							$des_fecha_hasta= $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
							if(empty($des_fecha_hasta)){
								$session->setFlashdata('mensaje_malo', 'Ingrese fecha hasta');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
							$des_fecha_hasta = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_hasta);           
							$des_fecha_hasta =$des_fecha_hasta->format('Y-m-d');

							if($des_fecha_hasta<$des_fecha_desde){
								$session->setFlashdata('mensaje_malo', 'fecha hasta es menor que fecha desde');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
						}else{
							$des_fecha_desde='0000-00-00';
							$des_fecha_hasta='0000-00-00';
						}

						$des_tipo= $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
						if($des_tipo=='Post-Facturacion'||$des_tipo=='Pre-Facturacion'){
							
						}else{
							$session->setFlashdata('mensaje_malo', 'Tipo : Post-Facturacion o  Pre-Facturacion');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						$des_valor= $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
						if(!is_numeric($des_valor)){
							$des_valor=0;
						}
					}
					$nombre = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue(); 

					
					

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($nombre);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($puv_id!=0){
						$des_nombre_franquicias=$des_nombre_franquicias." ".$nombre.",";						
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$nombre;
					}



				}
				break;

			}
			$datos = $this->datosMenu();
			$data[]=array(
				'des_nombre'=>$des_nombre,
				'des_fecha_inicio'=>$des_fecha_inicio,
				'des_frecuencia'=>$des_frecuencia,
				'des_fecha_desde'=>$des_fecha_desde,
				'des_fecha_hasta'=>$des_fecha_hasta,
				'des_tipo'=>$des_tipo,
				'des_valor'=>$des_valor,
				'des_nombre_franquicias'=>$des_nombre_franquicias,
			);
			$enviar_datos=array(        
				'mensaje'=>$pdv_no_encontrados,
				'data'=>$data,
			);

			

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("descuentos/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos')) ){
			$descuentos_model=new Descuentosmodel();
			$datos =$this->request->getPost('datos');		
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_descuento=array(

					'des_nombre'=>$value['des_nombre'],
					'des_fecha_inicio'=>$value['des_fecha_inicio'],
					'des_frecuencia'=>$value['des_frecuencia'],
					'des_fecha_desde'=>$value['des_fecha_desde'],
					'des_fecha_hasta'=>$value['des_fecha_hasta'],
					'des_tipo'=>$value['des_tipo'],
					'des_valor'=>$value['des_valor'],
					'des_nombre_franquicias'=>$value['des_nombre_franquicias'],
					'des_estado'=>1,

				);				
				$descuentos_model->insertar($datos_descuento);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}

	}



	public function mostrardatosundescuento()
	{
		$descuentos_pdv_tipo_franquicia_model= new Descuentospdvtipofranquiciamodel();

		$des_id= $this->request->getPost('des_id');
		$tipo= $this->request->getPost('tipo');
		
		$resultado=[];
		if(!empty($des_id)&&!empty($tipo)){
			$resultado= $descuentos_pdv_tipo_franquicia_model->getDescuentomensualdesid($des_id,$tipo);
		}
		

		return json_encode($resultado);
	}
	
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}