<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Ivarentapdvmodel;

class Ivarentapdv extends BaseController
{

	public function index(){
		$iva_renta_pdv_model= new Ivarentapdvmodel();
		$datos_iva_renta_pdv=$iva_renta_pdv_model->getIvarentapdv();

		$enviar_datos=array(
			'datos_iva_renta_pdv' => !empty($datos_iva_renta_pdv)?$datos_iva_renta_pdv:[] , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("ivarentapdv/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$iva_renta_pdv_model= new Ivarentapdvmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('renta')) && !empty($this->request->getPost('iva'))){
				$irp_retencion_iva=$this->request->getPost('iva');
				$irp_retencion_renta=$this->request->getPost('renta');
				$irp_iva=$this->request->getPost('valoriva');
				$ingresar_datos=array(
					'irp_retencion_iva'=>$irp_retencion_iva,
					'irp_retencion_renta'=>$irp_retencion_renta,
					'irp_iva'=>$irp_iva,
					'irp_estado'=>1
				);
				$iva_renta_pdv_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Ivarentapdv')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ivarentapdv')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$iva_renta_pdv_model= new Ivarentapdvmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editiva')) && !empty($this->request->getPost('editrenta')) && !empty($this->request->getPost('editirpid'))){
				$irp_retencion_iva=$this->request->getPost('editiva');
				$irp_retencion_renta=$this->request->getPost('editrenta');
				$irp_id=$this->request->getPost('editirpid');
				$irp_iva=$this->request->getPost('editvaloriva');
				$editar_datos=array(
					'irp_retencion_iva'=>$irp_retencion_iva,
					'irp_retencion_renta'=>$irp_retencion_renta,
					'irp_iva'=>$irp_iva,
					'irp_estado'=>1
				);
				$iva_renta_pdv_model->actualizar($irp_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Ivarentapdv')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ivarentapdv')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$iva_renta_pdv_model= new Ivarentapdvmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'irp_estado'=>0
				);
				$iva_renta_pdv_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Ivarentapdv')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ivarentapdv')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}