<?php

namespace App\Controllers;
use App\Models\Areamodel;
use App\Models\UsuarioModel;
use App\Models\Proveedormodel;
use App\Models\Formacobrofranquiciadomodel;
use App\Models\Tipofranquiciamodel;
use App\Models\Tipotacticasmodel;
use App\Models\Destinoactivomodel;
use App\Models\Planmodel;
use App\Models\Planmercadeotipotacticamodel;
use App\Models\Planmercadeotacticamodel;
use App\Models\Planmercadeoherramientamodel;
use App\Models\Planmercadeomaterialmodel;
use App\Models\Auspicianteplanmercadeomodel;
use App\Models\Planmercadeodocumentomodel;
use App\Models\Planmercadeoestadomodel;
use App\Models\Planmercadeosolicitantemodel;
use App\Models\Planmercadeotipoalcancemodel;
use App\Models\Asumemodel;
use App\Models\Planmercadeoasumemodel;
use App\Models\Cuentacontablemodel;
use App\Models\Planmercadeomaterialrealmodel;
use App\Models\Historialresumenplanesmodel;
use App\Models\Auspicianterealmodel;
use App\Models\DocumentoAuspiciomodel;
class Plan extends BaseController
{
	public function index(){
		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$plan_mercadeo_estado_model= new Planmercadeoestadomodel();
        $plan_mercadeo_model=new Planmodel();
		$datos_plan_mercadeo_estado=$plan_mercadeo_estado_model->getPlanmercadeoestado();
		$coordinadores=$plan_mercadeo_model->getCoordinadoresPlan();
		$enviar_datos=array(
			'datos_plan_mercadeo_estado'=>$datos_plan_mercadeo_estado,
			'rol_id'=>$session->get('ROL_ID'),
			'coordinadores'=>$coordinadores,
		);

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/opciones",$enviar_datos);
		echo view("layouts/footer");
		
	}
	
	public function filtroAuspicios(){
		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$plan_mercadeo_estado_model= new Planmercadeoestadomodel();
        $plan_mercadeo_model=new Planmodel();
		$datos_plan_mercadeo_estado=$plan_mercadeo_estado_model->getPlanmercadeoestado();
		$coordinadores=$plan_mercadeo_model->getCoordinadoresPlan();
		$enviar_datos=array(
			'datos_plan_mercadeo_estado'=>$datos_plan_mercadeo_estado,
			'rol_id'=>$session->get('ROL_ID'),
			'coordinadores'=>$coordinadores,
		);

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/opcionesauspicios",$enviar_datos);
		echo view("layouts/footer");
		
	}
	
	public function mostraradd($plm_id=''){

		$session = \Config\Services::session();
        
	    $p=$this->PresupuestoAreaRestante();
	    $session->set('presupuesto', $p);
        
		$area_model= new Areamodel();
		$usuario_model= new UsuarioModel();		
		$proveedor_model= new Proveedormodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$tipo_franquiciado_model= new Tipofranquiciamodel();
		$tipo_tactica_model= new Tipotacticasmodel();
		$destino_activo_model= new Destinoactivomodel();
		$plan_mercadeo_tipo_alcance= new Planmercadeotipoalcancemodel();
		$asume_model= new Asumemodel();
		$cuenta_contable_model= new Cuentacontablemodel();
		$plan=new Planmodel();

		$datos_area=$area_model->getArea();
		$datos_usuario=$usuario_model->getUsuario();
		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_tipo_franquicia=$tipo_franquiciado_model->getTipofranquicia();
		$datos_tipo_tacticas=$tipo_tactica_model->getTipotacticas();
		$datos_desnito_activo=$destino_activo_model->getdestinoactivo();
		$datos_plan_mercadeo_tipo_alcance=$plan_mercadeo_tipo_alcance->getPlanmercadeotipoalcance();
		$datos_asume=$asume_model->getAsume();
		$datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();
        $codigo_plan=$plan->getCodigoPlan();

		$enviar_datos=array(
			'datos_area' => !empty($datos_area)?$datos_area:null , 
			'datos_usuario' => !empty($datos_usuario)?$datos_usuario:null , 
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:null , 
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:null , 
			'datos_tipo_franquicia' => !empty($datos_tipo_franquicia)?$datos_tipo_franquicia:null , 
			'datos_tipo_tacticas' => !empty($datos_tipo_tacticas)?$datos_tipo_tacticas:null , 
			'datos_desnito_activo' => !empty($datos_desnito_activo)?$datos_desnito_activo:null ,
			'plm_id' => $plm_id ,
			'datos_plan_mercadeo_tipo_alcance' => !empty($datos_plan_mercadeo_tipo_alcance)?$datos_plan_mercadeo_tipo_alcance:[] ,
			'datos_asume' => !empty($datos_asume)?$datos_asume:[] ,
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:[] ,
			'codigo_plan' => !empty($codigo_plan)?$codigo_plan:null , 
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
			
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/add",$enviar_datos);
		echo view("layouts/footer");
		
	}
	public function mostrarlist($plm_id_padre=''){

		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$documento_auspicio_model=new DocumentoAuspiciomodel();
		
		
		$plan_model= new Planmodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$proveedor_model= new Proveedormodel();
		
		$texto_doc_auspicio=$documento_auspicio_model->getTextoDocumentoAuspicio();
		
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_proveedor=$proveedor_model->getProveedor();
        

		$plm_nombreplan=$this->request->getPost('nombreplan');
		$plm_fechacreacion=$this->request->getPost('fechainicio');
		if($plm_fechacreacion!=''){
		    $fechahasta=$plm_fechacreacion.'-'.date('t',strtotime($plm_fechacreacion));
    		$fechadesde=$plm_fechacreacion.'-'.date('d',strtotime($plm_fechacreacion));
		}
		else
		{
		    $fechahasta='';
    		$fechadesde='';
		}
		$plm_totalgastomateriales=$this->request->getPost('gasto');
		$espid=$this->request->getPost('espid');
		$coordinador=$this->request->getPost('coordinador'); print_r($coordinador);
		$rol_id=$session->get('ROL_ID');
		
		if(!empty($plm_id_padre)){
			$resultado_plan=$plan_model->getPlanplmpadre($plm_id_padre);
			if(empty($resultado_plan)){
				$session->setFlashdata('mensaje_malo', 'El plan de mercadeo seleccionado no tiene alcances');
				return redirect()->to(base_url('Plan'));
			}
		}else{
			if($rol_id==1){
				$can_id=null;
				$are_id=null;
			}else{
				$can_id=$session->get('CAN_ID');
				$are_id=$session->get('are_id');
			}
			if($rol_id==5){
				$plm_totalgastomateriales_contabilidad=$this->request->getPost('gastocontabilidad');
				$resultado_plan=$plan_model->getPlancontabilidad($plm_totalgastomateriales_contabilidad);
			}else{
				if($rol_id==4){
					$resultado_plan=$plan_model->getPlanaprobador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales,$are_id);
				}
				if($rol_id==7){
					$resultado_plan=$plan_model->getPlanautorizador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales,$are_id);
				}
				else{
    				if($rol_id==2){
    					$resultado_plan=$plan_model->getPlanNegociador($plm_nombreplan,$plm_fechacreacion,$can_id,$plm_totalgastomateriales,$espid,$are_id);
    				}
    				if($rol_id==3){
    					$resultado_plan=$plan_model->getPlanAreaSolicitante($plm_nombreplan,$fechadesde,$fechahasta,$can_id,$plm_totalgastomateriales,$espid,$are_id,$coordinador,$session->get('USU_ID'));
    				}else{
    					$resultado_plan=$plan_model->getPlan($plm_nombreplan,$fechadesde,$fechahasta,$can_id,$plm_totalgastomateriales,$espid,$are_id,$coordinador);
    				}
				}
			}
		}

		
		
		$datos_plan=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];
		//echo '<pre>';print_r($resultado_plan);echo '</pre>';
		foreach ($resultado_plan as $value) 
		{
		    
            $acciones_plan_mercadeo=array();
            $acciones_plan_mercadeo1=$plan_model->getAccionesPlan($session->get('ROL_ID'),$value['esp_id']);
            
            foreach($acciones_plan_mercadeo1 as $acc)
            {
                $funcion='';
                $json_encode_funcion='';
                $href='';
                if($acc['acc_funcion']!=''){
                    //$funcion=$acc['acc_funcion'].'(';
                    $argumento_accion=$plan_model->getAccionesArgumentos($acc['acc_id'],1);
                    $cont=1;
                    foreach($argumento_accion as $arg)
                    {
                        if($cont>1){
                            $funcion=$funcion.','.$arg['aca_argumento'];
                            if($arg['aca_json_encode']==1)
                            {
                                $json_encode_funcion=$json_encode_funcion.',1';
                            }
                            else
                            {
                                $json_encode_funcion=$json_encode_funcion.',0';
                            }
                        }
                        else
                        {
                            $funcion=$funcion.$arg['aca_argumento'];
                            if($arg['aca_json_encode']==1)
                            {
                                $json_encode_funcion=$json_encode_funcion.'1';
                            }
                            else
                            {
                                $json_encode_funcion=$json_encode_funcion.'0';
                            }
                        }
                        
                        $cont++;
                    }
                    $funcion=$funcion;
                }
                if($acc['acc_href']!=''){
                    //$href=$acc['acc_href'];
                    $argumento_accion=$plan_model->getAccionesArgumentos($acc['acc_id'],0);
                    $cont=1;
                    foreach($argumento_accion as $arg)
                    {
                        $href=$href.$arg['aca_argumento'];
                    }
                }
                $acciones=array(
                    'acc_id'=>$acc['acc_id'],
    			    'acc_accion'=>$acc['acc_accion'],
    			    'acc_imagen'=>$acc['acc_imagen'],
    			    'acc_funcion'=>$acc['acc_funcion'],
    			    'acc_href'=>$acc['acc_href'],
    			    'acc_f_atributo'=>$funcion,
    			    'acc_h_atributo'=>$href,
    			    'acc_json_encode'=>$json_encode_funcion
			    );
			    array_push($acciones_plan_mercadeo, $acciones);
            }
            
			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			$datos_plan_mercadeo_material_vec=[];

			for ($i=0; $i <sizeof($datos_plan_mercadeo_material) ; $i++) { 
				if (empty($datos_plan_mercadeo_material[$i]['pma_fecha_real'])) {
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				if($datos_plan_mercadeo_material[$i]['pma_fecha_real']=='0000-00-00'){
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				$datos_plan_mercadeo_material_vec[$i][0]=$datos_plan_mercadeo_material[$i]['pma_fecha_real'];
				$datos_plan_mercadeo_material_vec[$i][1]=$datos_plan_mercadeo_material[$i]['pma_id'];
				$datos_plan_mercadeo_material_vec[$i][2]=$datos_plan_mercadeo_material[$i]['pma_material'];
				$datos_plan_mercadeo_material_vec[$i][3]=$datos_plan_mercadeo_material[$i]['pma_cantidad'];
				$datos_plan_mercadeo_material_vec[$i][4]=$datos_plan_mercadeo_material[$i]['pma_valorunidad'];
				$datos_plan_mercadeo_material_vec[$i][5]=$datos_plan_mercadeo_material[$i]['pma_total'];
				$datos_plan_mercadeo_material_vec[$i][6]=$datos_plan_mercadeo_material[$i]['pma_cantidad_real'];
				$datos_plan_mercadeo_material_vec[$i][7]=$datos_plan_mercadeo_material[$i]['pma_valor_unidad_real'];
				$datos_plan_mercadeo_material_vec[$i][8]=$datos_plan_mercadeo_material[$i]['pma_subtotal_real'];
				$datos_plan_mercadeo_material_vec[$i][9]=$datos_plan_mercadeo_material[$i]['pma_iva'];
				$datos_plan_mercadeo_material_vec[$i][10]=$datos_plan_mercadeo_material[$i]['pma_total_real'];
				$datos_plan_mercadeo_material_vec[$i][11]=$datos_plan_mercadeo_material[$i]['pma_nombre_proveedor'];
				$datos_plan_mercadeo_material_vec[$i][12]=$datos_plan_mercadeo_material[$i]['pma_numero_documento'];
				$datos_plan_mercadeo_material_vec[$i][13]=$datos_plan_mercadeo_material[$i]['plm_id'];
			}
			
			$activar_ver_subplan=0;
			$activar_ver_subplan=$plan_model->getPlanplmpadre($value['plm_id']);
			$alcance='';
			$alcances='';
			$contador=0;
			if(!empty($activar_ver_subplan)){
				$activar_ver_subplanCant=1;
				sizeof($activar_ver_subplan);
				foreach ($activar_ver_subplan as $v) 
				{
				    $contador++;
				    $alcance='PM=>'.$v['plm_codigo'];//.'.'.$contador;
				    $alcances=$alcances.'  '.$alcance.'</BR>';
				}
			}else{
				$activar_ver_subplanCant=0;
			}
            $codigo_padre=0;
			if($value['plm_padre']!=0){
			    $codigo_padre1=$plan_model->getCodigoPlanId($value['plm_padre']);
			    foreach($codigo_padre1 as $codp)
			    {
			        $codigo_padre=$codp['plm_codigo'];
			    }
			}
			else
			{
			    $codigo_padre=0;
			}
			$datos_plan[]=array(
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'plm_fechaautorizacion'=>$value['plm_fechaautorizacion'],
				'are_area'=>$value['are_area'],
				'DAP_NOMBRES'=>!empty($this->getsolicitantesdelplmid($value['plm_id']))?$this->getsolicitantesdelplmid($value['plm_id']):$value['DAP_NOMBRES'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
				'plm_valorincrementoventasesperado'=>floatval($value['plm_valorincrementoventasesperado']),
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>floatval($value['plm_totalgastomateriales']),
				'plm_total_real_material'=>floatval($value['plm_total_real_material']),
				'plm_activar_rojo_material'=>floatval($value['plm_activar_rojo_material']),
				'plm_observaciones'=>$value['plm_observaciones'],
				'esp_estadoplan'=>$value['esp_estadoplan'],
				'esp_id'=>$value['esp_id'],
				'plm_padre'=>$codigo_padre,
				'datos_plan_mercadeo_material_vec'=>$datos_plan_mercadeo_material_vec,
				'activar_ver_subplan'=>$activar_ver_subplanCant,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
				'plm_archivar'=>($value['plm_archivar']),
				'alcance'=>$alcances,
				'acciones'=>$acciones_plan_mercadeo,
				
			);			
			$alcances='';
			$datos_plan_mercadeo_material=[];			
			$datos_plan_mercadeo_material_vec=[];
			$datos_auspiciante_plan_mercadeo=[];

		}		

		$enviar_datos=array(
			
			'datos_plan' => !empty($datos_plan)?$datos_plan:null , 
			'rol_id'=>$session->get('ROL_ID'),
			'session_id'=>$session->get('USU_ID'),
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:[] ,
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:[] , 
			'doc_auspicio'=>$texto_doc_auspicio,
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/list",$enviar_datos);
		echo view("layouts/footer");
		
	}
	
	public function mostrarlistArchivo($plm_id_padre=''){

		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		
		
		$plan_model= new Planmodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$proveedor_model= new Proveedormodel();
		
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_proveedor=$proveedor_model->getProveedor();


		$plm_nombreplan=$this->request->getPost('nombreplan');
		$plm_fechacreacion=$this->request->getPost('fecha');
		//$can_id=$this->request->getPost('canid');
		$plm_totalgastomateriales=$this->request->getPost('gasto');
		$espid=$this->request->getPost('espid');
		
		$rol_id=$session->get('ROL_ID');
		
		if(!empty($plm_id_padre)){
			$resultado_plan=$plan_model->getPlanplmpadre($plm_id_padre);
			if(empty($resultado_plan)){
				$session->setFlashdata('mensaje_malo', 'El plan de meradeo seleccionado no tiene alcances');
				return redirect()->to(base_url('Plan'));
			}
		}else{
			
				$usu_id=$session->get('USU_ID');
			    $resultado_plan=$plan_model->getPlanArchivo($usu_id);
    	}

		
		
		$datos_plan=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];
		
		foreach ($resultado_plan as $value) {


			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			$datos_plan_mercadeo_material_vec=[];

			for ($i=0; $i <sizeof($datos_plan_mercadeo_material) ; $i++) { 
				if (empty($datos_plan_mercadeo_material[$i]['pma_fecha_real'])) {
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				if($datos_plan_mercadeo_material[$i]['pma_fecha_real']=='0000-00-00'){
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				$datos_plan_mercadeo_material_vec[$i][0]=$datos_plan_mercadeo_material[$i]['pma_fecha_real'];
				$datos_plan_mercadeo_material_vec[$i][1]=$datos_plan_mercadeo_material[$i]['pma_id'];
				$datos_plan_mercadeo_material_vec[$i][2]=$datos_plan_mercadeo_material[$i]['pma_material'];
				$datos_plan_mercadeo_material_vec[$i][3]=$datos_plan_mercadeo_material[$i]['pma_cantidad'];
				$datos_plan_mercadeo_material_vec[$i][4]=$datos_plan_mercadeo_material[$i]['pma_valorunidad'];
				$datos_plan_mercadeo_material_vec[$i][5]=$datos_plan_mercadeo_material[$i]['pma_total'];
				$datos_plan_mercadeo_material_vec[$i][6]=$datos_plan_mercadeo_material[$i]['pma_cantidad_real'];
				$datos_plan_mercadeo_material_vec[$i][7]=$datos_plan_mercadeo_material[$i]['pma_valor_unidad_real'];
				$datos_plan_mercadeo_material_vec[$i][8]=$datos_plan_mercadeo_material[$i]['pma_subtotal_real'];
				$datos_plan_mercadeo_material_vec[$i][9]=$datos_plan_mercadeo_material[$i]['pma_iva'];
				$datos_plan_mercadeo_material_vec[$i][10]=$datos_plan_mercadeo_material[$i]['pma_total_real'];
				$datos_plan_mercadeo_material_vec[$i][11]=$datos_plan_mercadeo_material[$i]['pma_nombre_proveedor'];
				$datos_plan_mercadeo_material_vec[$i][12]=$datos_plan_mercadeo_material[$i]['pma_numero_documento'];
				$datos_plan_mercadeo_material_vec[$i][13]=$datos_plan_mercadeo_material[$i]['plm_id'];
			}
			
			$activar_ver_subplan=0;
			$activar_ver_subplan=$plan_model->getPlanplmpadre($value['plm_id']);
			$alcance='';
			$alcances='';
			$contador=0;
			if(!empty($activar_ver_subplan)){
				$activar_ver_subplanCant=1;
				sizeof($activar_ver_subplan);
				foreach ($activar_ver_subplan as $v) 
				{
				    $contador++;
				    $alcance='PM=>'.$v['plm_codigo'];//.'.'.$contador;
				    $alcances=$alcances.'  '.$alcance.'</BR>';
				}
			}else{
				$activar_ver_subplanCant=0;
			}
            
			$datos_plan[]=array(
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'plm_fechaautorizacion'=>$value['plm_fechaautorizacion'],
				'are_area'=>$value['are_area'],
				'DAP_NOMBRES'=>!empty($this->getsolicitantesdelplmid($value['plm_id']))?$this->getsolicitantesdelplmid($value['plm_id']):$value['DAP_NOMBRES'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
				'plm_valorincrementoventasesperado'=>floatval($value['plm_valorincrementoventasesperado']),
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>floatval($value['plm_totalgastomateriales']),
				'plm_total_real_material'=>floatval($value['plm_total_real_material']),
				'plm_activar_rojo_material'=>floatval($value['plm_activar_rojo_material']),
				'plm_observaciones'=>$value['plm_observaciones'],
				'esp_estadoplan'=>$value['esp_estadoplan'],
				'esp_id'=>$value['esp_id'],
				'plm_padre'=>$value['plm_padre'],
				'datos_plan_mercadeo_material_vec'=>$datos_plan_mercadeo_material_vec,
				'activar_ver_subplan'=>$activar_ver_subplanCant,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
				'plm_archivar'=>($value['plm_archivar']),
				'alcance'=>$alcances,
			);			
			$alcances='';
			$datos_plan_mercadeo_material=[];			
			$datos_plan_mercadeo_material_vec=[];
			$datos_auspiciante_plan_mercadeo=[];

		}		

		$enviar_datos=array(
			
			'datos_plan' => !empty($datos_plan)?$datos_plan:null , 
			'rol_id'=>$session->get('ROL_ID'),
			'session_id'=>$session->get('USU_ID'),
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:[] ,
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:[] , 
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/listArchivo",$enviar_datos);
		echo view("layouts/footer");
		
	}
    
    public function mostrarReporteAuspicios($plm_id_padre=''){

		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		
		$plm_nombreplan=$this->request->getPost('nombreplan');
        $plm_fechainicio=$this->request->getPost('fechainicio');
        $plm_fechafin=$this->request->getPost('fechafin');
        $plm_totalgastomateriales=$this->request->getPost('gasto');
        $espid=$this->request->getPost('espid');
        $coordinador=$this->request->getPost('coordinador');
        $rol_id=$session->get('ROL_ID');
		$plan_model= new Planmodel();
		$resultado_plan=$plan_model->getPlanAuspicios($plm_nombreplan,$plm_fechainicio,$plm_fechafin,$plm_totalgastomateriales,$espid,$coordinador);
    	$datos_plan=[];
    	
		
		/*foreach ($resultado_plan as $value) {

			$datos_plan[]=array(
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'pro_proveedor'=>$value['pro_nombre'],
				'aup_valor'=>$value['aup_valor'],
				'aup_porcentaje'=>$value['aup_porcentaje'],
				'are_area'=>$value['are_area'],
				'plm_fechaautorizacion'=>$value['plm_fechaautorizacion'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
				'esp_estadoplan'=>$value['esp_estadoplan'],
				
			);			
			

		}		*/

		$enviar_datos=array(
			
			'datos_plan' => !empty($resultado_plan)?$resultado_plan:null , 
			'rol_id'=>$session->get('ROL_ID'),
			'session_id'=>$session->get('USU_ID'),
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/reporteauspicios",$enviar_datos);
		echo view("layouts/footer");
		
	}
	
	
    
    public function mostrarReporteGastoReal($plm_id_padre=''){

		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		
		
		$plan_model= new Planmodel();
		$resultado_plan=$plan_model->getPlanPadres();
    	$datos_plan=[];
		
		foreach ($resultado_plan as $value) {
            $resultado_planReal=$plan_model->getPlanMaterialesRealesSuma($value['plm_id']);
            //print_r($resultado_planReal);
            foreach ($resultado_planReal as $value2) {
    			$datos_plan[]=array(
    			    'usu_id'=>$value['usu_id'],
    				'plm_id'=>$value['plm_id'],
    				'plm_codigo'=>$value['plm_codigo'],
    				'plm_nombreplan'=>$value['plm_nombreplan'],
    				'pro_proveedor'=>$value['pro_nombre'],
    				'aup_valor'=>$value['aup_valor'],
    				'aup_porcentaje'=>$value['aup_porcentaje'],
    				'are_area'=>$value['are_area'],
    				'plm_fechaautorizacion'=>$value['plm_fechaautorizacion'],
    				'plm_fechacreacion'=>$value['plm_fechacreacion'],
    				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
    				'plm_fechafinplan'=>$value['plm_fechafinplan'],
    				'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
    				'esp_estadoplan'=>$value['esp_estadoplan'],
    				'gasto_real'=>$value2['pmr_subtotal'],
    				
    			);	
            }
			

		}		

		$enviar_datos=array(
			
			'datos_plan' => !empty($datos_plan)?$datos_plan:null , 
			'rol_id'=>$session->get('ROL_ID'),
			'session_id'=>$session->get('USU_ID'),
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/reportegastoreal",$enviar_datos);
		echo view("layouts/footer");
		
	}
	
    public function mostrarlistnegociador($plm_id_padre=''){

		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		
		
		$plan_model= new Planmodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$proveedor_model= new Proveedormodel();
		
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_proveedor=$proveedor_model->getProveedor();


		$plm_nombreplan=$this->request->getPost('nombreplan');
		$plm_fechacreacion=$this->request->getPost('fecha');
		//$can_id=$this->request->getPost('canid');
		$plm_totalgastomateriales=$this->request->getPost('gasto');
		$espid=$this->request->getPost('espid');
		
		$rol_id=$session->get('ROL_ID');
		
		if(!empty($plm_id_padre)){
			$resultado_plan=$plan_model->getPlanplmpadre($plm_id_padre);
			if(empty($resultado_plan)){
				$session->setFlashdata('mensaje_malo', 'El plan de meradeo seleccionado no tiene alcances');
				return redirect()->to(base_url('Plan'));
			}
		}else{
			if($rol_id==1){
				$can_id=null;
				$are_id=null;
			}else{
				$can_id=$session->get('CAN_ID');
				$are_id=$session->get('are_id');
			}
			if($rol_id==5){
				$plm_totalgastomateriales_contabilidad=$this->request->getPost('gastocontabilidad');
				$resultado_plan=$plan_model->getPlancontabilidad($plm_totalgastomateriales_contabilidad);
			}else{
				if($rol_id==4){
					$resultado_plan=$plan_model->getPlanaprobador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales,$are_id);
				}
				if($rol_id==7){
					$resultado_plan=$plan_model->getPlanautorizador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales,$are_id);
				}
				else{
    				if($rol_id==2){
    					$resultado_plan=$plan_model->getPlanNegociador($plm_nombreplan,$plm_fechacreacion,$can_id,$plm_totalgastomateriales,$espid,$are_id,$session->get('USU_ID'));
    				}else{
    					$resultado_plan=$plan_model->getPlan($plm_nombreplan,$plm_fechacreacion,$can_id,$plm_totalgastomateriales,$espid,$are_id);
    				}
				}
			}
		}

		
		
		$datos_plan=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];
		
		foreach ($resultado_plan as $value) {


			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			$datos_plan_mercadeo_material_vec=[];

			for ($i=0; $i <sizeof($datos_plan_mercadeo_material) ; $i++) { 
				if (empty($datos_plan_mercadeo_material[$i]['pma_fecha_real'])) {
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				if($datos_plan_mercadeo_material[$i]['pma_fecha_real']=='0000-00-00'){
					$datos_plan_mercadeo_material[$i]['pma_fecha_real']=null;
				}
				$datos_plan_mercadeo_material_vec[$i][0]=$datos_plan_mercadeo_material[$i]['pma_fecha_real'];
				$datos_plan_mercadeo_material_vec[$i][1]=$datos_plan_mercadeo_material[$i]['pma_id'];
				$datos_plan_mercadeo_material_vec[$i][2]=$datos_plan_mercadeo_material[$i]['pma_material'];
				$datos_plan_mercadeo_material_vec[$i][3]=$datos_plan_mercadeo_material[$i]['pma_cantidad'];
				$datos_plan_mercadeo_material_vec[$i][4]=$datos_plan_mercadeo_material[$i]['pma_valorunidad'];
				$datos_plan_mercadeo_material_vec[$i][5]=$datos_plan_mercadeo_material[$i]['pma_total'];
				$datos_plan_mercadeo_material_vec[$i][6]=$datos_plan_mercadeo_material[$i]['pma_cantidad_real'];
				$datos_plan_mercadeo_material_vec[$i][7]=$datos_plan_mercadeo_material[$i]['pma_valor_unidad_real'];
				$datos_plan_mercadeo_material_vec[$i][8]=$datos_plan_mercadeo_material[$i]['pma_subtotal_real'];
				$datos_plan_mercadeo_material_vec[$i][9]=$datos_plan_mercadeo_material[$i]['pma_iva'];
				$datos_plan_mercadeo_material_vec[$i][10]=$datos_plan_mercadeo_material[$i]['pma_total_real'];
				$datos_plan_mercadeo_material_vec[$i][11]=$datos_plan_mercadeo_material[$i]['pma_nombre_proveedor'];
				$datos_plan_mercadeo_material_vec[$i][12]=$datos_plan_mercadeo_material[$i]['pma_numero_documento'];
				$datos_plan_mercadeo_material_vec[$i][13]=$datos_plan_mercadeo_material[$i]['plm_id'];
			}
			
			$activar_ver_subplan=0;
			$activar_ver_subplan=$plan_model->getPlanplmpadre($value['plm_id']);
			
			if(!empty($activar_ver_subplan)){
				$activar_ver_subplan=1;
			}else{
				$activar_ver_subplan=0;
			}

			$datos_plan[]=array(
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'are_area'=>$value['are_area'],
				'DAP_NOMBRES'=>!empty($this->getsolicitantesdelplmid($value['plm_id']))?$this->getsolicitantesdelplmid($value['plm_id']):$value['DAP_NOMBRES'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
				'plm_valorincrementoventasesperado'=>floatval($value['plm_valorincrementoventasesperado']),
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>floatval($value['plm_totalgastomateriales']),
				'plm_total_real_material'=>floatval($value['plm_total_real_material']),
				'plm_activar_rojo_material'=>floatval($value['plm_activar_rojo_material']),
				'plm_observaciones'=>$value['plm_observaciones'],
				'esp_estadoplan'=>$value['esp_estadoplan'],
				'esp_id'=>$value['esp_id'],
				
				'datos_plan_mercadeo_material_vec'=>$datos_plan_mercadeo_material_vec,
				'activar_ver_subplan'=>$activar_ver_subplan,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
			);			
			$datos_plan_mercadeo_material=[];			
			$datos_plan_mercadeo_material_vec=[];
			$datos_auspiciante_plan_mercadeo=[];

		}		

		$enviar_datos=array(
			
			'datos_plan' => !empty($datos_plan)?$datos_plan:null , 
			'rol_id'=>$session->get('ROL_ID'),
			'session_id'=>$session->get('USU_ID'),
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:[] ,
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:[] , 
		);
		
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/listnegociacion",$enviar_datos);
		echo view("layouts/footer");
		
	}

	public function mostrarplan(){

		if(empty($this->request->getPost('plmid'))){
			echo json_encode([]);
		}


		$plan_model= new Planmodel();
		$plandocumento_model= new Planmercadeodocumentomodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();

		$plm_id=$this->request->getPost('plmid');
		$resultado_plan=$plan_model->getPlanID($plm_id);
		
		
		$resultadodocumento=$plandocumento_model->getPlanmercadeodocumentosegunplmid($plm_id);
		$activar_ver_subplan=$plan_model->getPlanplmpadre($plm_id);
			
		$prueba=$plan_model->modelPrueba();	
		//echo 'Hola';
	//	print_r($resultado_plan);

		$datos_plan=[];
		$datos_documento=[];
		$datos_mercadeo_tipo_tactica=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];

		foreach ($resultado_plan as $value) {
			
			$respuesta_mercadeo_tipo_tactica=$plan_mercadeo_tipo_tactica_model->getPlanmercadeotipotacticasegunplmid($value['plm_id']);
			foreach ($respuesta_mercadeo_tipo_tactica as  $itemtipotactica) {
				
				$respuesta_lista_tactica=$plan_mercadeo_tactica_model->getPlanmercadeotacticasegunpmtid($itemtipotactica['pmt_id']);
				$respuesta_lista_herramienta=$plan_mercadeo_herramienta_model->getPlanmercadeoherramientasegunpmtid($itemtipotactica['pmt_id']);

				$datos_mercadeo_tipo_tactica[]=array(

					'pmt_id'=>$itemtipotactica['pmt_id'],
					'tac_id'=>$itemtipotactica['tac_id'],
					'tac_tacticas'=>$itemtipotactica['tac_tacticas'],
					'pmt_objetivo'=>$itemtipotactica['pmt_objetivo'],
					'datos_lista_tactica'=>$respuesta_lista_tactica,
					'datos_lista_herramienta'=>$respuesta_lista_herramienta,
				);
				
				
			}
			$respuesta_mercadeo_tipo_tactica=[];



			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_plan_mercadeo_materialAlcance=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmidPadre($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			
			$alcance='';
			$alcances='';
			$contador=1;
			if(!empty($activar_ver_subplan)){
				$activar_ver_subplanCant=1;
				foreach ($activar_ver_subplan as $v) 
				{
				    $alcance='PM=>'.$v['plm_codigo'];//.'.'.$contador;
				    $alcances=$alcances.'  '.$alcance.' , ';
				    $contador++;
				}
			}else{
				$activar_ver_subplanCant=0;
			}
		

            if($value['plm_desde_alcance']=='0000-00-00'){
				$value['plm_desde_alcance']='';
			}
			if($value['plm_hasta_alcance']=='0000-00-00'){
				$value['plm_hasta_alcance']='';
			}
			if($value['plm_pi_desde_alcance']=='0000-00-00'){
				$value['plm_pi_desde_alcance']='';
			}
			if($value['plm_pi_hasta_alcance']=='0000-00-00'){
				$value['plm_pi_hasta_alcance']='';
			}
			$codigo_padre=0;
			if($value['plm_padre']!=0){
			    $codigo_padre1=$plan_model->getCodigoPlanId($value['plm_padre']);
			    foreach($codigo_padre1 as $codp)
			    {
			        $codigo_padre=$codp['plm_codigo'];
			    }
			}
			else
			{
			    $codigo_padre=0;
			}
			$usu_cobrador=0;
			if($value['usu_cobrador']==NULL)
			{
			    $usu_cobrador=!empty($this->getsolicitantesdelplmid($value['plm_id']))?$this->getsolicitantesdelplmid($value['plm_id']):$value['DAP_NOMBRES'];
			}
			else
			{
			    $usu_cobrador=$value['usu_cobrador'];
			}
			$datos_plan[]=array(			

                'plm_observacion_autorizador'=>$value['plm_observacion_autorizador'],
                'plm_elaboradopor'=>$value['plm_elaboradopor'],
                'plm_aprobadopor'=>$value['plm_aprobadopor'],
                'plm_autorizadopor'=>$value['plm_autorizadopor'],
                'plm_fechaautorizacion'=>$value['plm_fechaautorizacion'],
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_id'=>$value['plm_id'],
				'esp_id'=>$value['esp_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'are_area'=>$value['are_area'],
				'usu_cobrador'=>$usu_cobrador,
				'DAP_NOMBRES'=>!empty($this->getsolicitantesdelplmid($value['plm_id']))?$this->getsolicitantesdelplmid($value['plm_id']):$value['DAP_NOMBRES'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_valorincrementoventasesperado'=>$value['plm_valorincrementoventasesperado'],
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>$value['plm_totalgastomateriales'],
				'plm_total_real_material'=>floatval($value['plm_total_real_material']),
				'plm_activar_rojo_material'=>floatval($value['plm_activar_rojo_material']),
				'plm_observaciones'=>$value['plm_observaciones'],
                'car_cargo'=>!empty($this->getcargosolicitantesdelplmid($value['plm_id']))?$this->getcargosolicitantesdelplmid($value['plm_id']):$value['car_cargo'],
				'datos_mercadeo_tipo_tactica'=>$datos_mercadeo_tipo_tactica,
				'datos_plan_mercadeo_material'=>$datos_plan_mercadeo_material,
				'datos_plan_mercadeo_materialAlcance'=>$datos_plan_mercadeo_materialAlcance,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
				
				'plm_desde_alcance'=>$value['plm_desde_alcance'],
				'plm_hasta_alcance'=>$value['plm_hasta_alcance'],
				'plm_pi_desde_alcance'=>$value['plm_pi_desde_alcance'],
				'plm_pi_hasta_alcance'=>$value['plm_pi_hasta_alcance'],
				
				'plm_cuenta_contable'=>$value['plm_cuenta_contable'],
				'plm_centro_costo'=>$value['plm_centro_costo'],
				'plm_tipo_alcance'=>$value['plm_tipo_alcance'],
				'plm_padre'=>$codigo_padre,
				'plm_asume'=>$this->getarrayanombresumeplmid($value['plm_id']),
				'alcances'=>$alcances,

			);
			$datos_mercadeo_tipo_tactica=[];
			$datos_plan_mercadeo_material=[];
			$datos_auspiciante_plan_mercadeo=[];

		}
		
	
		  
		
		$datos_plan['img']=$resultadodocumento;
		
	

		echo json_encode($datos_plan,JSON_UNESCAPED_UNICODE);



	}
	public function datosaeditar($plm_id){
		$session = \Config\Services::session();
		if(empty($plm_id)){
			$session->setFlashdata('mensaje_malo', 'No existe Dato');
			return redirect()->to(base_url('Plan')); 
		}


		$area_model= new Areamodel();
		$usuario_model= new UsuarioModel();		
		$proveedor_model= new Proveedormodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$tipo_franquiciado_model= new Tipofranquiciamodel();
		$tipo_tactica_model= new Tipotacticasmodel();
		$destino_activo_model= new Destinoactivomodel();
		$plan_mercadeo_tipo_alcance= new Planmercadeotipoalcancemodel();
		$asume_model= new Asumemodel();
		$cuenta_contable_model= new Cuentacontablemodel();

		$datos_area=$area_model->getArea();
		$datos_usuario=$usuario_model->getUsuario();
		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_tipo_franquicia=$tipo_franquiciado_model->getTipofranquicia();
		$datos_tipo_tacticas=$tipo_tactica_model->getTipotacticas();
		$datos_desnito_activo=$destino_activo_model->getdestinoactivo();
        $datos_plan_mercadeo_tipo_alcance=$plan_mercadeo_tipo_alcance->getPlanmercadeotipoalcance();
        $datos_asume=$asume_model->getAsume();
        $datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();

		

		$plan_model= new Planmodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();




		
		$resultado_plan=$plan_model->getPlanID($plm_id);

		$datos_plan=[];
		$datos_mercadeo_tipo_tactica=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];

		foreach ($resultado_plan as $value) {
			//if($value['esp_id']==4 || $value['esp_id']==5 )
			if( $value['esp_id']==5 ){
				$session->setFlashdata('mensaje_malo', 'No se puede editar los datos con estado '.$value['esp_estadoplan']);
				return redirect()->to(base_url('Plan'));
			}
			
			$respuesta_mercadeo_tipo_tactica=$plan_mercadeo_tipo_tactica_model->getPlanmercadeotipotacticasegunplmid($value['plm_id']);
			foreach ($respuesta_mercadeo_tipo_tactica as  $itemtipotactica) {
				
				$respuesta_lista_tactica=$plan_mercadeo_tactica_model->getPlanmercadeotacticasegunpmtid($itemtipotactica['pmt_id']);
				$respuesta_lista_herramienta=$plan_mercadeo_herramienta_model->getPlanmercadeoherramientasegunpmtid($itemtipotactica['pmt_id']);

				$datos_mercadeo_tipo_tactica[]=array(

					'pmt_id'=>$itemtipotactica['pmt_id'],
					'tac_id'=>$itemtipotactica['tac_id'],
					'tac_tacticas'=>$itemtipotactica['tac_tacticas'],
					'pmt_objetivo'=>$itemtipotactica['pmt_objetivo'],
					'datos_lista_tactica'=>$respuesta_lista_tactica,
					'datos_lista_herramienta'=>$respuesta_lista_herramienta,
				);				
				
			}
			$respuesta_mercadeo_tipo_tactica=[];

			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			
            
            if($value['plm_desde_alcance']=='0000-00-00'){
				$value['plm_desde_alcance']=null;
			}
			if($value['plm_hasta_alcance']=='0000-00-00'){
				$value['plm_hasta_alcance']=null;
			}
			if($value['plm_pi_desde_alcance']=='0000-00-00'){
				$value['plm_pi_desde_alcance']=null;
			}
			if($value['plm_pi_hasta_alcance']=='0000-00-00'){
				$value['plm_pi_hasta_alcance']=null;
			}
			
			$datos_array_solicitante=$this->getarraysolicitantesdelplmid($value['plm_id']);
			
			if(empty($datos_array_solicitante)){
				$datos_array_solicitante[]=array(
					'USU_ID'=>$value['USU_ID'],
					'car_cargo'=>$value['car_cargo'],
					'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				);
			}
			$datos_array_asume=$this->getarrayasumeplmid($value['plm_id']);

			$datos_plan[]=array(			

                
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'are_area'=>$value['are_area'],
				'are_id'=>$value['are_id'],
				'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				'USU_ID'=>$value['USU_ID'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_valorincrementoventasesperado'=>$value['plm_valorincrementoventasesperado'],
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>$value['plm_totalgastomateriales'],
				'plm_desde_alcance'=>$value['plm_desde_alcance'],
				'plm_hasta_alcance'=>$value['plm_hasta_alcance'],
				'plm_observaciones'=>$value['plm_observaciones'],
				'plm_pi_desde_alcance'=>$value['plm_pi_desde_alcance'],
				'plm_pi_hasta_alcance'=>$value['plm_pi_hasta_alcance'],
				'plm_cuenta_contable'=>$value['plm_cuenta_contable'],
				'plm_centro_costo'=>$value['plm_centro_costo'],
				'plm_tipo_alcance'=>$value['plm_tipo_alcance'],

				'datos_mercadeo_tipo_tactica'=>$datos_mercadeo_tipo_tactica,
				'datos_plan_mercadeo_material'=>$datos_plan_mercadeo_material,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
				'datos_array_solicitante'=>$datos_array_solicitante,
				'datos_array_asume'=>$datos_array_asume,

			);
			$datos_mercadeo_tipo_tactica=[];
			$datos_plan_mercadeo_material=[];
			$datos_auspiciante_plan_mercadeo=[];
			$datos_array_solicitante=[];
			$datos_array_asume=[];

		}
		$usuario_model= new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);

		
		$enviar_datos=array(
			'datos_area' => !empty($datos_area)?$datos_area:null , 
			'datos_usuario' => !empty($datos_usuario)?$datos_usuario:null , 
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:null , 
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:null , 
			'datos_tipo_franquicia' => !empty($datos_tipo_franquicia)?$datos_tipo_franquicia:null , 
			'datos_tipo_tacticas' => !empty($datos_tipo_tacticas)?$datos_tipo_tacticas:null , 
			'datos_desnito_activo' => !empty($datos_desnito_activo)?$datos_desnito_activo:null ,
			'datos_plan_mercadeo'=>$datos_plan,		
			'datos_plan_mercadeo_tipo_alcance' => !empty($datos_plan_mercadeo_tipo_alcance)?$datos_plan_mercadeo_tipo_alcance:[] ,	
			'datos_asume' => !empty($datos_asume)?$datos_asume:[] ,
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:[] ,	
		);
		
		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/mostrareditar",$enviar_datos);
		echo view("layouts/footer");

	}
	
	public function add(){
		$session = \Config\Services::session();
		$plan_model= new Planmodel();
		if(!empty($this->request->getPost('nombreestrategia')) && !empty($this->request->getPost('objetivo')) && !empty($this->request->getPost('fechainicio')) && !empty($this->request->getPost('fechafin')) && !empty($this->request->getPost('areid'))  && !empty($this->request->getPost('plm_codigo')) ){

			$array_personas_solicitantes=json_decode($this->request->getPost('arraysolicitantes'),true);
			

			if(sizeof($array_personas_solicitantes)==0){
				$session->setFlashdata('mensaje_malo', 'No hay solicitante');
				return redirect()->to(base_url('Plan')); 
			}
				
			$usu_id=explode("/", $array_personas_solicitantes[0]);
			$usu_id=$usu_id[0];

			$plm_codigo=$this->request->getPost('plm_codigo');
            $plm_padre=$this->request->getPost('plmidpadre');
			if(empty($plm_padre)){
				$plm_padre=0;
			}
			
			
            if($plm_padre==0){    
    			$validation =  \Config\Services::validation();
    			$validation->setRules([
    				'plm_codigo' => 'required|is_unique[tbl_plan_mercadeo.plm_codigo]',                
    			]);
    			$validation->withRequest($this->request)->run();
    			if($validation->getErrors()){
    				$errores = $validation->getErrors();                 
    				$session->setFlashdata('mensaje_malo', 'El código ingresado ya existe');
    				return redirect()->to(base_url('Plan')); 
    			}
            }

			$plm_nombreplan=$this->request->getPost('nombreestrategia');
			$plm_objetivo=$this->request->getPost('objetivo');
			$plm_fechacreacion=date('Y-m-d');
			$plm_fechainicioplan=$this->request->getPost('fechainicio');
			$plm_fechafinplan=$this->request->getPost('fechafin');
			$plm_solicitante=$usu_id;
			$plm_areadestino=$this->request->getPost('areid');
			$promedioventas=$this->request->getPost('promedioventasactuales');
			$plm_ventasactuales=str_replace(',','',$promedioventas);
			$promedioventasesperado=$this->request->getPost('promedioventasesperado');
			$plm_valorincrementoventasesperado=str_replace(',','',$promedioventasesperado);
			$plm_porcentajeincrementoventasesperado=$this->request->getPost('porcentajeincremento');

			$array_materiales=json_decode($this->request->getPost('arraymateriales'),true);


			$plm_totalgastomateriales=0;
			foreach ($array_materiales as $value) {
				$plm_totalgastomateriales=$plm_totalgastomateriales+$value['total'];
			}

			$can_id=$session->get('CAN_ID');
			
			
			
			$plm_desde_alcance=$this->request->getPost('fechadesdealcance');
			$plm_hasta_alcance=$this->request->getPost('fechahastaalcance');
			
			$plm_observaciones=$this->request->getPost('enviarobservacion');
			
			$plm_pi_desde_alcance=$this->request->getPost('fechapidesdealcance');
			$plm_pi_hasta_alcance=$this->request->getPost('fechapihastaalcance');
			
			$plm_cuenta_contable=$this->request->getPost('cuentacontable');
			$plm_centro_costo=$this->request->getPost('centrocosto');
			$plm_tipo_alcance=$this->request->getPost('tipoalcancenombre');
			
			$creado_por=$session->get('USU_ID');
			$elaborado_por=$session->get('DAP_NOMBRES');

			$datos_plan_mercadeo=array(

                'usu_id'=>$creado_por,
				'plm_nombreplan'=>$plm_nombreplan,
				'plm_objetivo'=>$plm_objetivo,
				'plm_fechacreacion'=>$plm_fechacreacion,
				'plm_fechainicioplan'=>$plm_fechainicioplan,
				'plm_fechafinplan'=>$plm_fechafinplan,
				'plm_solicitante'=>$plm_solicitante,
				'plm_areadestino'=>$plm_areadestino,
				'plm_ventasactuales'=>$plm_ventasactuales,
				'plm_valorincrementoventasesperado'=>$plm_valorincrementoventasesperado,
				'plm_porcentajeincrementoventasesperado'=>$plm_porcentajeincrementoventasesperado,
				'plm_totalgastomateriales'=>$plm_totalgastomateriales,
				'plm_codigo'=>$plm_codigo,
				'plm_padre'=>$plm_padre,
				'plm_desde_alcance'=>$plm_desde_alcance,
				'plm_hasta_alcance'=>$plm_hasta_alcance,
				'plm_observaciones'=>$plm_observaciones,
				'plm_pi_desde_alcance'=>$plm_pi_desde_alcance,
				'plm_pi_hasta_alcance'=>$plm_pi_hasta_alcance,
				'plm_cuenta_contable'=>$plm_cuenta_contable,
				'plm_centro_costo'=>$plm_centro_costo,
				'plm_tipo_alcance'=>$plm_tipo_alcance,
				'tpm_id'=>1,
				'fcf_id'=>1,
				'esp_id'=>1,
				'can_id'=>$can_id,
				'usu_id'=>$creado_por,
				'plm_elaboradopor'=>$elaborado_por,
			);

			$plm_id= $plan_model->insertar($datos_plan_mercadeo,$plm_nombreplan,$plm_codigo);			
			$plm_id=$plm_id[0]['plm_id'];
			
			$array_asume=json_decode($this->request->getPost('arrayasume'),true);
			$this->agregar_plan_mercadeo_asume($plm_id,$array_asume);
			
            $this->agregar_solicitante($plm_id,$array_personas_solicitantes);
            
			$array_tacticas=json_decode($this->request->getPost('arraytacticas'),true);			
			$this->agregar_tacticas($plm_id,$array_tacticas);

			$this->agregar_material($plm_id,$array_materiales);
			

			$array_tipo_plan=json_decode($this->request->getPost('arraytipoplan'),true);

			$this->agregar_auspiciante($plm_id,$array_tipo_plan);

			$session->setFlashdata('mensaje_bueno', 'Plan de mercadeo c&oacute;digo '.$plm_codigo.' guardado');
			return redirect()->to(base_url('Plan')); 

		}

	}

	public function edit(){
		$session = \Config\Services::session();
		$plan_model= new Planmodel();
		if(!empty($this->request->getPost('nombreestrategia')) && !empty($this->request->getPost('objetivo')) && !empty($this->request->getPost('fechainicio')) && !empty($this->request->getPost('fechafin')) && !empty($this->request->getPost('plm_codigo')) ){

			
			
			$plm_id=$this->request->getPost('editplmid');
			$are_id_viejo=$this->request->getPost('editareid');
			$are_id_nuevo=$this->request->getPost('areid');

			$are_id=0;
			
			if(empty($are_id_nuevo)){
				$are_id=$are_id_viejo;
			}else{
				$are_id=$are_id_nuevo;
			}			

			$array_personas_solicitantes=json_decode($this->request->getPost('arraysolicitantes'),true);		

			if(sizeof($array_personas_solicitantes)==0){
				$session->setFlashdata('mensaje_malo', 'No hay solicitante');
				return redirect()->to(base_url('Plan')); 
			}
				
			$usu_id=explode("/", $array_personas_solicitantes[0]);
			$usu_id=$usu_id[0];
			


			$plm_codigo=$this->request->getPost('plm_codigo');




			$plm_nombreplan=$this->request->getPost('nombreestrategia');
			$plm_objetivo=$this->request->getPost('objetivo');
			$plm_fechacreacion=date('Y-m-d');
			$plm_fechainicioplan=$this->request->getPost('fechainicio');
			$plm_fechafinplan=$this->request->getPost('fechafin');
			$promedioventas=$this->request->getPost('promedioventasactuales');
			$plm_ventasactuales=str_replace(',','',$promedioventas);
			$promedioventasesperado=$this->request->getPost('promedioventasesperado');
			$plm_valorincrementoventasesperado=str_replace(',','',$promedioventasesperado);
			$plm_porcentajeincrementoventasesperado=$this->request->getPost('porcentajeincremento');

			$array_materiales=json_decode($this->request->getPost('arraymateriales'),true);


			$plm_totalgastomateriales=0;
			foreach ($array_materiales as $value) {
				$plm_totalgastomateriales=$plm_totalgastomateriales+$value['total'];
			}

			$can_id=$session->get('CAN_ID');
            $plm_desde_alcance=$this->request->getPost('fechadesdealcance');
			$plm_hasta_alcance=$this->request->getPost('fechahastaalcance');
			
			$plm_observaciones=$this->request->getPost('enviarobservacion');
			
			$plm_pi_desde_alcance=$this->request->getPost('fechapidesdealcance');
			$plm_pi_hasta_alcance=$this->request->getPost('fechapihastaalcance');
			
			$plm_cuenta_contable=$this->request->getPost('cuentacontable');
			$plm_centro_costo=$this->request->getPost('centrocosto');
			$plm_tipo_alcance=$this->request->getPost('tipoalcancenombre');
			$creado_por=$this->request->getPost('editusuid');
			$elaborado_por=$this->request->getPost('DAP_NOMBRES');
			$datos_plan_mercadeo=array(			

                'plm_nombreplan'=>$plm_nombreplan,
				'plm_objetivo'=>$plm_objetivo,
				'plm_fechacreacion'=>$plm_fechacreacion,
				'plm_fechainicioplan'=>$plm_fechainicioplan,
				'plm_fechafinplan'=>$plm_fechafinplan,
				'plm_solicitante'=>$usu_id,
				'plm_areadestino'=>$are_id,
				'plm_ventasactuales'=>$plm_ventasactuales,
				'plm_valorincrementoventasesperado'=>$plm_valorincrementoventasesperado,
				'plm_porcentajeincrementoventasesperado'=>$plm_porcentajeincrementoventasesperado,
				'plm_totalgastomateriales'=>$plm_totalgastomateriales,
				'plm_codigo'=>$plm_codigo,
				'plm_desde_alcance'=>$plm_desde_alcance,
				'plm_hasta_alcance'=>$plm_hasta_alcance,
				'plm_observaciones'=>$plm_observaciones,
				'plm_pi_desde_alcance'=>$plm_pi_desde_alcance,
				'plm_pi_hasta_alcance'=>$plm_pi_hasta_alcance,
				'plm_cuenta_contable'=>$plm_cuenta_contable,
				'plm_centro_costo'=>$plm_centro_costo,
				'plm_tipo_alcance'=>$plm_tipo_alcance,
				'tpm_id'=>1,
				'fcf_id'=>1,
				'esp_id'=>1,
				'can_id'=>$can_id,
			);
			

			$plan_model->actualizar($plm_id,$datos_plan_mercadeo);			
			
			

			

			$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
			$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
			$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();

			$respuesta_mercadeo_tipo_tactica=$plan_mercadeo_tipo_tactica_model->getPlanmercadeotipotacticasegunplmid($plm_id);
			foreach ($respuesta_mercadeo_tipo_tactica as  $itemtipotactica) {				
				$respuesta_lista_tactica=$plan_mercadeo_tactica_model->getPlanmercadeotacticasegunpmtid($itemtipotactica['pmt_id']);
				
				foreach ($respuesta_lista_tactica as  $value) {
					$plan_mercadeo_tactica_model->DeletePlanmercadeotacticasegunpmtid($value['pmt_id']);
				}
				$respuesta_lista_herramienta=$plan_mercadeo_herramienta_model->getPlanmercadeoherramientasegunpmtid($itemtipotactica['pmt_id']);
				foreach ($respuesta_lista_herramienta as  $value) {
					$plan_mercadeo_herramienta_model->DeletePlanmercadeoherramientasegunpmtid($value['pmt_id']);
				}				
			}
			
			$plan_mercadeo_asume= new Planmercadeoasumemodel();
			$plan_mercadeo_asume->eliminarsegunplmid($plm_id);
			$array_asume=json_decode($this->request->getPost('arrayasume'),true);
			$this->agregar_plan_mercadeo_asume($plm_id,$array_asume);
			
            $plan_mercadeo_solicitante_model= new Planmercadeosolicitantemodel();
			$plan_mercadeo_solicitante_model->eliminarsegunplmid($plm_id);
			$this->agregar_solicitante($plm_id,$array_personas_solicitantes);

			$array_tacticas=json_decode($this->request->getPost('arraytacticas'),true);	
			$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
			$plan_mercadeo_tipo_tactica_model->DeletePlanmercadeotipotacticasegunplmid($plm_id);
			$this->agregar_tacticas($plm_id,$array_tacticas);
			


			$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
			$plan_mercadeo_material_model->eliminarsegunplmid($plm_id);
			$this->agregar_material($plm_id,$array_materiales);
			

			$array_tipo_plan=json_decode($this->request->getPost('arraytipoplan'),true);
			$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
			$auspiciante_plan_mercadeo_model->eliminarauspiciantesegunplmid($plm_id);
			$this->agregar_auspiciante($plm_id,$array_tipo_plan);

			$session->setFlashdata('mensaje_bueno', 'Datos Editados');
			return redirect()->to(base_url('Plan')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Plan')); 
		}

	}

    public function archivar($plm_id)
    {
        $session = \Config\Services::session();
		if(empty($plm_id)){
			$session->setFlashdata('mensaje_malo', 'No existe Dato');
			return redirect()->to(base_url('Plan')); 
		}
		$plan_model=new PlanModel();
		
		$datos_plan_mercadeo=array(			

                'plm_archivar'=>'1',
				
			);
			
		$plan_model->actualizar($plm_id,$datos_plan_mercadeo);	
		$session->setFlashdata('mensaje_bueno', 'Plan archivado');
			return redirect()->to(base_url('Plan')); 
    }

    

    public function desarchivar($plm_id)
    {
        $session = \Config\Services::session();
		if(empty($plm_id)){
			$session->setFlashdata('mensaje_malo', 'No existe Dato');
			return redirect()->to(base_url('Plan')); 
		}
		$plan_model=new PlanModel();
		
		$datos_plan_mercadeo=array(			

                'plm_archivar'=>'0',
				
			);
			
		$plan_model->actualizar($plm_id,$datos_plan_mercadeo);	
		$session->setFlashdata('mensaje_bueno', 'Plan desarchivado');
			return redirect()->to(base_url('Plan')); 
    }
    
    
	public function agregar_tacticas($plm_id,$array_tacticas){
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		foreach ($array_tacticas as $value) {
			$datos_plan_mercadeo_tipo_tactica=array(
				'tac_id'=>$value['tac_id'],
				'pmt_objetivo'=>$value['objetivo_tactica'],
				'pmt_estado'=>1,
				'plm_id'=>$plm_id,
			);
			$pmt_id= $plan_mercadeo_tipo_tactica_model->insertar($datos_plan_mercadeo_tipo_tactica);			
			$pmt_id=$pmt_id[0]['pmt_id'];

			$this->agregar_tacticas_listatacticas($pmt_id,$value['listatactica']);
			$this->agregar_tacticas_listaherramienta($pmt_id,$value['listaherramienta']);
		}
	}
	public function agregar_tacticas_listatacticas($pmt_id,$array_tacticas_listatacticas){
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		foreach ($array_tacticas_listatacticas as $value) {
			$datos_plan_mercadeo_tactica=array(
				'pmt_id'=>$pmt_id,
				'pta_tactica'=>$value,
				'pta_estado'=>1,
			);
			$plan_mercadeo_tactica_model->insertar($datos_plan_mercadeo_tactica);
		}
	}
	public function agregar_tacticas_listaherramienta($pmt_id,$array_tacticas_listaherramienta){
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		foreach ($array_tacticas_listaherramienta as $value) {
			$datos_plan_mercadeo_herramienta=array(
				'pmt_id'=>$pmt_id,
				'phe_herramienta'=>$value,
				'phe_estado'=>1,
			);
			$plan_mercadeo_herramienta_model->insertar($datos_plan_mercadeo_herramienta);
		}
	}

	public function agregar_material($plm_id,$array_material){
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		foreach ($array_material as $value) {
			$datos_plan_mercadeo_material=array(
				'plm_id'=>$plm_id,
				'pma_material'=>$value['material'],
				'pma_cantidad'=>$value['cantidad'],
				'pma_valorunidad'=>$value['valor_unitario'],
				'dea_id'=>$value['dea_id'],
				'pma_total'=>$value['total'],
			);
			$plan_mercadeo_material_model->insertar($datos_plan_mercadeo_material);
		}
	}
	public function agregar_auspiciante($plm_id,$array_tipo_plan){
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
		if(count($array_tipo_plan)>0){
		foreach ($array_tipo_plan as $value) {
			$datos_auspiciante_plan_mercadeo=array(
				'plm_id'=>$plm_id,
				'aup_nombre'=>$value['nombre_plan'],
				'pro_id'=>$value['pro_id'],
				'aup_valor'=>$value['valor'],
				'aup_porcentaje'=>$value['porcentaje'],
				'fra_nombre'=>$value['fra_nombre'],
				'fcf_formacobro'=>$value['fcf_formacobro'],
				'aup_estado'=>1,
			);
			$auspiciante_plan_mercadeo_model->insertar($datos_auspiciante_plan_mercadeo);
		}
			
		}
	}
	public function agregar_solicitante($plm_id,$array_solicitante){
		$plan_mercadeo_solicitante_model= new Planmercadeosolicitantemodel();
		foreach ($array_solicitante as $value) {
			$usu_id=explode("/", $value);
			$usu_id=$usu_id[0];
			$datos_plan_mercadeo_solicitante=array(
				'plm_id'=>$plm_id,
				'usu_id'=>$usu_id,		
				'pms_estado'=>1,
			);
			$plan_mercadeo_solicitante_model->insertar($datos_plan_mercadeo_solicitante);
		}
	}
	public function agregar_plan_mercadeo_asume($plm_id,$array_asume){
		$plan_mercadeo_asume_model= new Planmercadeoasumemodel();
		foreach ($array_asume as $value) {
			$datos_plan_mercadeo_asume=array(
				'asu_id'=>$value,
				'pas_estado'=>1,
				'plm_id'=>$plm_id,
			);
			$plan_mercadeo_asume_model->insertar($datos_plan_mercadeo_asume);
		}
	}

	public function agregardocumento(){
		$session = \Config\Services::session();
		$plan_mercadeo_documento_model= new Planmercadeodocumentomodel();
		if(!empty($this->request->getPost('plmid'))){	
			$plm_id=$this->request->getPost('plmid');	
			if(!empty($this->request->getFiles())){
				if($imagefile = $this->request->getFiles()){						
					$iterator=0;
					foreach($imagefile['archivo'] as $img){

						if ($img->isValid() && ! $img->hasMoved()){							

							$iterator=1;								
							$nombre_documento = $img->getRandomName();
							$type = pathinfo($nombre_documento, PATHINFO_EXTENSION);
							$data = file_get_contents($img);
							$img->move(ROOTPATH.'public/upload/documentos', $nombre_documento);
							
							$base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
							$datos_plan_mercadeo_documento=array(
								'plm_id'=>$plm_id,
								'pmd_nombre'=>$nombre_documento,
								'pmd_estado'=>1,
								'pmd_base'=>$base64,
							);

							$plan_mercadeo_documento_model->insertar($datos_plan_mercadeo_documento);	
							
						}
						if($iterator==0){
							$session->setFlashdata('mensaje_malo', 'Ingrese archivos');
							return redirect()->to(base_url('Plan')); 
						}
					}
					if($iterator==1){
						$session->setFlashdata('mensaje_bueno', 'Documentos registrados correctamente');
						return redirect()->to(base_url('Plan')); 
					}

				}else{
					$session->setFlashdata('mensaje_malo', 'Ingrese archivos');
					return redirect()->to(base_url('Plan')); 
				}			
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Plan')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Plan')); 
		}
		
	}


	public function obtenerdocumentosegunplmid(){

		if(!empty($this->request->getPost('plmid'))){
			$plan_mercadeo_documento_model= new Planmercadeodocumentomodel();

			$plm_id=$this->request->getPost('plmid');	
			$salida=[];
			
			$salida=$plan_mercadeo_documento_model->getPlanmercadeodocumentosegunplmid($plm_id);


			echo json_encode($salida);
		}else{
			echo json_encode('INGRESE DATOS');
		}
		
	}
	
	public function actualizarmaterial(){
		$session = \Config\Services::session();
		$plan_mercadeo_material=new Planmercadeomaterialmodel();
		$plan_model= new Planmodel();
		$matriz_material=json_decode($this->request->getPost('matrizmaterial'),true);
		$activar_rojo=0;
		$plm_id=0;
		$sumatoria_total_real_material=0;
		
		if(!empty($matriz_material)){
			for ($i=0; $i < sizeof($matriz_material) ; $i++) { 
				$pma_id=$matriz_material[$i][1];
				if($matriz_material[$i][10]==0){
					$activar_rojo=1;
				}
				$sumatoria_total_real_material=$sumatoria_total_real_material+floatval($matriz_material[$i][8]);

				$datos_material=array(		
					'pma_cantidad_real'=>$matriz_material[$i][6],
					'pma_valor_unidad_real'=>$matriz_material[$i][7],
					'pma_subtotal_real'=>$matriz_material[$i][8],
					'pma_iva'=>$matriz_material[$i][9],
					'pma_total_real'=>$matriz_material[$i][10],
					'pma_nombre_proveedor'=>$matriz_material[$i][11],
					'pma_numero_documento'=>$matriz_material[$i][12],
					'pma_fecha_real'=>$matriz_material[$i][0],
				);
				$plan_mercadeo_material->actualizar($pma_id,$datos_material);

			}

			if(!empty($matriz_material[0][13])){
				$plm_id=$matriz_material[0][13];
				$datos_plan_mercadeo=array(
					'plm_total_real_material'=>$sumatoria_total_real_material,
					'plm_activar_rojo_material'=>$activar_rojo,
				);
				$plan_model->actualizar($plm_id,$datos_plan_mercadeo);
				
			}

		}

		$session->setFlashdata('mensaje_bueno', 'Datos Ingresados');
		return redirect()->to(base_url('Plan')); 
	}

	public function enviar($plm_id){

		$session = \Config\Services::session();
		if(empty($plm_id)){			
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Plan'));
		}

		$plan_model= new Planmodel();

		$resultado=$plan_model->getPlanID($plm_id);


		if(empty($resultado)){			
			$session->setFlashdata('mensaje_malo', 'Dato no encontrado');
			return redirect()->to(base_url('Plan'));
		}
		
		if($resultado[0]['esp_id']==1 || $resultado[0]['esp_id']==3){					
			$data=array(
				'esp_id'=>2,
				
			);
			$plan_model->actualizar($plm_id,$data);

			$session->setFlashdata('mensaje_bueno', 'Documento enviado a revisión');
			return redirect()->to(base_url('Plan'));
		}else{
			$session->setFlashdata('mensaje_malo', 'Documento en estado: '.$resultado[0]['esp_estadoplan']);
			return redirect()->to(base_url('Plan'));
		}


	}
    public function aprobador(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('idplm1'))&&!empty($this->request->getPost('idautorizacion1'))){
			$plan_model= new Planmodel();
			$plm_id=$this->request->getPost('idplm1');
			$id_autorizacion=$this->request->getPost('idautorizacion1');	
			$observacion=$this->request->getPost('observacionautorizacion1');
			$autorizadopor='';
			
			if($id_autorizacion==4)
			{
			    $autorizadopor=$session->get('DAP_NOMBRES');
			}
			$data=array(
				'esp_id'=>$id_autorizacion,
				'plm_observacion_autorizador'=>$observacion,
				'plm_aprobadopor'=>$autorizadopor,
			);
			$plan_model->actualizar($plm_id,$data);

			$session->setFlashdata('mensaje_bueno', 'Guardado');
			return redirect()->to(base_url('Plan'));
		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese todos los datos');
			return redirect()->to(base_url('Plan'));
		}
	}
	public function autorizador(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('idplm'))&&!empty($this->request->getPost('idautorizacion'))){
			$plan_model= new Planmodel();
			$plm_id=$this->request->getPost('idplm');
			$id_autorizacion=$this->request->getPost('idautorizacion');	
			$observacion=$this->request->getPost('observacionautorizacion');
			$autorizadopor='';
			$fechaautorizacion=date('Y-m-d');
			$data;
			$m="";
			if($id_autorizacion==6)
			{
			    $autorizadopor=$session->get('DAP_NOMBRES');
			    $data=array(
				'esp_id'=>$id_autorizacion,
				'plm_observacion_autorizador'=>$observacion,
				'plm_autorizadopor'=>$autorizadopor,
				'plm_fechaautorizacion'=>$fechaautorizacion,
			    );
			    $m="Plan de mercadeo autorizado";
			}
			else
			{
			    if($id_autorizacion==4)
    			{
    			    $autorizadopor=$session->get('DAP_NOMBRES');
    			    $data=array(
    				'esp_id'=>$id_autorizacion,
    				'plm_observacion_autorizador'=>$observacion,
    				'plm_aprobadopor'=>$autorizadopor,
    			    );
    			    
    			    $session = \Config\Services::session();		
		            $email = \Config\Services::email();
		            
		            $email->setFrom('info.tics@megaprofer.com', 'Planes de mercadeo');
        		    //$email->setTo('gabriela.davila@megaprofer.com');
                    $email->setTo('majo_vasquez_d@hotmail.com');
                    
        		    $email->setSubject('Nuevo plan de mercadeo por autorizar');
        		    $email->setMessage('Estimada, tiene un nuevo plan de mercadeo por autorizar en el sistema CRM.');
        
        		    $email->send();
        		    $m="Plan de mercadeo aprobado";
		            
    			}
    			else
    			{
    			    $data=array(
    				'esp_id'=>$id_autorizacion,
    				'plm_observacion_autorizador'=>$observacion,
    			    );
    			    $m="Se ha actualizado el estado del plan de mercadeo";
    			}
			}
			$plan_model->actualizar($plm_id,$data);

			$session->setFlashdata('mensaje_bueno', $m);
			return redirect()->to(base_url('Plan'));
		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese todos los datos');
			return redirect()->to(base_url('Plan'));
		}
	}
	
	public function getsolicitantesdelplmid($plm_id){
		$plan_mercadeo_solicitante_model=new Planmercadeosolicitantemodel();
		$resultado=$plan_mercadeo_solicitante_model-> getPlanmercadeosolicitantesegunplmid($plm_id);
		
		$salida='';
		foreach ($resultado as $value) {
			$salida=$salida.' '.$value['DAP_NOMBRES'].',';
		}
		return $salida;
	}
	public function getarraysolicitantesdelplmid($plm_id){
		$plan_mercadeo_solicitante_model=new Planmercadeosolicitantemodel();
		$resultado=$plan_mercadeo_solicitante_model-> getPlanmercadeosolicitantesegunplmid($plm_id);
				
		return $resultado;
	}
	public function getcargosolicitantesdelplmid($plm_id){
		$plan_mercadeo_solicitante_model=new Planmercadeosolicitantemodel();
		$resultado=$plan_mercadeo_solicitante_model-> getPlanmercadeosolicitantesegunplmid($plm_id);
		
		$salida='';
		foreach ($resultado as $value) {
			$salida=$salida.' '.$value['car_cargo'].',';
		}
		return $salida;
	}
	public function getarrayasumeplmid($plm_id){
		$plan_mercadeo_asume_model=new Planmercadeoasumemodel();
		$resultado=$plan_mercadeo_asume_model-> getPlanmercadeoasumesegunplmid($plm_id);
		
		return $resultado;
	}
	public function getarrayanombresumeplmid($plm_id){
		$plan_mercadeo_asume_model=new Planmercadeoasumemodel();
		$resultado=$plan_mercadeo_asume_model-> getPlanmercadeoasumesegunplmid($plm_id);
		$salida='';
		foreach ($resultado as $value) {
			$salida=$salida.' '.$value['asu_nombre'].',';
		}
		return $salida;
	}
	public function agregarmaterialreal()
	{
		
		$array_datos_material_real=json_decode($this->request->getPost('datos'),true);
		$pma_id=$this->request->getPost('pmaid');
		$pmr_fecha=$this->request->getPost('pmrfecha');
		$pmr_cantidad=$this->request->getPost('pmr_cantidad');
		$pmr_valor_unitario=$this->request->getPost('pmr_valor_unitario');
		$pmr_subtotal=$this->request->getPost('pmr_subtotal');
		$pmr_iva=$this->request->getPost('pmr_iva');
		$pmr_total=$this->request->getPost('pmr_total');
		$pmr_nombre_proveedor=$this->request->getPost('pmr_nombre_proveedor');
		$pmr_numero_documento=$this->request->getPost('pmr_numero_documento');
		$pmr_estado=1;
		if(empty($pma_id)){
			return json_encode(false);
		}
		$plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();
		$datos_material_real=array(
			'pma_id'=>$pma_id,
			'pmr_fecha'=>$pmr_fecha,
			'pmr_cantidad'=>$pmr_cantidad,
			'pmr_valor_unitario'=>$pmr_valor_unitario,
			'pmr_subtotal'=>$pmr_subtotal,
			'pmr_iva'=>$pmr_iva,
			'pmr_total'=>$pmr_total,
			'pmr_nombre_proveedor'=>$pmr_nombre_proveedor,
			'pmr_numero_documento'=>$pmr_numero_documento,
			'pmr_estado'=>1,
		);
		$plan_mercadeo_material_real_model->insertar($datos_material_real);
		$this->actualizarmaterialrealsegunpmaid($pma_id);

		return json_encode(true);
	}

	public function mostrardatosmaterialrealsegunpmaid()
	{
		$pma_id=$this->request->getPost('pmaid');
		$plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();
		if(!empty($pma_id)){
			$datos=$plan_mercadeo_material_real_model->getPlanmercadeomaterialrealsegunpmaid($pma_id);
			return json_encode($datos);
		}else{
			return json_encode([]);
		}
	}
	public function eliminardatosmaterialreal()
	{
		$pmr_id=$this->request->getPost('pmr_id');
		$pma_id=$this->request->getPost('pma_id');
		$plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();
		if(!empty($pmr_id)){
			$plan_mercadeo_material_real_model->eliminar($pmr_id);
			$this->actualizarmaterialrealsegunpmaid($pma_id);
			return json_encode(true);
		}else{
			return json_encode(false);
		}
	}
	public function actualizarmaterialrealsegunpmaid($pma_id){
		$plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();
		$datos=$plan_mercadeo_material_real_model->getPlanmercadeomaterialrealsegunpmaid($pma_id);
		
		$subtotal=0;
		$iva=0;
		$total=0;
		foreach ($datos as $value) {
			$subtotal=$subtotal+$value['pmr_subtotal'];
			$iva=$iva+$value['pmr_iva'];
			$total=$total+$value['pmr_total'];
		}

		$datos_material=array(
			'pma_subtotal_real'=>$subtotal,
			'pma_iva'=>$iva,
			'pma_total_real'=>$total,
		);

		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$plan_mercadeo_material_model->actualizar($pma_id,$datos_material);

		$datos=$plan_mercadeo_material_model->getUnPlanmercadeomaterial($pma_id);

		if(!empty($datos)){
			$plm_id=$datos[0]['plm_id'];
			$datos=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($plm_id);
			$gasto_total_material=0;
			foreach ($datos as $value) {
				$gasto_total_material=$gasto_total_material+$value['pma_total_real'];
			}
			$plan_model=new Planmodel();
			$datos_plan_mercadeo=array(
				'plm_total_real_material'=>$gasto_total_material,
			);
			$plan_model->actualizar($plm_id,$datos_plan_mercadeo);
		}

		return $total;
	}
	

    public function resumenplanes(){
        
        $session = \Config\Services::session();
		if(empty($session->get('USU_ID'))){
			return redirect()->to(base_url()); 
		}

		$are_id=$session->get('are_id');
		$USU_ID=$session->get('USU_ID');
		$hrp_fecha_hora=date('Y-m-d H:i:s');
		$datos_historial_resumen_plan=array(		
			'are_id'=>$are_id,
			'USU_ID'=>$USU_ID,
			'hrp_fecha_hora'=>$hrp_fecha_hora,
			'hrp_estado'=>1,
		);

		$historial_resumen_plan_model = new Historialresumenplanesmodel();
		$historial_resumen_plan_model->insertar($datos_historial_resumen_plan);
		
		
		$session = \Config\Services::session();
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		$plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();

		$rol_id=$session->get('ROL_ID');
		if($rol_id==1){
			$are_id=null;
		}else{
			$are_id=$session->get('are_id');
		}

		$datos=$plan_mercadeo_material_real_model->getResumenplanes($are_id);
		$datos_resumen=[];
		foreach ($datos as  $value) {
			$fecha = $this->obtenernombredelmes(date('m',strtotime($value['pmr_fecha'])));
			$datos_resumen[]=array(
				'mes'=>$fecha,
				'pmr_fecha'=>$value['pmr_fecha'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_totalgastomateriales'=>$value['plm_totalgastomateriales'],
				'pmr_subtotal'=>$value['pmr_subtotal'],
				'pmr_numero_documento'=>$value['pmr_numero_documento'],
				'saldo_gasto'=>0,
			);
		}


		$datos_resumen=$this->calculossaldogasto($datos_resumen); 
		
		$enviar_datos=array(
			'datos_resumen'=>$datos_resumen,
		);

		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/reportegasto",$enviar_datos);
		echo view("layouts/footer");
	}


	public function obtenernombredelmes($m){
		if($m==1){
			return "Enero";
		}else if($m==2){
			return "Febrero";
		}else if($m==3){
			return "Marzo";
		}else if($m==4){
			return "Abril";
		}else if($m==5){
			return "Mayo";
		}else if($m==6){
			return "Junio";
		}else if($m==7){
			return "Julio";
		}else if($m==8){
			return "Agosto";
		}else if($m==9){
			return "Septiembre";
		}else if($m==10){
			return "Octubre";
		}else if($m==11){
			return "Noviembre";
		}else if($m==12){
			return "Diciembre";
		}
	}

	public function calculossaldogasto($datos){
		
		foreach ($datos as $key => $value) {
			$saldo_anterior=$this->obtenerelsaldogastoanterior($datos,$value,$key);

			if($saldo_anterior==0){
				$value['saldo_gasto']=floatval($value['plm_totalgastomateriales'])- floatval($value['pmr_subtotal']) ;

			}else{
				$value['saldo_gasto']=$saldo_anterior-floatval($value['pmr_subtotal']);
				$value['plm_totalgastomateriales']=$saldo_anterior;
			}

			$datos[$key]=$value;
		}
		
		return $datos;

	}

	public function obtenerelsaldogastoanterior($datos,$obj_resumen_plan,$index){

		$saldo_anterior=0;

		foreach ($datos as $key=>  $value) {
			if($value['plm_codigo']==$obj_resumen_plan['plm_codigo'] && $key!=$index){
				$saldo_anterior=$value['saldo_gasto'];
				
				
			}
			if($value['plm_codigo']==$obj_resumen_plan['plm_codigo'] && $value['pmr_numero_documento']==$obj_resumen_plan['pmr_numero_documento'] ){
				
				return $saldo_anterior;
			}
		}

		return $saldo_anterior;

	}
	
	public function agregarauspicioreal()
	{
		$aup_id=$this->request->getPost('aupid');
		$aur_fecha=$this->request->getPost('aurfecha');
		$aur_auspiciante=$this->request->getPost('aur_auspiciante');
		$aur_forma_cobro=$this->request->getPost('aur_forma_cobro');
		$aur_valor=$this->request->getPost('aur_valor');
		$aur_porcentaje=$this->request->getPost('aur_porcentaje');
		$aur_cobrado=$this->request->getPost('aur_cobrado');
		if(empty($aup_id)){
			return json_encode(false);
		}
		$auspiciante_real_model= new Auspicianterealmodel();
		$datos_auspiciante_real=array(
			'aup_id'=>$aup_id,
			'aur_fecha'=>$aur_fecha,
			'aur_auspiciante'=>$aur_auspiciante,
			'aur_forma_cobro'=>$aur_forma_cobro,
			'aur_valor'=>$aur_valor,
			'aur_porcentaje'=>$aur_porcentaje,
			'aur_cobrado'=>$aur_cobrado,
			'aur_estado'=>1,
		);
		$auspiciante_real_model->insertar($datos_auspiciante_real);

		return json_encode(true);
	}

	public function mostrardatosauspiciorealsegunaupid()
	{
		$aup_id=$this->request->getPost('aup_id');
		$auspiciante_real_model= new Auspicianterealmodel();
		if(!empty($aup_id)){
			$datos=$auspiciante_real_model->getAuspicianterealrealsegunaupid($aup_id);
			return json_encode($datos);
		}else{
			return json_encode([]);
		}
	}
	public function eliminardatosauspicioreal()
	{
		$aur_id=$this->request->getPost('aur_id');
		$auspiciante_real_model= new Auspicianterealmodel();
		if(!empty($aur_id)){
			$auspiciante_real_model->eliminar($aur_id);
			return json_encode(true);
		}else{
			return json_encode(false);
		}
	}
	
	public function resumenplanesauspicio(){

		
		$session = \Config\Services::session();
		if(empty($session->get('ROL_ID'))){
			return redirect()->to(base_url());
		}
		
		$usuario_model= new UsuarioModel();
		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);


		$auspiciante_real_model= new Auspicianterealmodel();


		$rol_id=$session->get('ROL_ID');
		
		if($rol_id==1){
			$are_id=null;
		}else{
			$are_id=$session->get('are_id');
		}

		$datos=$auspiciante_real_model->getResumenauspicios($are_id);
		$datos_resumen=[];
		foreach ($datos as  $value) {
			$fecha = $this->obtenernombredelmes(date('m',strtotime($value['aur_fecha'])));
			$datos_resumen[]=array(
				'mes'=>$fecha,
				'aur_fecha'=>$value['aur_fecha'],
				'plm_codigo'=>$value['plm_codigo'],
				'aur_auspiciante'=>$value['aur_auspiciante'],
				'aur_forma_cobro'=>$value['aur_forma_cobro'],
				'aur_valor'=>$value['aur_valor'],
				'aur_porcentaje'=>$value['aur_porcentaje'],
				'aur_cobrado'=>$value['aur_cobrado'],
			);
		}

		
		$enviar_datos=array(
			'datos_resumen'=>$datos_resumen,
		);

		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/reporteauspicio",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();

		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
	} 
	
	public function alcance($plm_id){
		$session = \Config\Services::session();
		if(empty($plm_id)){
			$session->setFlashdata('mensaje_malo', 'No existe Dato');
			return redirect()->to(base_url('Plan')); 
		}


		$area_model= new Areamodel();
		$usuario_model= new UsuarioModel();		
		$proveedor_model= new Proveedormodel();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$tipo_franquiciado_model= new Tipofranquiciamodel();
		$tipo_tactica_model= new Tipotacticasmodel();
		$destino_activo_model= new Destinoactivomodel();
		$plan_mercadeo_tipo_alcance= new Planmercadeotipoalcancemodel();
		$asume_model= new Asumemodel();
		$cuenta_contable_model= new Cuentacontablemodel();
		$plan=new Planmodel();

		$datos_area=$area_model->getArea();
		$datos_usuario=$usuario_model->getUsuario();
		$datos_proveedor=$proveedor_model->getProveedor();
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();
		$datos_tipo_franquicia=$tipo_franquiciado_model->getTipofranquicia();
		$datos_tipo_tacticas=$tipo_tactica_model->getTipotacticas();
		$datos_desnito_activo=$destino_activo_model->getdestinoactivo();
        $datos_plan_mercadeo_tipo_alcance=$plan_mercadeo_tipo_alcance->getPlanmercadeotipoalcance();
        $datos_asume=$asume_model->getAsume();
        $datos_cuenta_contable=$cuenta_contable_model->getCuentacontable();

		

		$plan_model= new Planmodel();
		$plan_mercadeo_material_model= new Planmercadeomaterialmodel();
		$plan_mercadeo_tactica_model= new Planmercadeotacticamodel();
		$plan_mercadeo_herramienta_model= new Planmercadeoherramientamodel();
		$plan_mercadeo_tipo_tactica_model= new Planmercadeotipotacticamodel();
		$auspiciante_plan_mercadeo_model= new Auspicianteplanmercadeomodel();
        $codigo_plan=$plan->getCodigoPlan();



		
		$resultado_plan=$plan_model->getPlanID($plm_id);

		$datos_plan=[];
		$datos_mercadeo_tipo_tactica=[];
		$datos_plan_mercadeo_material=[];
		$datos_auspiciante_plan_mercadeo=[];

		foreach ($resultado_plan as $value) {
			
			
			$respuesta_mercadeo_tipo_tactica=$plan_mercadeo_tipo_tactica_model->getPlanmercadeotipotacticasegunplmid($value['plm_id']);
			foreach ($respuesta_mercadeo_tipo_tactica as  $itemtipotactica) {
				
				$respuesta_lista_tactica=$plan_mercadeo_tactica_model->getPlanmercadeotacticasegunpmtid($itemtipotactica['pmt_id']);
				$respuesta_lista_herramienta=$plan_mercadeo_herramienta_model->getPlanmercadeoherramientasegunpmtid($itemtipotactica['pmt_id']);

				$datos_mercadeo_tipo_tactica[]=array(

					'pmt_id'=>$itemtipotactica['pmt_id'],
					'tac_id'=>$itemtipotactica['tac_id'],
					'tac_tacticas'=>$itemtipotactica['tac_tacticas'],
					'pmt_objetivo'=>$itemtipotactica['pmt_objetivo'],
					'datos_lista_tactica'=>$respuesta_lista_tactica,
					'datos_lista_herramienta'=>$respuesta_lista_herramienta,
				);				
				
			}
			$respuesta_mercadeo_tipo_tactica=[];

			$datos_plan_mercadeo_material=$plan_mercadeo_material_model->getPlanmercadeomaterialegunplmid($value['plm_id']);
			$datos_auspiciante_plan_mercadeo=$auspiciante_plan_mercadeo_model->getAuspicianteplanmercadeoegunplmid($value['plm_id']);
			
			
            
            if($value['plm_desde_alcance']=='0000-00-00'){
				$value['plm_desde_alcance']=null;
			}
			if($value['plm_hasta_alcance']=='0000-00-00'){
				$value['plm_hasta_alcance']=null;
			}
			if($value['plm_pi_desde_alcance']=='0000-00-00'){
				$value['plm_pi_desde_alcance']=null;
			}
			if($value['plm_pi_hasta_alcance']=='0000-00-00'){
				$value['plm_pi_hasta_alcance']=null;
			}
			
			$datos_array_solicitante=$this->getarraysolicitantesdelplmid($value['plm_id']);
			
			if(empty($datos_array_solicitante)){
				$datos_array_solicitante[]=array(
					'USU_ID'=>$value['USU_ID'],
					'car_cargo'=>$value['car_cargo'],
					'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				);
			}
			$datos_array_asume=$this->getarrayasumeplmid($value['plm_id']);

			$datos_plan[]=array(			

                
			    'usu_id'=>$value['usu_id'],
				'plm_id'=>$value['plm_id'],
				'plm_codigo'=>$value['plm_codigo'],
				'plm_nombreplan'=>$value['plm_nombreplan'],
				'plm_objetivo'=>$value['plm_objetivo'],
				'plm_fechacreacion'=>$value['plm_fechacreacion'],
				'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
				'plm_fechafinplan'=>$value['plm_fechafinplan'],
				'plm_solicitante'=>$value['plm_solicitante'],
				'plm_areadestino'=>$value['plm_areadestino'],
				'are_area'=>$value['are_area'],
				'are_id'=>$value['are_id'],
				'DAP_NOMBRES'=>$value['DAP_NOMBRES'],
				'USU_ID'=>$value['USU_ID'],
				'plm_ventasactuales'=>$value['plm_ventasactuales'],
				'plm_valorincrementoventasesperado'=>$value['plm_valorincrementoventasesperado'],
				'plm_porcentajeincrementoventasesperado'=>$value['plm_porcentajeincrementoventasesperado'],
				'plm_totalgastomateriales'=>$value['plm_totalgastomateriales'],
				'plm_desde_alcance'=>$value['plm_desde_alcance'],
				'plm_hasta_alcance'=>$value['plm_hasta_alcance'],
				'plm_observaciones'=>$value['plm_observaciones'],
				'plm_pi_desde_alcance'=>$value['plm_pi_desde_alcance'],
				'plm_pi_hasta_alcance'=>$value['plm_pi_hasta_alcance'],
				'plm_cuenta_contable'=>$value['plm_cuenta_contable'],
				'plm_centro_costo'=>$value['plm_centro_costo'],
				'plm_tipo_alcance'=>$value['plm_tipo_alcance'],

				'datos_mercadeo_tipo_tactica'=>$datos_mercadeo_tipo_tactica,
				'datos_plan_mercadeo_material'=>$datos_plan_mercadeo_material,
				'datos_auspiciante_plan_mercadeo'=>$datos_auspiciante_plan_mercadeo,
				'datos_array_solicitante'=>$datos_array_solicitante,
				'datos_array_asume'=>$datos_array_asume,

			);
			$datos_mercadeo_tipo_tactica=[];
			$datos_plan_mercadeo_material=[];
			$datos_auspiciante_plan_mercadeo=[];
			$datos_array_solicitante=[];
			$datos_array_asume=[];

		}
		$usuario_model= new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datosM = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);

		
		$enviar_datos=array(
			'datos_area' => !empty($datos_area)?$datos_area:null , 
			'datos_usuario' => !empty($datos_usuario)?$datos_usuario:null , 
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:null , 
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:null , 
			'datos_tipo_franquicia' => !empty($datos_tipo_franquicia)?$datos_tipo_franquicia:null , 
			'datos_tipo_tacticas' => !empty($datos_tipo_tacticas)?$datos_tipo_tacticas:null , 
			'datos_desnito_activo' => !empty($datos_desnito_activo)?$datos_desnito_activo:null ,
			'datos_plan_mercadeo'=>$datos_plan,		
			'datos_plan_mercadeo_tipo_alcance' => !empty($datos_plan_mercadeo_tipo_alcance)?$datos_plan_mercadeo_tipo_alcance:[] ,	
			'datos_asume' => !empty($datos_asume)?$datos_asume:[] ,
			'datos_cuenta_contable' => !empty($datos_cuenta_contable)?$datos_cuenta_contable:[] ,
			'codigo_plan' => !empty($codigo_plan)?$codigo_plan:null , 
		);
		
		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datosM);
		echo view("plan/alcance",$enviar_datos);
		echo view("layouts/footer");

	}
	public function PresupuestoAreaRestante()
	{
		$session = \Config\Services::session();

		$area_model= new Areamodel();
		$permitircrearplan=true;
        
        //OBTENER PRESUPUESTO RESTANTE POR AREA
        $resultado_presupuesto=$area_model->getPresupuestoAreaYearActual($session->get('areid')); 
	    if(count($resultado_presupuesto)>0)
	    {
	        $resultado_presupuesto=$resultado_presupuesto[0]['arp_presupuesto'];
	    }
	    else
	    {
	        $resultado_presupuesto=0;
	    }
	    $resultado_presupuesto_usado=$area_model->getPresupuestoAreaUsadoYearActual($session->get('areid'));
	    if(count($resultado_presupuesto_usado)>0)
	    {
		    $diferencia=$resultado_presupuesto_usado[0]['mat']-$resultado_presupuesto_usado[0]['aup'];
		    $presupuesto_restante=$resultado_presupuesto-$diferencia;
	    }
	    else
	    {
	        $presupuesto_restante=$resultado_presupuesto;
	    }
	    if($resultado_presupuesto>0)
	    {
	        $p='El presupuesto anual restante es de: '.money_format('%(#10n',$presupuesto_restante);
	        if(Date('Y')!=2022){
    	        if($presupuesto_restante<=0)
    	        {
    	            $permitircrearplan=false;
    	            $p+=', solicite incremento de presupuesto para su área';
    	        }
	        }
	    }
	    else
	    {
	        $p='No tiene asignado presupuesto para el año actual, solicite asignación de presupuesto para su área';
	        if(Date('Y')!=2022){
	            $permitircrearplan=false;
	        }
	    }
	    $session->set('permitircrearplan', $permitircrearplan);
	    return $p;
	} 
}