<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Tipofranquiciacomisionesmodel;
use App\Models\Ivarentapdvmodel;
use App\Models\Porcentajecomisionmodel;
class Puntoventa extends BaseController
{

	public function index(){
		$datos = $this->datosMenu();
		$punto_venta_model=new Puntoventamodel();
        $tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
        $iva_renta_pdv_model=new Ivarentapdvmodel();
        $porcentaje_comision_model=new Porcentajecomisionmodel();
        
		$datos_punto_venta = $punto_venta_model->getPuntoventa();
        $datos_tipo_franquicia_comisiones= $tipo_franquicia_comisiones_model->getTipofranquiciacomisiones();
        $datos_iva_renta_pdv=$iva_renta_pdv_model->getIvarentapdv();
        $datos_porcentaje_comision=$porcentaje_comision_model->getPorcentajecomision();
        
		$enviar_datos=array(
			'datos_punto_venta'=>$datos_punto_venta,
			'datos_tipo_franquicia_comisiones'=>$datos_tipo_franquicia_comisiones,
			'datos_iva_renta_pdv'=>$datos_iva_renta_pdv,
			'datos_porcentaje_comision'=>$datos_porcentaje_comision,
		);

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("puntoventa/list",$enviar_datos);
		echo view("layouts/footer");
	}
	public function leerpuntosventa(){		
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("puntoventa/cargarpuntoventa");
		echo view("layouts/footer");
	}
	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		

		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('Hoja1');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "Hoja1"');
				return redirect()->to(base_url('Puntoventa/leerpuntosventa'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{
					$puv_punto_venta = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();   
					$puv_provincia = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
					$puv_parroquia = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
					$puv_ciudad = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
					$puv_direccion = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
					$puv_franquiciado = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
					$puv_telefono_personal = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
					$puv_telefono_pdv = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
					$puv_correo_empresa = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
					$puv_correo_personal = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();					

					if($puv_punto_venta!=''){
						$puv_id= $punto_venta_model->getPuntoventasegunnombre($puv_punto_venta);
						$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

						if($puv_id==0){
							$data[]=array(
								'puv_punto_venta'=>$puv_punto_venta,
								'puv_provincia'=>$puv_provincia,
								'puv_parroquia'=>$puv_parroquia,	
								'puv_ciudad'=>$puv_ciudad,	
								'puv_direccion'=>$puv_direccion,	
								'puv_franquiciado'=>$puv_franquiciado,	
								'puv_telefono_personal'=>$puv_telefono_personal,	
								'puv_telefono_pdv'=>$puv_telefono_pdv,	
								'puv_correo_empresa'=>$puv_correo_empresa,
								'puv_correo_personal'=>$puv_correo_personal,						
							);
						}else{
							$pdv_no_encontrados=$pdv_no_encontrados.' '.$puv_punto_venta.',';
						}
						
					}						
				}
				break;

			}
			
			$datos = $this->datosMenu();
			$enviar_datos=array(           
				'data'=>$data,	
				'mensaje'=>$pdv_no_encontrados,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("puntoventa/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Puntoventa/leerpuntosventa')); 
		}

	}

	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos'))){			   
			$datos=$this->request->getPost('datos');
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);			

			$punto_venta_model=new Puntoventamodel();
			foreach ($datos as $value) {

				$datos_punto_venta=array(
				
					'puv_fecha_apertura'=>'0000-00-00',
					'puv_fecha_cierre'=>'0000-00-00',
					'puv_punto_venta'=>!empty($value['puv_punto_venta'])?$value['puv_punto_venta']:'',
					'puv_provincia'=>!empty($value['puv_provincia'])?$value['puv_provincia']:'',
					'puv_parroquia'=>!empty($value['puv_parroquia'])?$value['puv_parroquia']:'',
					'puv_ciudad'=>!empty($value['puv_ciudad'])?$value['puv_ciudad']:'',
					'puv_direccion'=>!empty($value['puv_direccion'])?$value['puv_direccion']:'',
					'puv_franquiciado'=>!empty($value['puv_franquiciado'])?$value['puv_franquiciado']:'',
					'puv_telefono_personal'=>!empty($value['puv_telefono_personal'])?$value['puv_telefono_personal']:'',
					'puv_telefono_pdv'=>!empty($value['puv_telefono_pdv'])?$value['puv_telefono_pdv']:'',
					'puv_correo_empresa'=>!empty($value['puv_correo_empresa'])?$value['puv_correo_empresa']:'',
					'puv_correo_personal'=>!empty($value['puv_correo_personal'])?$value['puv_correo_personal']:'',
					'puv_estado'=>1,
					'puv_propio'=>0,
					'tfc_id'=>1,
				);
				

				$punto_venta_model->insertar($datos_punto_venta);
				

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Puntoventa/leerpuntosventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Puntoventa/leerpuntosventa')); 
		}

	}
	
	public function add(){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('pdv')) && !empty($this->request->getPost('ciudad')) && !empty($this->request->getPost('franquiciado')) && !empty($this->request->getPost('telepersonal')) && !empty($this->request->getPost('correoempresa')) && !empty($this->request->getPost('direccion')) && !empty($this->request->getPost('fechaapertura'))&& !empty($this->request->getPost('tfcid'))){			   
			
			$punto_venta_model=new Puntoventamodel();
			
			$puv_punto_venta=$this->request->getPost('pdv');
			$puv_provincia=$this->request->getPost('provincia');
			$puv_parroquia=$this->request->getPost('parroquia');
			$puv_ciudad=$this->request->getPost('ciudad');
			$puv_direccion=$this->request->getPost('direccion');
			$puv_franquiciado=$this->request->getPost('franquiciado');
			$puv_telefono_personal=$this->request->getPost('telepersonal');
			$puv_telefono_pdv=$this->request->getPost('telepdv');
			$puv_correo_empresa=$this->request->getPost('correoempresa');
			$puv_correo_personal=$this->request->getPost('correopersonal');
            $puv_fecha_apertura=$this->request->getPost('fechaapertura');
            if(!empty($this->request->getPost('ruc'))){
				$puv_ruc=$this->request->getPost('ruc');
			}else{
				$puv_ruc=0;
			}
            if(!empty($this->request->getPost('centrocosto'))){
				$puv_centro_costo=$this->request->getPost('centrocosto');
			}else{
				$puv_centro_costo=0;
			}
            $tfc_id=$this->request->getPost('tfcid');
			if(!empty($this->request->getPost('propia'))){
				$puv_propio=$this->request->getPost('propia');
			}else{
				$puv_propio=0;
			}
            $puv_id= $punto_venta_model->getPuntoventasegunnombre($puv_punto_venta);
			$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

			if($puv_id!=0){
				$session->setFlashdata('mensaje_malo', 'El PDV: '.$puv_punto_venta.' ya existe');
				return redirect()->to(base_url('Puntoventa'));
			}
			$irp_id=$this->request->getPost('irpid');
			$pco_id=$this->request->getPost('pcoid');

			$datos_punto_venta=array(
				
				'puv_fecha_apertura'=>$puv_fecha_apertura,
				'puv_punto_venta'=>$puv_punto_venta,
				'puv_ruc'=>$puv_ruc,
				'puv_centro_costo'=>$puv_centro_costo,
				'puv_provincia'=>$puv_provincia,
				'puv_parroquia'=>$puv_parroquia,
				'puv_ciudad'=>$puv_ciudad,
				'puv_direccion'=>$puv_direccion,
				'puv_franquiciado'=>$puv_franquiciado,
				'puv_telefono_personal'=>$puv_telefono_personal,
				'puv_telefono_pdv'=>$puv_telefono_pdv,
				'puv_correo_empresa'=>$puv_correo_empresa,
				'puv_correo_personal'=>$puv_correo_personal,
				'puv_estado'=>1,
				'tfc_id'=>$tfc_id,
				'puv_propio'=>$puv_propio,
				'irp_id'=>$irp_id,
				'pco_id'=>$pco_id,
			);


			$punto_venta_model->insertar($datos_punto_venta);


			

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Puntoventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Faltan Datos');
			return redirect()->to(base_url('Puntoventa')); 
		}

	}
	public function edit(){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('editarpuvid')) && !empty($this->request->getPost('editarpdv')) && !empty($this->request->getPost('editciudad')) && !empty($this->request->getPost('editfranquiciado')) && !empty($this->request->getPost('edittelepersonal')) && !empty($this->request->getPost('editcorreoempresa')) && !empty($this->request->getPost('editdireccion')) && !empty($this->request->getPost('editfechaapertura'))){			   
			
			$punto_venta_model=new Puntoventamodel();
			$puv_id=$this->request->getPost('editarpuvid');
			echo '<pre>'; print_r($puv_id); echo '</pre>';
			$puv_punto_venta=$this->request->getPost('editarpdv');
			$puv_provincia=$this->request->getPost('editprovincia');
			$puv_parroquia=$this->request->getPost('editparroquia');
			$puv_ciudad=$this->request->getPost('editciudad');
			$puv_direccion=$this->request->getPost('editdireccion');
			$puv_franquiciado=$this->request->getPost('editfranquiciado');
			$puv_telefono_personal=$this->request->getPost('edittelepersonal');
			$puv_telefono_pdv=$this->request->getPost('edittelepdv');
			$puv_correo_empresa=$this->request->getPost('editcorreoempresa');
			$puv_correo_personal=$this->request->getPost('editcorreopersonal');
            $puv_fecha_apertura=$this->request->getPost('editfechaapertura');
			$tfc_id=$this->request->getPost('edittfcid');
			if(!empty($this->request->getPost('editpropia'))){
				$puv_propio=$this->request->getPost('editpropia');
			}else{
				$puv_propio=0;
			}
            if(!empty($this->request->getPost('editruc'))){
				$puv_ruc=$this->request->getPost('editruc');
			}else{
				$puv_ruc=0;
			}
            if(!empty($this->request->getPost('editcentrocosto'))){
				$puv_centro_costo=$this->request->getPost('editcentrocosto');
			}else{
				$puv_centro_costo=0;
			}
			$puv_nombre= $punto_venta_model->getUnPuntoventa($puv_id);
			$puv_nombre=!empty($puv_nombre[0]['puv_punto_venta'])?$puv_nombre[0]['puv_punto_venta']:'';

            $irp_id=$this->request->getPost('editirpid');
            $pco_id=$this->request->getPost('editpcoid');
            
			if($puv_punto_venta==$puv_nombre){
				$datos_punto_venta=array(

					'puv_fecha_apertura'=>$puv_fecha_apertura,
					'puv_punto_venta'=>$puv_punto_venta,
				    'puv_ruc'=>$puv_ruc,
				    'puv_centro_costo'=>$puv_centro_costo,
					'puv_provincia'=>$puv_provincia,
					'puv_parroquia'=>$puv_parroquia,
					'puv_ciudad'=>$puv_ciudad,
					'puv_direccion'=>$puv_direccion,
					'puv_franquiciado'=>$puv_franquiciado,
					'puv_telefono_personal'=>$puv_telefono_personal,
					'puv_telefono_pdv'=>$puv_telefono_pdv,
					'puv_correo_empresa'=>$puv_correo_empresa,
					'puv_correo_personal'=>$puv_correo_personal,
					'puv_estado'=>1,
					'puv_propio'=>$puv_propio,
					'tfc_id'=>$tfc_id,
					'irp_id'=>$irp_id,
					'pco_id'=>$pco_id,
				);
				$punto_venta_model->actualizar($puv_id,$datos_punto_venta);
			}else{
				$puv_nombre= $punto_venta_model->getPuntoventasegunnombre($puv_punto_venta);
				$puv_nombre=!empty($puv_nombre[0]['puv_id'])?$puv_nombre[0]['puv_id']:0;

				if($puv_nombre!=0){
					$session->setFlashdata('mensaje_malo', 'El PDV: '.$puv_punto_venta.' ya existe');
					return redirect()->to(base_url('Puntoventa'));
				}
				$datos_punto_venta=array(

					'puv_fecha_apertura'=>$puv_fecha_apertura,
					'puv_punto_venta'=>$puv_punto_venta,
				    'puv_ruc'=>$puv_ruc,
				    'puv_centro_costo'=>$puv_centro_costo,
					'puv_provincia'=>$puv_provincia,
					'puv_parroquia'=>$puv_parroquia,
					'puv_ciudad'=>$puv_ciudad,
					'puv_direccion'=>$puv_direccion,
					'puv_franquiciado'=>$puv_franquiciado,
					'puv_telefono_personal'=>$puv_telefono_personal,
					'puv_telefono_pdv'=>$puv_telefono_pdv,
					'puv_correo_empresa'=>$puv_correo_empresa,
					'puv_correo_personal'=>$puv_correo_personal,
					'puv_estado'=>1,
					'puv_propio'=>$puv_propio,
					'tfc_id'=>$tfc_id,
					'irp_id'=>$irp_id,
					'pco_id'=>$pco_id,
				);
				$punto_venta_model->actualizar($puv_id,$datos_punto_venta);
			}

			
			$session->setFlashdata('mensaje_bueno', 'Dato Editado');
			return redirect()->to(base_url('Puntoventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Faltan Datos');
			return redirect()->to(base_url('Puntoventa')); 
		}

	}
	public function eliminar($puv_id){
		$session = \Config\Services::session();

		if(!empty($puv_id)){			   
			
			$punto_venta_model=new Puntoventamodel();			
			$datos_punto_venta=array(	
				'puv_estado'=>0,
			);
			$punto_venta_model->actualizar($puv_id,$datos_punto_venta);
			$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
			return redirect()->to(base_url('Puntoventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Faltan Datos');
			return redirect()->to(base_url('Puntoventa')); 
		}

	}
	
	public function obtenerseguntipofranquicia(){
		$punto_venta_model=new Puntoventamodel();
		$lista=$this->request->getPost('lista');
		if(empty($lista)){
			return json_encode([]);
		}
		$salida=[];
		foreach ($lista as $value) {
			$tfc_id=$value['tfc_id'];
			$datos=$punto_venta_model->getPuntoventatipofranquicia($tfc_id);
			$salida=array_merge($salida,$datos);
		}
		
		return json_encode($salida);
		

	}	
	

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}