<?php

namespace App\Controllers;

use App\Models\Planmercadeomaterialrealmodel;
use CodeIgniter\RESTful\ResourceController;
use App\Models\Historialresumenplanesmodel;
class Reporteplanmercadeoapi extends ResourceController
{

    public function resumenplanes(){
        try {


            $historial_resumen_plan_model = new Historialresumenplanesmodel();

            $ultimo_ingreso=$historial_resumen_plan_model->getMaxHistorialresumenplanes();
            $datos_ingreso=$historial_resumen_plan_model->getUnHistorialresumenplanes($ultimo_ingreso[0]['hrp_id']);
            if(empty($datos_ingreso)){
                return $this->genericResponse(null, "No hay datos", 404);
            }
            $are_id=$datos_ingreso[0]['are_id'];
            $rol_id=$datos_ingreso[0]['ROL_ID'];
            if($rol_id==1){
                $are_id=null;
            }

           // $plan_mercadeo_material_real_model= new Planmercadeomaterialrealmodel();            
            //$datos=$plan_mercadeo_material_real_model->getResumenplanestodos();
            
            //$datos=$plan_mercadeo_material_real_model->getResumenplanes($are_id);
            
            $datos_resumen=[];
            foreach ($datos_ingreso as  $value) {
                $fecha = $this->obtenernombredelmes(date('m',strtotime($value['pmr_fecha'])));
                $datos_resumen[]=array(
                    'plm_id'=>$value['id'],
                    'codigoplan'=>$value['id'],
                    'padre'=>$value['padre'],
                    'plm_nombreplan'=>$value['plm_nombreplan'],
                    'plm_objetivo'=>$value['plm_objetivo'],
                    'plm_fechacreacion'=>$value['plm_fechacreacion'],
                    'plm_fechainicioplan'=>$value['plm_fechainicioplan'],
                    'plm_fechafinplan'=>$value['plm_fechafinplan'],
                    'plm_totalgastomateriales'=>floatval($value['plm_totalgastomateriales']),
                    'esp_estadoplan'=>$value['esp_estadoplan'],
                    'solicitante'=>$value['DAP_NOMBRES'],
                    'are_area'=>$value['are_area'],
                    'valorplm'=>floatval($value['valorplm'])/100,
                    'proveedor'=>$value['pro_nombre'],
                    'auspicioendinero'=>floatval($value['auspicioendinero']),
                    'auspicioporcentaje'=>$value['aup_porcentaje'],
                    'valortotalauspicio'=>floatval($value['valorauspicio']),
                    'fcf_formacobro'=>$value['fcf_formacobro'],
                    'valorcobrado'=>floatval($value['valorcobrado']),
                    'porcobrar'=>floatval($value['porcobrar']),
                );
            }


            //$datos_resumen=$this->calculossaldogasto($datos_resumen);
            if(!empty($datos_ingreso)){
                return $this->genericResponse($datos_ingreso, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        



    }

    
    public function obtenernombredelmes($m){
        if($m==1){
            return "Enero";
        }else if($m==2){
            return "Febrero";
        }else if($m==3){
            return "Marzo";
        }else if($m==4){
            return "Abril";
        }else if($m==5){
            return "Mayo";
        }else if($m==6){
            return "Junio";
        }else if($m==7){
            return "Julio";
        }else if($m==8){
            return "Agosto";
        }else if($m==9){
            return "Septiembre";
        }else if($m==10){
            return "Octubre";
        }else if($m==11){
            return "Noviembre";
        }else if($m==12){
            return "Diciembre";
        }
    }

    public function calculossaldogasto($datos){

        foreach ($datos as $key => $value) {
            $saldo_anterior=$this->obtenerelsaldogastoanterior($datos,$value);

            if($saldo_anterior==0){
                $value['saldo_gasto']=floatval($value['plm_totalgastomateriales'])- floatval($value['pmr_subtotal']) ;

            }else{
                $value['saldo_gasto']=$saldo_anterior-floatval($value['pmr_subtotal']);
                $value['plm_totalgastomateriales']=floatval($saldo_anterior);
            }

            $datos[$key]=$value;
        }
        
        return $datos;

    }

    public function obtenerelsaldogastoanterior($datos,$obj_resumen_plan){
        $saldo_anterior=0;
        foreach ($datos as  $value) {
            if($value['plm_codigo']==$obj_resumen_plan['plm_codigo'] && $value['pmr_numero_documento']!=$obj_resumen_plan['pmr_numero_documento']){
                $saldo_anterior=$value['saldo_gasto'];  
            }
            if($value['plm_codigo']==$obj_resumen_plan['plm_codigo'] && $value['pmr_numero_documento']==$obj_resumen_plan['pmr_numero_documento'] ){                
                return $saldo_anterior;
            }
        }
        return $saldo_anterior;
    }


    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code,
                "data" => null,
            ));
        }
    }
}