<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tiponegociomodel;

class Tiponegocio extends BaseController
{

	public function index(){
		$tipo_negocio_model= new Tiponegociomodel();
		$datos_tipo_negocio=$tipo_negocio_model->getTiponegocio();

		$enviar_datos=array(
			'datos_tipo_negocio' => !empty($datos_tipo_negocio)?$datos_tipo_negocio:null , 
		);
		
		$datos = $this->datosMenu();


		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("tiponegocio/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_negocio_model= new Tiponegociomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tiponegocio'))){
				$tin_tipo=$this->request->getPost('tiponegocio');
				$ingresar_datos=array(
					'tin_tipo'=>$tin_tipo,
					'tin_estado'=>1
				);
				$tipo_negocio_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tiponegocio')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tiponegocio')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_negocio_model= new Tiponegociomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittiponegocio')) && !empty($this->request->getPost('edittinid'))){
				$tin_tipo=$this->request->getPost('edittiponegocio');
				$tin_id=$this->request->getPost('edittinid');
				$editar_datos=array(
					'tin_tipo'=>$tin_tipo,
					'tin_estado'=>1
				);
				$tipo_negocio_model->actualizar($tin_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tiponegocio')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tiponegocio')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_negocio_model= new Tiponegociomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tin_estado'=>0
				);
				$tipo_negocio_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Tiponegocio')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tiponegocio')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}