<?php namespace App\Controllers;

use App\Models\MenuModel;

class Home extends BaseController
{
    public function index()
{
    if (!session()->get('isLoggedIn')) {
        return redirect()->to(base_url('Auth'));
    }

    $usuId  = (int) session()->get('USU_ID');
    $menu   = session()->get('MENU');
    $rolMenu= session()->get('ROL_MENU');

    if (empty($menu) || empty($rolMenu)) {
        $menuModel = new \App\Models\MenuModel();
        $menu    = $menuModel->menuCompleto();
        $rolMenu = $menuModel->menuIdsPorUsuario($usuId);
        session()->set(['MENU'=>$menu,'ROL_MENU'=>$rolMenu]);
    }

    echo view('layouts/header');
    echo view('layouts/aside', compact('menu','rolMenu')); // ahora nunca estar indefinido
    echo view('Home/index');
    echo view('layouts/footer');
}

}
