<?php namespace App\Models;

use CodeIgniter\Model;

class CampoGlobalModel extends Model
{
    protected $table         = 'tbl_campo_global';
    protected $primaryKey    = 'cam_id';
    protected $returnType    = 'array';
    protected $allowedFields = [
        'cam_nombre','cam_titulo','cam_origen','cam_tipo',
        'cam_formato','cam_color','cam_depends','cam_source',
        'cam_formula','cam_activo'
    ];
    protected $useTimestamps = false;

    public function findByNombre(string $nombre): ?array
    {
        return $this->where('cam_nombre', $nombre)->first();
    }

    public function listActivos(): array
    {
        return $this->where('cam_activo', 1)->orderBy('cam_nombre','asc')->findAll();
    }
}
