<?php namespace App\Models;

use CodeIgniter\Model;

class PdvImportLogModel extends Model
{
    protected $DBGroup    = 'postgres';
    protected $table      = 'public.tbl_pdv_import_log';
    protected $primaryKey = 'pil_id';
    protected $returnType = 'array';
    protected $allowedFields = [
        'pdv_rec_id','lpr_rec_id','page_number','page_size','total_elements','source_url',
        'started_at','finished_at','rows_inserted','rows_ignored','status','error_message'
    ];

    public function startRun(int $recId, int $pageSize): int
    {
        return $this->insert([
            'pdv_rec_id'  => $recId,
            'page_size'   => $pageSize,
            'started_at'  => date('Y-m-d H:i:s'),
            'status'      => 'RUNNING',
            'source_url'  => 'pricing/price-product-pdv',
        ], true);
    }

    public function finishRun(int $id, array $meta): void
    {
        $row = [
            'finished_at'   => date('Y-m-d H:i:s'),
            'status'        => ($meta['errors'] ?? 0) > 0 ? 'PARTIAL' : 'OK',
            'rows_inserted' => $meta['rows_inserted'] ?? null,
            'rows_ignored'  => $meta['rows_ignored'] ?? null,
            'total_elements'=> $meta['total_elements'] ?? null,
            'lpr_rec_id'    => $meta['price_list'] ?? null,
            'page_number'   => $meta['pages'] ?? null,
            'error_message' => $meta['message'] ?? null,
        ];
        $this->update($id, $row);
    }
}
