<?php
namespace App\Models;

use CodeIgniter\Model;

class PriceListSyncLogModel extends Model
{
    protected $table         = 'tbl_price_list_sync_log';
    protected $primaryKey    = 'id';
    protected $allowedFields = [
        'started_at','finished_at','ok','message','inserted','updated','pruned','total_api'
    ];
    protected $useTimestamps = false;

    public function start(?bool $ok = true): int
    {
        // Forzar booleano
        $ok = $ok === true ? true : false;

        $this->insert([
            'started_at' => date('c'),
            'ok'         => $ok
        ]);

        return (int)$this->getInsertID();
    }

    public function finish(int $id, array $data): void
    {
        // Normalizar 'ok' si viene en $data; si no viene, no lo tocamos
        if (array_key_exists('ok', $data)) {
            $v = $data['ok'];
            // convertir strings vacíos o null en NULL para no tocar la columna
            if ($v === '' || $v === null) {
                unset($data['ok']); // evita SET ok = ''
            } else {
                // cast seguro a booleano
                $data['ok'] = in_array($v, [true, 1, '1', 'true', 't', 'on', 'yes'], true);
            }
        }

        $data['finished_at'] = date('c');
        $this->update($id, $data);
    }
}
