<?php namespace App\Models;

use CodeIgniter\Model;

class ProductoPreciosViewModel extends Model
{
    protected $table      = 'public.vw_producto_precios_calc';
    protected $primaryKey = null;           // vista sin PK
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = false;       // leemos todo
    protected $allowedFields = [];          // no escribimos

    /**
     * Búsqueda con filtros y paginación (server-side DataTables opcional).
     */
    public function buscar(array $f = [], int $limit = 25, int $offset = 0, ?string $orderBy = null, string $dir='asc')
    {
        $builder = $this->db->table($this->table);

        if (!empty($f['codigo'])) {
            $builder->like('pro_codigo', $f['codigo'], 'both', null, true);
        }
        if (!empty($f['descripcion'])) {
            $builder->like('pro_descripcion', $f['descripcion'], 'both', null, true);
        }
        if (!empty($f['lista'])) {
            $builder->where('lpr_ref_id', $f['lista']);
        }
        if (!empty($f['familia'])) {
            // familia está en tbl_producto, no en la vista actual; si la necesitas, añádela a la vista
            // por ahora, filtro por descripción como ejemplo
            $builder->like('pro_descripcion', $f['familia'], 'both', null, true);
        }

        $totalQuery = clone $builder;
        $total = $totalQuery->countAllResults(false); // false: no resetea

        if ($orderBy) {
            $builder->orderBy($orderBy, $dir);
        } else {
            $builder->orderBy('pro_codigo', 'asc')->orderBy('lpr_nombre','asc');
        }

        if ($limit > 0) {
            $builder->limit($limit, $offset);
        }

        $rows = $builder->get()->getResultArray();

        return ['total' => $total, 'rows' => $rows];
    }
}
