<?php namespace App\Models;

use CodeIgniter\Model;

class SyncLogProductoModel extends Model
{
    protected $DBGroup       = 'postgres';
    protected $table         = 'public.tbl_sync_log_producto';
    protected $primaryKey    = 'slog_id';
    protected $returnType    = 'array';
    protected $useAutoIncrement = true;

    protected $allowedFields = [
        'started_at','finished_at','page_size','total_pages','total_elements',
        'inserted','updated','inactivated','errors','status','message'
    ];

    public function startRun(int $pageSize): int
    {
        return $this->insert([
            'started_at' => date('Y-m-d H:i:s'),
            'page_size'  => $pageSize,
            'status'     => 'RUNNING',
            'message'    => ''
        ], true);
    }

    public function finishRun(int $id, array $data): void
    {
        $safe = array_intersect_key($data, array_flip($this->allowedFields));
        $this->update($id, $safe + ['finished_at'=>date('Y-m-d H:i:s')]);
    }
}
