<?php
// -------- Fallbacks seguros desde sesi���n --------
$menu    = (isset($menu) && is_array($menu)) ? $menu : (session('MENU') ?? []);
$rolMenu = (isset($rolMenu) && is_array($rolMenu)) ? $rolMenu : (session('ROL_MENU') ?? []);

// Normaliza arrays
$menu    = is_array($menu)    ? $menu    : [];
$rolMenu = is_array($rolMenu) ? $rolMenu : [];

// Si no hay nada, evita romper la vista
if (!$menu || !$rolMenu) {
    $menu = $menu ?? [];
    $rolMenu = $rolMenu ?? [];
}

// -------- Pre-c���lculos (optimizaci���n) --------
// Conjunto de MEN_ID permitidos para el usuario
$permitidos = [];
foreach ($rolMenu as $rm) {
    // Soporta tanto ['men_id'=>...] como valores simples
    $id = is_array($rm) ? ($rm['men_id'] ?? null) : $rm;
    if ($id !== null) $permitidos[(int)$id] = true;
}

// ���ndice por men_id
$byId = [];
foreach ($menu as $m) {
    $byId[(int)$m['men_id']] = $m;
}

// Hijos por padre
$children = [];
foreach ($menu as $m) {
    $padre = (int)($m['men_padre'] ?? 0);
    $children[$padre][] = $m;
}

// Helper: ���est��� permitido este men_id?
$allowed = static function($id) use ($permitidos) {
    return isset($permitidos[(int)$id]);
};

// Helper: sanitiza ruta
$href = static function($ruta) {
    $ruta = ltrim((string)$ruta, '/');
    return base_url($ruta);
};
?>

<ul class="nav navbar-nav search-nav">
  <?php if ($menu && $rolMenu): ?>
    <?php
      // Renderiza solo nodos ra���z permitidos
      foreach ($children[0] ?? [] as $m):
        if (!$allowed($m['men_id'] ?? 0)) continue;

        $icono = isset($m['men_icono']) && $m['men_icono'] !== '' ? $m['men_icono'] : 'fa fa-circle-o';
        $nombre = $m['men_nombre'] ?? '';
        $ruta = $m['men_ruta'] ?? '#';

        // Hijos directos del ���tem
        $hijos = $children[(int)$m['men_id']] ?? [];
        // Filtra hijos no permitidos
        $hijosPermitidos = array_values(array_filter($hijos, fn($h) => $allowed($h['men_id'] ?? 0)));
    ?>
      <?php if (!empty($hijosPermitidos)): ?>
        <li class="dropdown">
          <a class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
            <span class="<?= esc($icono) ?>"></span> <?= esc($nombre) ?>
            <span class="fa-angle-right fa right-arrow text-right"></span>
          </a>
          <ul class="dropdown-menu">
            <?php foreach ($hijosPermitidos as $m2): ?>
              <li>
                <a href="<?= $href($m2['men_ruta'] ?? '#') ?>"><?= esc($m2['men_nombre'] ?? '') ?></a>
              </li>
            <?php endforeach; ?>
          </ul>
        </li>
      <?php else: ?>
        <li>
          <a href="<?= $href($ruta) ?>">
            <span class="<?= esc($icono) ?>"></span> <?= esc($nombre) ?>
          </a>
        </li>
      <?php endif; ?>
    <?php endforeach; ?>
  <?php endif; ?>
</ul>

<ul class="nav navbar-nav navbar-right user-nav">
  <li class="user-name">
    <span><?= esc(session('USU_CORREO') ?? '') ?></span>
  </li>
  <li class="dropdown avatar-dropdown">
    <img src="<?= base_url('plantilla/template/asset/img/avatar.jpg') ?>" class="img-circle avatar" alt="user name" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"/>
    <ul class="dropdown-menu user-dropdown">          
      <li role="separator" class="divider"></li>
      <li class="more">
        <ul>
          <li></li>
          <li><a href="<?= base_url('Auth/logout'); ?>"><span class="fa fa-power-off"></span> Salir</a></li>
          <li><a href="#" data-toggle="modal" data-target="#cambiarclavemodal"><span class="fa fa-lock"></span> Cambiar clave</a></li>
        </ul>
      </li>
    </ul>
  </li>
</ul>
</div><!-- /.navbar-header or wrappers que tengas -->
  </div><!-- /.nav-wrapper -->
</nav>

<div class="content-wrapper container-fluid" style="min-height:calc(100vh - 70px); padding:20px;">
