<?php
$matId   = (int)($mat['mat_id'] ?? 0);
$matTipo = esc($mat['mat_tipo'] ?? '');
$matNom  = esc($mat['mat_nombre'] ?? '');
?>
<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">
      Campos de la matriz: <?= $matNom ?> <small class="text-muted">(<?= $matTipo ?>)</small>
    </h2>
    <div>
      <a href="<?= site_url('matrices'); ?>" class="btn btn-sm btn-default">Volver</a>
      <button id="btn-nuevo" class="btn btn-sm btn-primary">Nuevo campo</button>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <table id="tbl-campos" class="table table-sm table-striped table-bordered w-100">
        <thead>
          <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Título</th>
            <th>Origen</th>
            <th>Tipo</th>
            <th>Orden</th>
            <th>Visible</th>
            <th style="width:180px;">Acciones</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
      <small class="text-muted">Tip: “Origen” puede ser <b>lectura</b>, <b>param</b> o <b>formula</b>.</small>
    </div>
  </div>
</div>

<!-- Modal crear/editar campo -->
<div class="modal fade" id="modalCampo" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="frmCampo" autocomplete="off">
        <div class="modal-header">
          <h5 class="modal-title">Campo</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>

        <div class="modal-body">
          <input type="hidden" name="mac_id" id="mac_id">

          <div class="form-row">
            <div class="form-group col-md-4">
              <label>Nombre (clave)</label>
              <input type="text" class="form-control" name="mac_nombre" id="mac_nombre" required>
              <small class="text-muted">Único dentro de la matriz (p.ej. <code>pp_actual</code>, <code>precio_base</code>).</small>
            </div>
            <div class="form-group col-md-5">
              <label>Título</label>
              <input type="text" class="form-control" name="mac_titulo" id="mac_titulo" required>
            </div>
            <div class="form-group col-md-3">
              <label>Origen</label>
              <select class="form-control" name="mac_origen" id="mac_origen">
                <option value="lectura">lectura</option>
                <option value="param">param</option>
                <option value="formula">formula</option>
              </select>
            </div>
          </div>

          <div class="form-row">
            <div class="form-group col-md-3">
              <label>Tipo</label>
              <select class="form-control" name="mac_tipo" id="mac_tipo">
                <option value="text">text</option>
                <option value="number">number</option>
                <option value="money">money</option>
                <option value="percent">percent</option>
                <option value="date">date</option>
                <option value="bool">bool</option>
              </select>
            </div>
            <div class="form-group col-md-3">
              <label>Formato</label>
              <input type="text" class="form-control" name="mac_formato" id="mac_formato" placeholder="ej: 0,0.00">
            </div>
            <div class="form-group col-md-3">
              <label>Color</label>
              <input type="text" class="form-control" name="mac_color" id="mac_color" placeholder="#RRGGBB">
            </div>
            <div class="form-group col-md-3">
              <label>Orden</label>
              <input type="number" class="form-control" name="mac_orden" id="mac_orden" min="0" step="1">
            </div>
          </div>

          <div class="form-row">
            <div class="form-group col-md-3">
              <label>Visible</label>
              <select class="form-control" name="mac_visible" id="mac_visible">
                <option value="1">Sí</option>
                <option value="0">No</option>
              </select>
            </div>
          </div>

          <!-- Bloque Origen: LECTURA -->
          <div id="blk-lectura" class="border rounded p-3 mb-2" style="display:none;">
            <label class="mb-2"><b>Lectura (fuente)</b></label>
            <p class="text-muted mb-1">Define la fuente: tabla/columna. Puedes pegar JSON simple:</p>
            <pre class="bg-light p-2 rounded mb-2" style="white-space:pre-wrap;">{"table":"tbl_producto","column":"pro_cost"}</pre>
            <textarea class="form-control" name="mac_source" id="mac_source" rows="3" placeholder='{"table":"tbl_producto","column":"pro_cost"}'></textarea>
            <small class="text-muted">Funciones especiales como “fallback” p.ej. <code>{"table":"tbl_hist_precios","column":"pp_anterior","fallback":"tbl_producto.pro_cost"}</code></small>
          </div>

          <!-- Bloque Origen: PARAM -->
          <div id="blk-param" class="border rounded p-3 mb-2" style="display:none;">
            <label class="mb-2"><b>Parametrizable</b></label>
            <input type="text" class="form-control" name="mac_valor_default" id="mac_valor_default" placeholder="Valor por defecto (texto o número)">
            <small class="text-muted">Se puede sobreescribir por producto/PDV al editar en la matriz.</small>
          </div>

          <!-- Bloque Origen: FORMULA -->
          <div id="blk-formula" class="border rounded p-3 mb-2" style="display:none;">
            <label class="mb-2"><b>Fórmula</b></label>
            <textarea class="form-control" name="mac_formula" id="mac_formula" rows="3" placeholder="(pp_actual - pp_anterior) / NULLIF(pp_anterior,0)"></textarea>
            <small class="text-muted d-block mb-2">Permitidos: + - * /, COALESCE, NULLIF, ABS. Variables = nombres de otros campos.</small>

            <label class="mt-2">Dependencias (nombres de campos usados):</label>
            <select class="form-control" name="mac_depends[]" id="mac_depends" multiple></select>

            <div class="mt-2 d-flex">
              <input type="number" class="form-control mr-2" id="test_pro_id" placeholder="pro_id de prueba">
              <input type="number" class="form-control mr-2" id="test_pdv_id" placeholder="pdv_id (opcional)">
              <button type="button" class="btn btn-outline-secondary" id="btn-probar">Probar</button>
            </div>
            <small id="test_result" class="d-block mt-2 text-info"></small>
          </div>

        </div><!-- modal-body -->

        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
window.addEventListener('load', function () {
  // seguridad: jQuery + DataTables listos
  if (!window.jQuery) { console.error('jQuery no cargó'); return; }
  if (!$.fn || !$.fn.DataTable) { console.error('DataTables no cargó'); return; }

  (function(){
    var matId = 1;
    var base = 'https://megaprofer.serviciosrapidito.com/precios2/index.php/matrices/' + matId + '/campos';

    var dt = $('#tbl-campos').DataTable({
      ajax: { url: base + '/list', dataSrc: 'data' },
      columns: [
        { data: 'mac_id' },
        { data: 'mac_nombre' },
        { data: 'mac_titulo' },
        { data: 'mac_origen' },
        { data: 'mac_tipo' },
        { data: 'mac_orden', defaultContent: '' },
        { data: 'mac_visible', render: v => (parseInt(v,10)===1 ? '<span class="badge bg-success">Sí</span>' : '<span class="badge bg-secondary">No</span>') },
        { data: null, orderable:false, render: row => `
          <button class="btn btn-xs btn-outline-primary btn-edit" data-id="${row.mac_id}">Editar</button>
          <button class="btn btn-xs btn-outline-danger btn-del" data-id="${row.mac_id}">Eliminar</button>`}
      ],
      pageLength: 25,
      order: [[5,'asc'], [0,'asc']],
      language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
    });

    function loadDepends() {
      $.get(base + '/list').done(function(r){
        var $dep = $('#mac_depends');
        $dep.empty();
        (r.data || []).forEach(function(c){
          $dep.append(`<option value="${c.mac_nombre}">${c.mac_nombre} — ${c.mac_titulo}</option>`);
        });
      });
    }
    function toggleOrigenBlocks() {
      var v = $('#mac_origen').val();
      $('#blk-lectura').toggle(v==='lectura');
      $('#blk-param').toggle(v==='param');
      $('#blk-formula').toggle(v==='formula');
    }
    $('#mac_origen').on('change', toggleOrigenBlocks);

    $('#btn-nuevo').on('click', function(){
      $('#frmCampo')[0].reset();
      $('#mac_id').val('');
      $('#mac_nombre').prop('disabled', false);
      toggleOrigenBlocks();
      loadDepends();
      $('#test_result').text('');
      $('#modalCampo').modal('show');
    });

    $('#tbl-campos').on('click', '.btn-edit', function(){
      var row = dt.row($(this).closest('tr')).data();
      if(!row) return;
      $('#frmCampo')[0].reset();
      $('#mac_id').val(row.mac_id);
      $('#mac_nombre').val(row.mac_nombre).prop('disabled', true);
      $('#mac_titulo').val(row.mac_titulo);
      $('#mac_origen').val(row.mac_origen || 'lectura');
      $('#mac_tipo').val(row.mac_tipo || 'text');
      $('#mac_formato').val(row.mac_formato || '');
      $('#mac_color').val(row.mac_color || '');
      $('#mac_orden').val(row.mac_orden || '');
      $('#mac_visible').val(row.mac_visible);
      $('#mac_source').val(row.mac_source ? (typeof row.mac_source === 'string' ? row.mac_source : JSON.stringify(row.mac_source)) : '');
      $('#mac_valor_default').val(row.mac_valor_default || '');
      $('#mac_formula').val(row.mac_formula || '');
      loadDepends();
      setTimeout(function(){
        var deps = Array.isArray(row.mac_depends) ? row.mac_depends : [];
        $('#mac_depends').val(deps);
      }, 200);
      toggleOrigenBlocks();
      $('#test_result').text('');
      $('#modalCampo').modal('show');
    });

    $('#tbl-campos').on('click', '.btn-del', function(){
      if(!confirm('¿Eliminar este campo?')) return;
      var id = $(this).data('id');
      $.post(base + '/delete', { mac_id:id })
        .done(() => dt.ajax.reload(null,false))
        .fail(x => alert(x.responseJSON?.msg || 'Error al eliminar'));
    });

    $('#frmCampo').on('submit', function(e){
      e.preventDefault();
      var id  = $('#mac_id').val();
      var url = id ? (base + '/update') : (base + '/save');
      $.post(url, $(this).serialize())
        .done(function(){
          $('#modalCampo').modal('hide');
          dt.ajax.reload(null,false);
        })
        .fail(function(x){
          alert(x.responseJSON?.msg || 'Error al guardar');
        });
    });

    $('#btn-probar').on('click', function(){
      var mac_id = $('#mac_id').val();
      if (!mac_id) { alert('Primero guarda el campo para poder probar.'); return; }
      var pro_id = parseInt($('#test_pro_id').val() || '0', 10);
      var pdv_id = parseInt($('#test_pdv_id').val() || '0', 10);
      if (!pro_id) { alert('Ingresa un pro_id de prueba'); return; }
      $.post('https://megaprofer.serviciosrapidito.com/precios2/index.php/matrices/'+matId+'/campos/test-value', { mac_id, pro_id, pdv_id })
        .done(function(r){
          $('#test_result').text('Resultado: ' + (r.value ?? 'NULL'));
        })
        .fail(function(x){
          $('#test_result').text('Error: ' + (x.responseJSON?.msg || 'falló la prueba'));
        });
    });

  })();
});
</script>
