<!-- NO usar extend/section aquí -->
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">Matrices de Precios</h2>
    <a class="btn btn-sm btn-primary" href="<?= site_url('matrices'); ?>">Recargar</a>
  </div>

  <div class="card">
    <div class="card-body">
      <table id="tbl-matrices" class="table table-sm table-striped table-bordered w-100">
        <thead>
          <tr>
            <th>ID</th>
            <th>Tipo</th>
            <th>Nombre</th>
            <th>Estado</th>
            <th>Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($matrices)): ?>
            <?php foreach ($matrices as $m): ?>
              <tr>
                <td><?= esc($m['mat_id']) ?></td>
                <td><span class="badge bg-secondary"><?= esc($m['mat_tipo']) ?></span></td>
                <td><?= esc($m['mat_nombre'] ?? '') ?></td>
                <td>
                  <?php if (($m['mat_estado'] ?? 1) == 1): ?>
                    <span class="badge bg-success">Activo</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Inactivo</span>
                  <?php endif; ?>
                </td>
                <td>
                  <a class="btn btn-sm btn-outline-primary"
                   href="<?= site_url('matrices/'.$m['mat_id'].'/campos'); ?>">
                  Configurar campos
                </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
  // No usa sections: el footer ya incluye jQuery + DataTables.
  $(function () {
    $('#tbl-matrices').DataTable({
      pageLength: 10,
      lengthMenu: [10,25,50,100],
      order: [[0, 'asc']],
      language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
    });
  });
</script>
