<?php
/**
 * @var array $mat
 * @var array $campos
 */
$matId   = (int)($mat['mat_id'] ?? 0);
$matTipo = esc($mat['mat_tipo'] ?? '');
$matNom  = esc($mat['mat_nombre'] ?? '');
$campos  = $campos ?? [];

// preparar columnas dinámicas para JS
$dynCols = array_values(array_filter(array_map(function($c){
    if ((int)($c['mcr_visible'] ?? 1) !== 1) return null;
    // detectar si tiene fuente
    $hasSource = !empty($c['cam_source']);
    return [
        'data'      => $c['cam_nombre'],
        'title'     => $c['mcr_titulo'] ?: ($c['cam_titulo'] ?: $c['cam_nombre']),
        'tipo'      => $c['cam_tipo'] ?? 'text',
        'origen'    => $c['cam_origen'] ?? 'lectura',
        'hasSource' => $hasSource
    ];
}, $campos)));
?>
<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">
      Matriz: <?= $matNom ?> <small class="text-muted">(<?= $matTipo ?>)</small>
    </h2>
    <div>
      <a class="btn btn-sm btn-outline-secondary" href="<?= site_url('matrices2'); ?>">Volver</a>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <table id="tbl-matriz" class="table table-sm table-striped table-bordered w-100">
        <thead>
          <tr>
            <th>Código</th>
            <th>Descripción</th>
            <th>Familia</th>
            <th>Categorización</th>
            <?php foreach ($campos as $c): ?>
              <?php if ((int)($c['mcr_visible'] ?? 1) === 1): ?>
                <th><?= esc($c['mcr_titulo'] ?: ($c['cam_titulo'] ?: $c['cam_nombre'])) ?></th>
              <?php endif; ?>
            <?php endforeach; ?>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
      <small class="text-muted">
        Usa el selector “Mostrar” para ver 25, 50, 100, 500, 1000 o <b>Todos</b>.
      </small>
    </div>
  </div>
</div>

<script>
(function(){
  var urlData = '<?= site_url("matrices2/{$mat['mat_id']}/data") ?>';
  var urlSave = '<?= site_url("matrices2/{$mat['mat_id']}/save-manual") ?>';
  var dynCols = <?= json_encode($dynCols ?? [], JSON_UNESCAPED_UNICODE) ?>;
  var csrfKey = '<?= csrf_token() ?>';
  var csrfVal = '<?= csrf_hash() ?>';

  function escHtml(s){return String(s??'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}

  // Espera hasta que DataTables esté cargado (lo cargas en el footer)
  function whenDTReady(cb){
    if (window.jQuery && jQuery.fn && jQuery.fn.DataTable) return cb();
    setTimeout(function(){ whenDTReady(cb); }, 80);
  }

  function initGrid(){
    // columnas base que YA tienes en el <thead>
    var cols = [
      { data: 'pro_codigo',         title: 'Código' },
      { data: 'pro_descripcion',    title: 'Descripción' },
      { data: 'pro_familia',        title: 'Familia' },
      { data: 'pro_categorizacion', title: 'Categorización' }
    ];

    function renderNum(d, type){
      if (type==='display' || type==='filter'){
        if (d===null || d==='' || typeof d==='undefined') return '';
        var n = Number(d); if (isNaN(n)) return '';
        return n.toFixed(4);
      }
      return d;
    }

    // agrega dinámicas; si son manuales (lectura sin source) pinta input
    (dynCols||[]).forEach(function(c){
      var isManual = (String(c.origen).toLowerCase()==='lectura') && !c.hasSource;
      var col = { data: c.data, title: c.title };
      if (isManual){
        col.render = function(d, type, row){
          if (type!=='display') return d;
          var v = escHtml(d ?? '');
          return '<input type="text" class="form-control form-control-sm cell-edit" '+
                 'data-name="'+escHtml(c.data)+'" '+
                 'data-proid="'+escHtml(row.pro_id||"")+'" '+
                 'value="'+v+'">';
        };
      } else if (['number','money','percent'].includes((c.tipo||'').toLowerCase())){
        col.render = renderNum;
        col.className = 'text-right';
      }
      cols.push(col);
    });

    var dt = jQuery('#tbl-matriz').DataTable({
      processing: true,
      serverSide: true,
      deferRender: true,
      pageLength: 100,
      lengthMenu: [[25,50,100,500,1000,-1],[25,50,100,500,1000,'Todos']],
      ajax: {
        url: urlData,
        type: 'POST',
        data: function (d) { if (csrfKey && csrfVal) d[csrfKey] = csrfVal; },
        error: function(xhr){ console.error('Ajax error', xhr.status, xhr.responseText); alert('No se pudo cargar la grilla ('+xhr.status+').'); }
      },
      order: [[0,'asc']],
      columns: cols,
      language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
    });

    // Guardar inline (PP Calculado / Obs) — se mantiene
    jQuery('#tbl-matriz').on('change blur', '.cell-edit', function(){
      var $i = jQuery(this);
      var payload = { pro_id: $i.data('proid')||0, name: $i.data('name')||'', value: $i.val() };
      if (!payload.pro_id || !payload.name) return;
      if (csrfKey && csrfVal) payload[csrfKey] = csrfVal;

      jQuery.post(urlSave, payload)
        .done(()=>{ $i.addClass('is-valid'); setTimeout(()=>{$i.removeClass('is-valid');},600); })
        .fail(x=>{ console.error('saveManual', x.responseText||x.statusText); $i.addClass('is-invalid'); setTimeout(()=>{$i.removeClass('is-invalid');},1200); alert('No se pudo guardar'); });
    });
  }

  // Arranca cuando DataTables esté disponible
  whenDTReady(initGrid);
})();
</script>
