<!-- VISTA: Importar Matriz de Parámetros por Producto -->
<style>
  .imp-ui{ --border:#e5e7eb; --mut:#6b7280; }
  .imp-ui .card{ border:1px solid var(--border); border-radius:12px; box-shadow:0 8px 18px rgba(0,0,0,.05); }
  .imp-ui .card-header{ background:linear-gradient(180deg,#fff,#fafbff); border-bottom:1px solid var(--border); border-top-left-radius:12px; border-top-right-radius:12px; padding:12px 16px; }
  .imp-ui .muted{ color:var(--mut); }
  .pill{ padding:.2rem .55rem; border-radius:999px; font-size:.75rem; border:1px solid #e2e8f0; background:#f8fafc; }
</style>

<div class="imp-ui">

  <?php if(session()->getFlashdata('ok')): ?>
    <div class="alert alert-success"><?= esc(session()->getFlashdata('ok')) ?></div>
  <?php endif; ?>
  <?php if(session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
  <?php endif; ?>

  <div class="card mb-3">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div>
        <h4 class="mb-0">Carga masiva por producto</h4>
        <div class="muted small">Sube un archivo <strong>Excel (.xlsx)</strong> con los parámetros por producto. Cálculo de márgenes: <span class="pill">margen × (1 − descuento)</span>.</div>
      </div>
      <a class="btn btn-outline-secondary" href="<?= base_url('productos/plantilla') ?>"><i class="fa fa-file-excel-o"></i> Descargar plantilla</a>
    </div>
    <div class="p-3">
      <form method="post" action="<?= base_url('productos/importar/preview') ?>" enctype="multipart/form-data" class="row g-2">
        <?= csrf_field() ?>
        <div class="col-md-8">
          <input class="form-control" type="file" name="archivo" accept=".xlsx" required>
        </div>
        <div class="col-md-4 d-grid">
          <button class="btn btn-primary" type="submit"><i class="fa fa-eye"></i> Previsualizar</button>
        </div>
      </form>
      <div class="small text-muted mt-2">
        Encabezados requeridos: <code>pro_codigo, ppr_margen_hoy, ppr_desc_normal, ppr_sentido_normal</code> (y opcionales el resto).
      </div>
    </div>
  </div>

  <?php if(isset($token)): ?>
  <div class="card">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="fw-bold">Previsualización</div>
      <div class="muted small">
        Total: <strong><?= (int)$total ?></strong> |
        Válidos: <strong class="text-success"><?= (int)$validos ?></strong> |
        Inválidos: <strong class="text-danger"><?= (int)$invalidos ?></strong>
      </div>
    </div>
    <div class="p-3">
      <div class="alert alert-info small">
        Se muestran hasta <strong>1000</strong> filas como referencia. Al aplicar, se procesarán <strong>todas</strong>.
      </div>

      <div class="table-responsive">
        <table id="tblPreview" class="table table-striped table-sm">
          <thead>
            <tr>
              <th>Código</th>
              <th>Margen Hoy</th>
              <th>% Normal</th>
              <th>% Límite</th>
              <th>% Admin</th>
              <th>% Mayorista</th>
              <th>% Especial</th>
              <th>Válido</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach(($previewRows ?? []) as $r): ?>
              <tr>
                <td><?= esc($r['pro_codigo']) ?></td>
                <td class="text-end"><?= esc($r['ppr_margen_hoy']) ?></td>
                <td class="text-end"><?= esc($r['p_normal']) ?></td>
                <td class="text-end"><?= esc($r['p_limite']) ?></td>
                <td class="text-end"><?= esc($r['p_admin']) ?></td>
                <td class="text-end"><?= esc($r['p_mayor']) ?></td>
                <td class="text-end"><?= esc($r['p_esp']) ?></td>
                <td><?= $r['valido']
                        ? '<span class="badge bg-success">Sí</span>'
                        : '<span class="badge bg-danger">No</span>' ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <form method="post" action="<?= base_url('productos/importar/aplicar') ?>" class="mt-3 d-flex justify-content-end gap-2">
        <?= csrf_field() ?>
        <input type="hidden" name="token" value="<?= esc($token) ?>">
        <a class="btn btn-outline-secondary" href="<?= base_url('productos/importar') ?>">Cancelar</a>
        <button class="btn btn-primary" type="submit"><i class="fa fa-check"></i> Aplicar cambios</button>
      </form>
    </div>
  </div>

  <script>
    $(function(){
      $('#tblPreview').DataTable({
        pageLength:25,
        language:{ url:'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
      });
    });
  </script>
  <?php endif; ?>

</div>
