<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Conveniomodel;
use App\Models\Puntoventamodel;
use App\Models\Convenioporcentajemodel;


class Convenios extends BaseController
{

	public function index(){
		$datos = $this->datosMenu();
		$convenio_model=new Conveniomodel();
		$datos_convenio=$convenio_model->getConvenio();

		$enviar_datos=array(
			'datos_convenio'=>$datos_convenio,
		);
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("convenios/list",$enviar_datos);
		echo view("layouts/footer");
	}

	

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('convenio')) && !empty($this->request->getPost('fechainicioconvenio')) && !empty($this->request->getPost('fechafinconvenio'))){

			$convenio_model=new Conveniomodel();

			$cov_nombre=$this->request->getPost('convenio');
			$cov_fecha=$this->request->getPost('fechainicioconvenio');
			$cov_fecha_hasta=$this->request->getPost('fechafinconvenio');
			$cov_porcentaje=$this->request->getPost('porcentajeganancia');
			

			$datos_convenio=array(

				'cov_nombre'=>$cov_nombre,
				'cov_fecha'=>$cov_fecha,
				'cov_fecha_hasta'=>$cov_fecha_hasta,
				'cov_porcentaje'=>$cov_porcentaje,
				'cov_estado'=>1,
			);

			$convenio_model->insertar($datos_convenio);
			
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function edit(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('covid')) && !empty($this->request->getPost('editconvenio')) && !empty($this->request->getPost('editfechainicioconvenio')) && !empty($this->request->getPost('editporcentajeganancia')) && !empty($this->request->getPost('editfechafinconvenio'))){

			$convenio_model=new Conveniomodel();

			$cov_id=$this->request->getPost('covid');
			$cov_nombre=$this->request->getPost('editconvenio');
			$cov_fecha=$this->request->getPost('editfechainicioconvenio');
			$cov_porcentaje=$this->request->getPost('editporcentajeganancia');
			$cov_fecha_hasta=$this->request->getPost('editfechafinconvenio');


			$datos_convenio=array(

				'cov_nombre'=>$cov_nombre,
				'cov_fecha'=>$cov_fecha,
				'cov_fecha_hasta'=>$cov_fecha_hasta,
				'cov_porcentaje'=>$cov_porcentaje,
				'cov_estado'=>1,
			);

			$convenio_model->actualizar($cov_id,$datos_convenio);
			$session->setFlashdata('mensaje_bueno', 'Convenio modificado satisfactoriamente');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function eliminar($cov_id){		
		$session = \Config\Services::session();		
		if(!empty($cov_id)){

			

			$convenio_model=new Conveniomodel();	

			$datos_convenio=array(
				'cov_estado'=>0,
			);
			$convenio_model->actualizar($cov_id,$datos_convenio);

			$session->setFlashdata('mensaje_bueno', 'Datos eliminados');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function eliminarconvenioporcentaje(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('covideliminar')) && !empty($this->request->getPost('fechaeliminar'))){

			$cov_id=$this->request->getPost('covideliminar');
			$fecha=$this->request->getPost('fechaeliminar');
			$fecha=date('Y-m-1',strtotime($fecha));
			

			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$convenio_porcentaje_model->eliminarseguncovidmes($cov_id,$fecha);

			

			$session->setFlashdata('mensaje_bueno', 'Datos eliminados');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function editvalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('auxporcentaje')) && !empty($this->request->getPost('copid')) ){

			$convenio_porcentaje_model=new Convenioporcentajemodel();

			$cov_porcentaje=$this->request->getPost('auxporcentaje');
			$cop_id=$this->request->getPost('copid');
			$cop_valor_vendido=$this->request->getPost('nuevovalor');

			$cop_porciento=0;

			if($cov_porcentaje!=0){
				$cop_porciento=$cop_valor_vendido*$cov_porcentaje/100;
			}

			$datos_convenio_porcentaje=array(
				'cop_porciento'=>$cop_porciento,
				'cop_valor_vendido'=>$cop_valor_vendido,
			);

			$convenio_porcentaje_model->actualizar($cop_id,$datos_convenio_porcentaje);
			$session->setFlashdata('mensaje_bueno', 'Dato editados');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}

	public function mostrardatosunconvenio(){
		if(!empty($this->request->getPost('covid')) && !empty($this->request->getPost('mes'))){
			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$cov_id=$this->request->getPost('covid');
			$cop_mes=$this->request->getPost('mes');
			$cop_mes=date('Y-m-1',strtotime($cop_mes));
			$resultado=[];
			$resultado= $convenio_porcentaje_model->getconvenioporcentajecovidmes($cov_id,$cop_mes);
			return json_encode($resultado);
		}else{
			return json_encode([]);
		}
	}

	public function leerconvenio(){
		$datos = $this->datosMenu();
		$convenio_model=new Conveniomodel();
		$datos_convenio=$convenio_model->getConvenio();

		$enviar_datos=array(
			'datos_convenio'=>$datos_convenio,
		);

		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("convenios/leerconvenio",$enviar_datos);
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		
		$mes='';
		if(empty($this->request->getPost('mes'))){
			$session->setFlashdata('mensaje_malo', 'Seleccion el mes');
			return redirect()->to(base_url('Convenios/leerconvenio'));
		}
		$mes=$this->request->getPost('mes');

		$mes=date('Y-m-d',strtotime($mes));

		$cov_nombre='';
		$cov_id=0;
		$cov_porcentaje=0;

		if(!empty($this->request->getPost('convid'))){
			$convenio=explode('/',$this->request->getPost('convid'));
			$cov_id=$convenio[0];
			$cov_nombre=$convenio[1];	
			$cov_porcentaje=$convenio[2];		
			$cov_porcentaje=$cov_porcentaje/100;	
		}


		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('CONVENIOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "CONVENIOS"');
				return redirect()->to(base_url('Convenios/leerconvenio'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{
					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();   
					$valor_vendido = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();					

					if(!is_numeric($valor_vendido)){
						$valor_vendido=0;
					}

					$valor_vendido=round($valor_vendido,2);
					

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($puv_id!=0){
						$convenio=$valor_vendido*$cov_porcentaje;
						$convenio=round($convenio, 2);
						$data[]=array(
							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'valor_vendido'=>$valor_vendido,
							'convenio2%'=>$convenio,							
						);
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
					}



				}
				break;

			}
			$datos = $this->datosMenu();
			$enviar_datos=array(            
				'data'=>$data,
				'mensaje'=>$pdv_no_encontrados,
				'cov_nombre'=>$cov_nombre,
				'cov_id'=>$cov_id,
				'mes'=>$mes,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("convenios/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Formatocarga')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos'))  && !empty($this->request->getPost('covid')) && !empty($this->request->getPost('mes'))){
			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$datos =$this->request->getPost('datos');			
			$cov_id =$this->request->getPost('covid');
			$cop_mes =$this->request->getPost('mes');            
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_convenio_porcentaje=array(
					'puv_id'=>$value['puv_id'],
					'cop_valor_vendido'=>$value['valor_vendido'],
					'cop_porciento'=>$value['convenio2%'],
					'cov_id'=>$cov_id,
					'cop_mes'=>$cop_mes,
					'cop_estado'=>1,

				);
				$convenio_porcentaje_model->insertar($datos_convenio_porcentaje);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios/leerconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios/leerconvenio')); 
		}

	}
	
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}