<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Destinoactivomodel;

class Destinoactivo extends BaseController
{

	public function index(){
		$destino_activo_model= new Destinoactivomodel();
		$datos_destino_activo=$destino_activo_model->getdestinoactivo();


		$enviar_datos=array(
			'datos_destino_activo' => !empty($datos_destino_activo)?$datos_destino_activo:null , 
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("destinoactivo/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$destino_activo_model= new Destinoactivomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('destino'))){
				$dea_destino=$this->request->getPost('destino');
				$ingresar_datos=array(
					'dea_destino'=>$dea_destino,
					'dea_estado'=>1
				);
				$destino_activo_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Destinoactivo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Destinoactivo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$destino_activo_model= new Destinoactivomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editdestino')) && !empty($this->request->getPost('editdeaid'))){
				$dea_destino=$this->request->getPost('editdestino');
				$dea_id=$this->request->getPost('editdeaid');
				$editar_datos=array(
					'dea_destino'=>$dea_destino,
					'dea_estado'=>1
				);
				$destino_activo_model->actualizar($dea_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Destinoactivo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Destinoactivo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$destino_activo_model= new Destinoactivomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'dea_estado'=>0
				);
				$destino_activo_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Destinoactivo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Destinoactivo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}