<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Formacobrofranquiciadomodel;

class Formacobrofranquiciado extends BaseController
{

	public function index(){
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		$datos_forma_cobro_franquiciado=$forma_cobro_franquiciado_model->getFormacobrofranquiciado();


		$enviar_datos=array(
			'datos_forma_cobro_franquiciado' => !empty($datos_forma_cobro_franquiciado)?$datos_forma_cobro_franquiciado:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("formacobrofranquiciado/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('formacobro'))){
				$fcf_formacobro=$this->request->getPost('formacobro');
				$ingresar_datos=array(
					'fcf_formacobro'=>$fcf_formacobro,
					'fcf_estado'=>1
				);
				$forma_cobro_franquiciado_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editformacobro')) && !empty($this->request->getPost('editfcfid'))){
				$fcf_formacobro=$this->request->getPost('editformacobro');
				$fcf_id=$this->request->getPost('editfcfid');
				$editar_datos=array(
					'fcf_formacobro'=>$fcf_formacobro,
					'fcf_estado'=>1
				);
				$forma_cobro_franquiciado_model->actualizar($fcf_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$forma_cobro_franquiciado_model= new Formacobrofranquiciadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'fcf_estado'=>0
				);
				$forma_cobro_franquiciado_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Formacobrofranquiciado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}