<?php

namespace App\Controllers;

include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Basecomisionesmodel;
class Formatocarga extends BaseController
{

    public function index(){    	
        $datos = $this->datosMenu();
        echo view("layouts/header");
        echo view("layouts/aside",$datos);
        echo view("formatocarga/formatocarga");
        echo view("layouts/footer");
    }
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }

    public function tabla()
    {
        $session = \Config\Services::session();
        $punto_venta_model =new Puntoventamodel();
        $nombre_archivo=null;
        $mes='';
        if(!empty($this->request->getPost('mes'))){
            $mes= $this->request->getPost('mes');
        }


        if(!empty($_FILES["archivoseleccionado"]["name"])){
            $nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
        }   
        if($nombre_archivo!=null ){            

            $path = $_FILES["archivoseleccionado"]["tmp_name"];
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            $reader->setReadDataOnly(true);
            $spreadsheet = $reader->load($path);
            $sheet = $spreadsheet->getSheetByName('BASE COMISIONES');            
            
            if(empty($sheet)){
                $session->setFlashdata('mensaje_malo', 'Archivo no Compatible hoja con el nombre: "BASE COMISIONES"');
                return redirect()->to(base_url('Formatocarga'));
            }

            $data=[];
            $pdv_no_encontrados='';

            foreach ($sheet->getRowIterator() as $row) {
                $cellIterator = $row->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false); 
                $highestRow = $sheet->getHighestDataRow();               
                
                $highestColumn = $sheet->getHighestDataColumn();            
                for($row=2; $row<=$highestRow; $row++)
                {
                    $pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();   
                    $ferreteria = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
                    $pesado = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();   
                    $ferreteria_adm = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
                    $ferreteria_mayorista = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
                    $pesado_adm = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
                    $pesado_mayorista = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
                    $venta_material_petreo = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
                    $ventas_especiales_sin_comision_ferreteria = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
                    $ventas_especiales_sin_comision_pesados = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
                    $facturacion_directa_de_cemento = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
                    $facturacion_transporte = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
                    $ventas_especiales_pesado = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
                    $ventas_especiales_ferreteria = $sheet->getCellByColumnAndRow(14, $row)->getCalculatedValue();
                    $devolucion_saldo_favor=$sheet->getCellByColumnAndRow(15, $row)->getCalculatedValue();

                    if(!is_numeric($ferreteria)){
                        $ferreteria=0;
                    }
                    if(!is_numeric($pesado)){
                        $pesado=0;
                    }
                    if(!is_numeric($ferreteria_adm)){
                        $ferreteria_adm=0;
                    }
                    if(!is_numeric($ferreteria_mayorista)){
                        $ferreteria_mayorista=0;
                    }
                    if(!is_numeric($pesado_adm)){
                        $pesado_adm=0;
                    }
                    if(!is_numeric($pesado_mayorista)){
                        $pesado_mayorista=0;
                    }
                    if(!is_numeric($venta_material_petreo)){
                        $venta_material_petreo=0;
                    }
                    if(!is_numeric($ventas_especiales_sin_comision_ferreteria)){
                        $ventas_especiales_sin_comision_ferreteria=0;
                    }
                    if(!is_numeric($ventas_especiales_sin_comision_pesados)){
                        $ventas_especiales_sin_comision_pesados=0;
                    }
                    if(!is_numeric($facturacion_directa_de_cemento)){
                        $facturacion_directa_de_cemento=0;
                    }
                    if(!is_numeric($facturacion_transporte)){
                        $facturacion_transporte=0;
                    }
                    if(!is_numeric($ventas_especiales_pesado)){
                        $ventas_especiales_pesado=0;
                    }
                    if(!is_numeric($ventas_especiales_ferreteria)){
                        $ventas_especiales_ferreteria=0;
                    }
                    if(!is_numeric($devolucion_saldo_favor)){
                        $devolucion_saldo_favor=0;
                    }

                    $puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
                    $puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;
                    if($puv_id!=0){
                        $data[]=array(
                            'puv_id'=>$puv_id,
                            'pdv'=>$pdv,
                            'ferreteria'=>$ferreteria,
                            'pesado'=>$pesado,
                            'ferreteria_adm'=>$ferreteria_adm,
                            'ferreteria_mayorista'=>$ferreteria_mayorista,
                            'pesado_adm'=>$pesado_adm,
                            'pesado_mayorista'=>$pesado_mayorista,
                            'venta_material_petreo'=>$venta_material_petreo,
                            'ventas_especiales_sin_comision_ferreteria'=>$ventas_especiales_sin_comision_ferreteria,
                            'ventas_especiales_sin_comision_pesados'=>$ventas_especiales_sin_comision_pesados,
                            'facturacion_directa_de_cemento'=>$facturacion_directa_de_cemento,
                            'facturacion_transporte'=>$facturacion_transporte,
                            'ventas_especiales_pesado'=>$ventas_especiales_pesado,
                            'ventas_especiales_ferreteria'=>$ventas_especiales_ferreteria,
                            'devolucion_saldo_favor'=>$devolucion_saldo_favor,
                        );

                    }else{
                        $pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
                    }
                }
                break;
                
            }
            $datos = $this->datosMenu();
            $enviar_datos=array(            
                'data'=>$data,
                'mensaje'=>$pdv_no_encontrados,
                'mes'=>$mes,
            );
            
            echo view("layouts/header");
            echo view("layouts/aside",$datos);
            echo view("formatocarga/tabla",$enviar_datos);
            echo view("layouts/footer");

            
        }else{
            $session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
            return redirect()->to(base_url('Formatocarga')); 
        }
        
    }

    public function finalizar (){
        $session = \Config\Services::session();

        if(!empty($this->request->getPost('datos')) && !empty($this->request->getPost('mes'))){
            $datos =$this->request->getPost('datos');
            $mes =$this->request->getPost('mes');   
            $mes=date("Y-m-d", strtotime($mes));


            $datos=base64_decode($datos);
            $datos=json_decode($datos,true);
            $base_comisiones_model=new Basecomisionesmodel();
            $resultado= $base_comisiones_model->getBasecomisionespormes($mes,2);
            if(!empty($resultado)){
                $session->setFlashdata('mensaje_malo', 'Ya existen datos del mes seleccionado');
                return redirect()->to(base_url('Formatocarga'));
            }
            foreach ($datos as $value) {    

                $datos_base_comisiones=array(
                    'puv_id'=>$value['puv_id'],
                    'bac_ferreteria'=>$value['ferreteria'],
                    'bac_pesado'=>$value['pesado'],
                    'bac_ferreteria_adm'=>$value['ferreteria_adm'],
                    'bac_ferreteria_mayorista'=>$value['ferreteria_mayorista'],
                    'bac_pesado_adm'=>$value['pesado_adm'],
                    'bac_pesado_mayorista'=>$value['pesado_mayorista'],
                    'bac_venta_material_petreo'=>$value['venta_material_petreo'],
                    'bac_ventas_especiales_sin_comision_ferreteria'=>$value['ventas_especiales_sin_comision_ferreteria'],
                    'bac_ventas_especiales_sin_comision_pesado'=>$value['ventas_especiales_sin_comision_pesados'],
                    'bac_facturacion_directa_de_cemento'=>$value['facturacion_directa_de_cemento'],
                    'bac_facturacion_transporte'=>$value['facturacion_transporte'],
                    'bac_venta_especial_pesado'=>$value['ventas_especiales_pesado'],
                    'bac_venta_especial_ferreteria'=>$value['ventas_especiales_ferreteria'],
                    'bac_devolucion_saldo_favor'=>$value['devolucion_saldo_favor'],
                    'bac_mes'=>$mes,
                    'bac_estado'=>1,
                );
                $base_comisiones_model->insertar($datos_base_comisiones);
            }
            $session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
            return redirect()->to(base_url('Formatocarga')); 
        }else{
            $session->setFlashdata('mensaje_malo', 'Dato no Ingresado');
            return redirect()->to(base_url('Formatocarga')); 
        }
        
    }

    public function fechasbasecomisiones(){
        $datos = $this->datosMenu();
        echo view("layouts/header");
        echo view("layouts/aside",$datos);
        echo view("formatocarga/fechasbasecomisiones");
        echo view("layouts/footer");
    }

    public function basecomisiones(){
        $datos = $this->datosMenu();
        $session = \Config\Services::session();
        if(empty($this->request->getPost('mes'))){
            $session->setFlashdata('mensaje_malo', 'Seleccione un mes');
            return redirect()->to(base_url('Formatocarga/fechasbasecomisiones')); 
        }

        $mes = $this->request->getPost('mes');
        $mes_aux=date('Y-m-d',strtotime($mes));
        $base_comisiones_model=new Basecomisionesmodel();

        $datos_base_comisiones=$base_comisiones_model->getBasecomisionespormes($mes_aux,2);

        
        if(empty($datos_base_comisiones)){
            $session->setFlashdata('mensaje_malo', 'No hay datos del mes seleccionado: '.$mes);
            return redirect()->to(base_url('Formatocarga/fechasbasecomisiones')); 
        }

        $enviar_datos=array(
            'datos_base_comisiones'=>!empty($datos_base_comisiones)?$datos_base_comisiones:[],
            'mes'=>$mes,
        );


        echo view("layouts/header");
        echo view("layouts/aside",$datos);
        echo view("formatocarga/reportebasecomisionesmensual",$enviar_datos);
        echo view("layouts/footer");
    }
    public function edit(){

        $bac_id=$this->request->getPost('bac_id');
        if(empty($bac_id)){
            return json_encode(false);
        }
        $bac_ferreteria=$this->request->getPost('bac_ferreteria');
        $bac_pesado=$this->request->getPost('bac_pesado');
        $bac_ferreteria_adm=$this->request->getPost('bac_ferreteria_adm');
        $bac_ferreteria_mayorista=$this->request->getPost('bac_ferreteria_mayorista');
        $bac_pesado_adm=$this->request->getPost('bac_pesado_adm');
        $bac_pesado_mayorista=$this->request->getPost('bac_pesado_mayorista');
        $bac_venta_material_petreo=$this->request->getPost('bac_venta_material_petreo');
        $bac_ventas_especiales_sin_comision_ferreteria=$this->request->getPost('bac_ventas_especiales_sin_comision_ferreteria');
        $bac_ventas_especiales_sin_comision_pesado=$this->request->getPost('bac_ventas_especiales_sin_comision_pesado');
        $bac_facturacion_directa_de_cemento=$this->request->getPost('bac_facturacion_directa_de_cemento');
        $bac_facturacion_transporte=$this->request->getPost('bac_facturacion_transporte');
        $bac_venta_especial_pesado=$this->request->getPost('bac_venta_especial_pesado');
        $bac_venta_especial_ferreteria=$this->request->getPost('bac_venta_especial_ferreteria');
        $bac_devolucion_saldo_favor=$this->request->getPost('bac_devolucion_saldo_favor');
        
        $datos_base_comisiones=array(
            'bac_ferreteria'=>$bac_ferreteria,
            'bac_pesado'=>$bac_pesado,
            'bac_ferreteria_adm'=>$bac_ferreteria_adm,
            'bac_ferreteria_mayorista'=>$bac_ferreteria_mayorista,
            'bac_pesado_adm'=>$bac_pesado_adm,
            'bac_pesado_mayorista'=>$bac_pesado_mayorista,
            'bac_venta_material_petreo'=>$bac_venta_material_petreo,
            'bac_ventas_especiales_sin_comision_ferreteria'=>$bac_ventas_especiales_sin_comision_ferreteria,
            'bac_ventas_especiales_sin_comision_pesado'=>$bac_ventas_especiales_sin_comision_pesado,
            'bac_facturacion_directa_de_cemento'=>$bac_facturacion_directa_de_cemento,
            'bac_facturacion_transporte'=>$bac_facturacion_transporte,
            'bac_venta_especial_pesado'=>$bac_venta_especial_pesado,
            'bac_venta_especial_ferreteria'=>$bac_venta_especial_ferreteria,
            'bac_devolucion_saldo_favor'=>$bac_devolucion_saldo_favor,
        );

        $base_comisiones_model=new Basecomisionesmodel();
        $base_comisiones_model->actualizar($bac_id,$datos_base_comisiones);

        return json_encode(true);

    }

    public function eliminar(){
        
        $session = \Config\Services::session();
        if(empty($this->request->getPost('messeleccionado'))){
            $session->setFlashdata('mensaje_malo', 'Seleccione un mes');
            return redirect()->to(base_url('Formatocarga/fechasbasecomisiones')); 
        }

        $mes = $this->request->getPost('messeleccionado');
        $mes_aux=date('Y-m-d',strtotime($mes));
        $base_comisiones_model=new Basecomisionesmodel();

        $base_comisiones_model->eliminar($mes_aux);

        $session->setFlashdata('mensaje_bueno', 'Eliminado');
        return redirect()->to(base_url('Formatocarga/fechasbasecomisiones')); 
        
    }



}