<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Postconveniomodel;
use App\Models\Puntoventamodel;
use App\Models\Postconveniovalormodel;


class Postconvenio extends BaseController
{

	public function index(){
		$datos = $this->datosMenu();
		$post_convenio_model=new Postconveniomodel();
		$datos_post_convenio=$post_convenio_model->getPostConvenio();

		$enviar_datos=array(
			'datos_post_convenio'=>$datos_post_convenio,
		);
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("postconvenio/list",$enviar_datos);
		echo view("layouts/footer");
	}

	

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('postconvenio')) && !empty($this->request->getPost('fechainiciopostconvenio')) && !empty($this->request->getPost('fechafinpostconvenio'))){

			$post_convenio_model=new Postconveniomodel();

			$poc_nombre=$this->request->getPost('postconvenio');
			$poc_fecha=$this->request->getPost('fechainiciopostconvenio');
			$poc_fecha_hasta=$this->request->getPost('fechafinpostconvenio');
			$datos_post_convenio=array(
				'poc_nombre'=>$poc_nombre,
				'poc_fecha'=>$poc_fecha,
				'poc_fecha_hasta'=>$poc_fecha_hasta,				
				'poc_estado'=>1,
			);

			$post_convenio_model->insertar($datos_post_convenio);
			
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Postconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Postconvenio')); 
		}
	}
	public function edit(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('pocid')) && !empty($this->request->getPost('editpostconvenio')) && !empty($this->request->getPost('mes')) && !empty($this->request->getPost('mesfin'))){

			$post_convenio_model=new Postconveniomodel();

			$poc_id=$this->request->getPost('pocid');
			$poc_nombre=$this->request->getPost('editpostconvenio');
			$poc_fecha=$this->request->getPost('mes');
			$poc_fecha_hasta=$this->request->getPost('mesfin');


			$datos_post_convenio=array(
			
				'poc_nombre'=>$poc_nombre,
				'poc_fecha'=>$poc_fecha,
				'poc_fecha_hasta'=>$poc_fecha_hasta,
				'poc_estado'=>1,
			);

			$post_convenio_model->actualizar($poc_id,$datos_post_convenio);
			$session->setFlashdata('mensaje_bueno', 'Dato Editado');
			return redirect()->to(base_url('Postconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Postconvenio')); 
		}
	}
	public function eliminar($poc_id){		
		$session = \Config\Services::session();		
		if(!empty($poc_id)){

			
			$post_convenio_model=new Postconveniomodel();		
			$datos_post_convenio=array(	
				'poc_estado'=>0,
			);

			$post_convenio_model->actualizar($poc_id,$datos_post_convenio);



			$session->setFlashdata('mensaje_bueno', 'Datos Eliminado');
			return redirect()->to(base_url('Postconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Postconvenio')); 
		}
	}
	public function eliminarpostconveniovalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('pocideliminar')) && !empty($this->request->getPost('pcvfechaeliminar'))){
			$poc_id=$this->request->getPost('pocideliminar');
			$fecha=$this->request->getPost('pcvfechaeliminar');

			$fecha=date('Y-m-1',strtotime($fecha));

			$post_convenio_valor_model=new Postconveniovalormodel();

			$post_convenio_valor_model->eliminarsegunpocidmes($poc_id,$fecha);



			$session->setFlashdata('mensaje_bueno', 'Datos Eliminado');
			return redirect()->to(base_url('Postconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Postconvenio')); 
		}
	}
	public function editvalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('pcvid'))){
			$post_convenio_valor_model=new Postconveniovalormodel();

			$pcv_id=$this->request->getPost('pcvid');
			$pcv_valor=$this->request->getPost('nuevovalor');

			$datos_post_convenio_valor=array(
				'pcv_valor'=>$pcv_valor,
			);

			$post_convenio_valor_model->actualizar($pcv_id,$datos_post_convenio_valor);
			$session->setFlashdata('mensaje_bueno', 'Dato editado');
			return redirect()->to(base_url('Postconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Postconvenio')); 
		}
	}

	public function mostrardatosunpostconvenio(){
		if(!empty($this->request->getPost('pocid')) && !empty($this->request->getPost('fecha'))){
			$post_convenio_valor_model=new Postconveniovalormodel();
			$poc_id=$this->request->getPost('pocid');
			$pcv_mes=$this->request->getPost('fecha');
			$pcv_mes=date('Y-m-1',strtotime($pcv_mes));
			$resultado=[];
			$resultado= $post_convenio_valor_model->getpostconvenioporvalorpocid($poc_id,$pcv_mes);
			return json_encode($resultado);
		}else{
			return json_encode([]);
		}
	}

	public function leerpostconvenio(){
		$datos = $this->datosMenu();
		$post_convenio_model=new Postconveniomodel();
		$datos_post_convenio=$post_convenio_model->getPostConvenio();

		$enviar_datos=array(
			'datos_post_convenio'=>$datos_post_convenio,
		);

		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("postconvenio/leerpostconvenio",$enviar_datos);
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		$mes='';
		if(empty($this->request->getPost('mes'))){
			
			$session->setFlashdata('mensaje_malo', 'Seleccione el mes');
			return redirect()->to(base_url('Postonvenio/leerpostconvenio'));
		}
		$mes=$this->request->getPost('mes');
		$mes=date('Y-m-d',strtotime($mes));
		$poc_nombre='';
		$poc_id=0;

		if(!empty($this->request->getPost('pcoid'))){
			$postconvenio=explode('/',$this->request->getPost('pcoid'));
			$poc_id=$postconvenio[0];
			$poc_nombre=$postconvenio[1];	
		}


		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('POSTCONVENIOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja debe tener el nombre "POSTCONVENIOS"');
				return redirect()->to(base_url('Postconvenio/leerpostconvenio'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{
					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();   
					$pcv_valor = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();					

					if(!is_numeric($pcv_valor)){
						$pcv_valor=0;
					}

					$pcv_valor=round($pcv_valor,2);
					

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($puv_id!=0){						
						$data[]=array(
							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'pcv_valor'=>$pcv_valor,						
						);
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
					}



				}
				break;

			}
			$datos = $this->datosMenu();
			$enviar_datos=array(            
				'data'=>$data,
				'mensaje'=>$pdv_no_encontrados,
				'poc_nombre'=>$poc_nombre,
				'poc_id'=>$poc_id,
				'mes'=>$mes,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("postconvenio/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Formatocarga')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos'))  && !empty($this->request->getPost('pocid')) && !empty($this->request->getPost('mes'))){
			$post_convenio_valor_model=new Postconveniovalormodel();
			$datos =$this->request->getPost('datos');			
			$poc_id =$this->request->getPost('pocid');   
			$pcv_mes =$this->request->getPost('mes');     
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);

			

			foreach ($datos as $value) {

				$datos_post_convenio=array(				
					'puv_id'=>$value['puv_id'],
					'pcv_valor'=>$value['pcv_valor'],
					'poc_id'=>$poc_id,
					'pcv_mes'=>$pcv_mes,
					'pcv_estado'=>1,

				);
				$post_convenio_valor_model->insertar($datos_post_convenio);

			}


			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Postconvenio/leerpostconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Postconvenio/leerpostconvenio')); 
		}

	}
	
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}