<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Prestamosmodel;
class Prestamos extends BaseController
{

	public function index(){
		$punto_venta_model= new Puntoventamodel();
		$prestamos_model= new  Prestamosmodel();
		$datos_punto_venta=$punto_venta_model->getPuntoventa();
		$datos_prestamos=$prestamos_model->getPrestamos();



		$enviar_datos=array(
			'datos_punto_venta' => !empty($datos_punto_venta)?$datos_punto_venta:null , 
			'datos_prestamos' => !empty($datos_prestamos)?$datos_prestamos:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("prestamos/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();



		if(!empty($this->request->getPost('prestamo')) && !empty($this->request->getPost('puvid')) && !empty($this->request->getPost('valor')) && !empty($this->request->getPost('fechadesde')) && !empty($this->request->getPost('fechahasta')) && !empty($this->request->getPost('auxcuotas')) && !empty($this->request->getPost('valorpagomensual')) ){
			$prestamos_model= new  Prestamosmodel();
			$pre_nombre=$this->request->getPost('prestamo');
			$puv_id=$this->request->getPost('puvid');
			$pre_valor=$this->request->getPost('valor');
			$pre_fecha_desde=$this->request->getPost('fechadesde');
			$pre_fecha_hasta=$this->request->getPost('fechahasta');
			$pre_cuotas=$this->request->getPost('auxcuotas');
			$pre_porcentaje=$this->request->getPost('porcentaje');
			$pre_pago_mensual=$this->request->getPost('valorpagomensual');

			$pre_estado=1;

			$pre_tipo=$this->request->getPost('opcionestipo');

			$datos_prestamo=array(

				'pre_nombre'=>$pre_nombre,
				'puv_id'=>$puv_id,
				'pre_valor'=>$pre_valor,
				'pre_fecha_desde'=>$pre_fecha_desde,
				'pre_fecha_hasta'=>$pre_fecha_hasta,
				'pre_cuotas'=>$pre_cuotas,
				'pre_porcentaje'=>$pre_porcentaje,
				'pre_estado'=>1,
				'pre_tipo'=>$pre_tipo,
				'pre_pago_mensual'=>$pre_pago_mensual,
			);
			$prestamos_model->insertar($datos_prestamo);
			$session->setFlashdata('mensaje_bueno', 'Datos Ingresados');
			return redirect()->to(base_url('Prestamos')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Prestamos')); 
		}
		


	}
	
	public function edit(){
		$session = \Config\Services::session();



		if( !empty($this->request->getPost('editpreid')) && !empty($this->request->getPost('editprestamo')) && !empty($this->request->getPost('editpuvid')) && !empty($this->request->getPost('editvalor'))  && !empty($this->request->getPost('editpagomensual')) && !empty($this->request->getPost('editfechadesde')) && !empty($this->request->getPost('editfechahasta')) && !empty($this->request->getPost('tipo')) ){
			$prestamos_model= new  Prestamosmodel();
			$pre_id=$this->request->getPost('editpreid');
			$pre_nombre=$this->request->getPost('editprestamo');
			$puv_id=$this->request->getPost('editpuvid');
			$pre_pago_mensual=$this->request->getPost('editpagomensual');
			$pre_porcentaje=$this->request->getPost('porcentaje');
			$pre_fecha_desde=$this->request->getPost('editfechadesde');
			$pre_fecha_hasta=$this->request->getPost('editfechahasta');
			$pre_tipo=$this->request->getPost('tipo');
			$pre_valor=$this->request->getPost('editvalor');


			if($pre_tipo=='Con Intereses'){
				if(empty($this->request->getPost('editporcentaje'))){
					$session->setFlashdata('mensaje_malo', 'Ingrese porcentaje');
					return redirect()->to(base_url('Prestamos')); 
				}
				$pre_porcentaje=$this->request->getPost('editporcentaje');
			}else{
				$pre_porcentaje=0;
			}
			$pre_cuotas=$this->obtenercuotas($pre_fecha_desde,$pre_fecha_hasta);
			$datos_prestamo=array(

				'pre_nombre'=>$pre_nombre,
				'puv_id'=>$puv_id,
				'pre_valor'=>$pre_valor,
				'pre_fecha_desde'=>$pre_fecha_desde,
				'pre_fecha_hasta'=>$pre_fecha_hasta,
				'pre_cuotas'=>$pre_cuotas,
				'pre_porcentaje'=>$pre_porcentaje,
				'pre_pago_mensual'=>$pre_pago_mensual,
				'pre_estado'=>1,
				'pre_tipo'=>$pre_tipo,
			);
			$prestamos_model->actualizar($pre_id,$datos_prestamo);
			$session->setFlashdata('mensaje_bueno', 'Datos Editado');
			return redirect()->to(base_url('Prestamos')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}
		


	}
	public function eliminar($pre_id){
		$session = \Config\Services::session();
		if( !empty($pre_id)){
			$prestamos_model= new  Prestamosmodel();
			$prestamos_model->eliminar($pre_id);
			$session->setFlashdata('mensaje_bueno', 'Datos Elimiando');
			return redirect()->to(base_url('Prestamos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}	
	}

	public function leerprestamo(){
		$datos = $this->datosMenu();		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("prestamos/leerprestamo");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		

		
		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('PRESTAMOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "PRESTAMOS"');
				return redirect()->to(base_url('Prestamos/leerprestamo'));
			}    

			$data=[];

			$pdv_no_encontrados='';
			
			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{

					
					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
					$pre_nombre = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();

					$pre_valor= $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
					if(!is_numeric($pre_valor)){
						$pre_valor=0;
					}

					$pre_fecha_desde= $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
					if(!empty($pre_fecha_desde)){
						$pre_fecha_desde = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($pre_fecha_desde);           
						$pre_fecha_desde =$pre_fecha_desde->format('Y-m-d');
					}


					$pre_fecha_hasta= $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
					if(!empty($pre_fecha_hasta)){
						$pre_fecha_hasta = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($pre_fecha_hasta);           
						$pre_fecha_hasta =$pre_fecha_hasta->format('Y-m-d');
					}


					$pre_tipo = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();



					$pre_pago_mensual = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
					if(!is_numeric($pre_pago_mensual)){
						$pre_pago_mensual=0;
					}

					if($pre_tipo=='Con Intereses'||$pre_tipo=='Sin Intereses'){
						if($pre_tipo=='Con intereses'){
							$pre_porcentaje = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
							if(!is_numeric($pre_porcentaje)){
								$pre_porcentaje=0;
							}
						}else{
							$pre_porcentaje=0;
						}
					}else{
						$pre_tipo='';
					}
					$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($pre_nombre!=''  && $pre_fecha_desde!='' && $pre_fecha_hasta!=''  && $pre_fecha_desde<=$pre_fecha_hasta && $pre_tipo!='' && $puv_id!=0){
						$pre_cuotas=$this->obtenercuotas($pre_fecha_desde,$pre_fecha_hasta);
						$data[]=array(
							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'pre_nombre'=>$pre_nombre,
							'pre_valor'=>$pre_valor,
							'pre_fecha_desde'=>$pre_fecha_desde,
							'pre_fecha_hasta'=>$pre_fecha_hasta,
							'pre_cuotas'=>$pre_cuotas,
							'pre_porcentaje'=>$pre_porcentaje,
							'pre_tipo'=>$pre_tipo,
							'pre_pago_mensual'=>$pre_pago_mensual,
						);
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados." ".$row.",";
					}

				}
				break;

			}
			$datos = $this->datosMenu();
			
			$enviar_datos=array(        
				'mensaje'=>$pdv_no_encontrados,
				'data'=>$data,
			);

			

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("prestamos/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos')) ){
			$prestamos_model= new  Prestamosmodel();
			$datos =$this->request->getPost('datos');		
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_prestamo=array(

					'pre_nombre'=>$value['pre_nombre'],
					'puv_id'=>$value['puv_id'],
					'pre_valor'=>$value['pre_valor'],
					'pre_fecha_desde'=>$value['pre_fecha_desde'],
					'pre_fecha_hasta'=>$value['pre_fecha_hasta'],
					'pre_cuotas'=>$value['pre_cuotas'],
					'pre_porcentaje'=>$value['pre_porcentaje'],
					'pre_tipo'=>$value['pre_tipo'],
					'pre_pago_mensual'=>$value['pre_pago_mensual'],
					'pre_estado'=>1,

				);				
				$prestamos_model->insertar($datos_prestamo);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}

	}
	

	public function obtenercuotas($desde,$hasta)
	{
		$desde=date('Y-m',strtotime($desde));
		$hasta=date('Y-m',strtotime($hasta));
		$cuotas=0;

		while($desde<$hasta){
			
			$desde=date("Y-m",strtotime($desde."+ 1 month")); 
			$cuotas=$cuotas+1;
		}

		return $cuotas;
	}
	public function sumarmesesaunafecha()
	{		
		$fecha=$this->request->getPost('fecha');
		$mesessumar=$this->request->getPost('numero');
		$dia=date("d",strtotime($fecha));
		if($dia>=29){
			$fecha=date("Y-m-28",strtotime($fecha));
		}

		$inicio=1;
		while($inicio<=$mesessumar){
			
			$fecha=date("Y-m-d",strtotime($fecha."+ 1 month")); 
			$inicio=$inicio+1;
		}
		return json_encode($fecha);
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}