<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tipofranquiciamodel;

class Tipofranquicia extends BaseController
{

	public function index(){
		$tipo_franquicia_model= new Tipofranquiciamodel();
		$datos_tipo_franquicia=$tipo_franquicia_model->getTipofranquicia();


		$enviar_datos=array(
			'datos_tipo_franquicia' => !empty($datos_tipo_franquicia)?$datos_tipo_franquicia:null , 
		);

        $datos = $this->datosMenu();
        
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("tipofranquicia/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_franquicia_model= new Tipofranquiciamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tipo'))){
				$tif_tipo=$this->request->getPost('tipo');
				$ingresar_datos=array(
					'tif_tipo'=>$tif_tipo,
					'tif_estado'=>1
				);
				$tipo_franquicia_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tipofranquicia')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquicia')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_franquicia_model= new Tipofranquiciamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittipo')) && !empty($this->request->getPost('edittif'))){
				$tif_tipo=$this->request->getPost('edittipo');
				$tif_id=$this->request->getPost('edittif');
				$editar_datos=array(
					'tif_tipo'=>$tif_tipo,
					'tif_estado'=>1
				);
				$tipo_franquicia_model->actualizar($tif_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tipofranquicia')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquicia')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_franquicia_model= new Tipofranquiciamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tif_estado'=>0
				);
				$tipo_franquicia_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Tipofranquicia')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquicia')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}