<?php

namespace App\Controllers;

use App\Models\UsuarioModel;
use App\Models\Cargomodel;
use App\Models\Canalmodel;
use App\Models\Rolmodel;
use App\Models\Datospersonalesmodel;
use App\Models\Areamodel;
class Usuario extends BaseController
{

	public function index(){	
		echo view("Login/login");
	}
	public function list(){
		$usuario_model=new UsuarioModel();
		
		$cargo_model=new Cargomodel();
		$canal_model=new Canalmodel();
		$rol_model=new Rolmodel();
		$area_model=new Areamodel();

		$datos_usuario_plan=$usuario_model->getUsuarioPlan();
		$datos_cargo=$cargo_model->getCargo();
		$datos_canal=$canal_model->getCanal();
		$datos_rol=$rol_model->getRol();
		$datos_area=$area_model->getArea();

		$enviar_datos=array(
			'datos_usuario_plan' => !empty($datos_usuario_plan)?$datos_usuario_plan:[] , 
			'datos_cargo' => !empty($datos_cargo)?$datos_cargo:[] , 
			'datos_canal' => !empty($datos_canal)?$datos_canal:[] ,
			'datos_rol' => !empty($datos_rol)?$datos_rol:[] , 
			'datos_area' => !empty($datos_area)?$datos_area:[] , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("usuarioplan/list",$enviar_datos);
		echo view("layouts/footer");
	}
	public function add(){
		$session = \Config\Services::session();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('nombres')) && !empty($this->request->getPost('correo')) && !empty($this->request->getPost('carid')) && !empty($this->request->getPost('canid')) && !empty($this->request->getPost('rolid')) && !empty($this->request->getPost('clave'))){

				$datos_personales_model=new Datospersonalesmodel();
				$usuario_model=new UsuarioModel();

				$DAP_NOMBRES=$this->request->getPost('nombres');

				$ingresar_datos_personales=array(
					'DAP_NOMBRES'=>$DAP_NOMBRES,
					'DAP_ESTADO'=>1,
				);
				$datos_personales_model->insertar($ingresar_datos_personales);

				$DAP_ID=$datos_personales_model->getMaxDAPID();
				$DAP_ID=$DAP_ID[0]['DAP_ID'];

				$USU_CORREO=$this->request->getPost('correo');
				$CAR_ID=$this->request->getPost('carid');
				$CAN_ID=$this->request->getPost('canid');
				$ROL_ID=$this->request->getPost('rolid');
				$USU_CLAVE=$this->request->getPost('clave');
                $are_id=$this->request->getPost('areid');
				$ingresar_datos=array(
					'DAP_ID'=>$DAP_ID,
					'USU_CORREO'=>$USU_CORREO,
					'CAR_ID'=>$CAR_ID,
					'CAN_ID'=>$CAN_ID,
					'ROL_ID'=>$ROL_ID,
					'USU_CLAVE'=>$USU_CLAVE,
					'USU_ESTADO'=>1,
					'sis_id'=>1,
					'are_id'=>$are_id,
				);
				$usuario_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Usuario/list')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Usuario/list')); 
			} 
		}else{
			return redirect()->to(base_url()); 
		}


	}
	public function edit(){
		$session = \Config\Services::session();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editdapid')) && !empty($this->request->getPost('editusuid')) && !empty($this->request->getPost('editnombres')) && !empty($this->request->getPost('editcorreo')) && !empty($this->request->getPost('editcarid')) && !empty($this->request->getPost('editcanid')) && !empty($this->request->getPost('editrolid')) ){

				$datos_personales_model=new Datospersonalesmodel();
				$usuario_model=new UsuarioModel();

				$DAP_ID=$this->request->getPost('editdapid');
				$DAP_NOMBRES=$this->request->getPost('editnombres');

				$actualizar_datos_personales=array(
					'DAP_NOMBRES'=>$DAP_NOMBRES,
					'DAP_ESTADO'=>1,
				);
				$datos_personales_model->actualizar($DAP_ID,$actualizar_datos_personales);

				$USU_ID=$this->request->getPost('editusuid');
				$USU_CORREO=$this->request->getPost('editcorreo');
				$CAR_ID=$this->request->getPost('editcarid');
				$CAN_ID=$this->request->getPost('editcanid');
				$ROL_ID=$this->request->getPost('editrolid');
				$USU_CLAVE=$this->request->getPost('editclave');
				$are_id=$this->request->getPost('editareid');
				if(!empty($USU_CLAVE)){
					$actualizar_datos=array(
						'USU_CORREO'=>$USU_CORREO,
						'CAR_ID'=>$CAR_ID,
						'CAN_ID'=>$CAN_ID,
						'ROL_ID'=>$ROL_ID,
						'USU_CLAVE'=>$USU_CLAVE,
						'are_id'=>$are_id,
						'USU_ESTADO'=>1
					);
				}else{
					$actualizar_datos=array(
						'USU_CORREO'=>$USU_CORREO,
						'CAR_ID'=>$CAR_ID,
						'CAN_ID'=>$CAN_ID,
						'ROL_ID'=>$ROL_ID,
						'are_id'=>$are_id,
						'USU_ESTADO'=>1
					);

				}
				
				$usuario_model->actualizar($USU_ID,$actualizar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Actualizado');
				return redirect()->to(base_url('Usuario/list')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Usuario/list')); 
			} 
		}else{
			return redirect()->to(base_url()); 
		}


	}
	public function eliminar($USU_ID){
		$session = \Config\Services::session();
		if($session->get('USU_CORREO')!=null){
			if(!empty($USU_ID)){			
				$usuario_model=new UsuarioModel();
				$actualizar_datos=array(
					'USU_ESTADO'=>0,
				);				
				
				$usuario_model->actualizar($USU_ID,$actualizar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Usuario/list')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Usuario/list')); 
			} 
		}else{
			return redirect()->to(base_url()); 
		}


	}
	
	public function cambiarclave(){
		$session = \Config\Services::session();
		if($session->get('USU_CORREO')!=null && $session->get('USU_ID')!=null){
			if(!empty($this->request->getPost('clave'))){	
				$USU_CLAVE=	$this->request->getPost('clave');
				$usuario_model=new UsuarioModel();
				$actualizar_datos=array(
					'USU_CLAVE'=>$USU_CLAVE,
				);	
				$usuario_model->actualizar($session->get('USU_ID'),$actualizar_datos);
				$session->setFlashdata('mensaje_bueno', 'Clave cambiada');
				return redirect()->to(base_url('Auth/logout')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Clave no ingresada');
				return redirect()->to(base_url('Auth/logout'));
			} 
		}else{
			return redirect()->to(base_url()); 
		}
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}