<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Areamodel extends Model
{
    public function getArea()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area');
        $builder->select('tbl_area.*');    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getAreaPresupuesto($are_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area_presupuesto');
        $builder->select('tbl_area_presupuesto.*'); 
        $builder->join('tbl_area','tbl_area_presupuesto.are_id=tbl_area.are_id'); 
        $builder->where('tbl_area_presupuesto.are_id',$are_id); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getAreaPresupuestoYear($are_id,$arp_year)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area_presupuesto');
        $builder->select('tbl_area_presupuesto.*'); 
        $builder->where('tbl_area_presupuesto.are_id',$are_id);
        $builder->where('tbl_area_presupuesto.arp_year',$arp_year);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getPresupuestoAreaYearActual($are_id)
    {
        $db      = \Config\Database::connect();
        $year=date("Y"); 
        $builder = $db->table('tbl_area_presupuesto');
        $builder->select('tbl_area_presupuesto.*'); 
        $builder->where('tbl_area_presupuesto.are_id',$are_id);
        $builder->where('tbl_area_presupuesto.arp_year',$year);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getPresupuestoAreaUsadoYearActual($are_id)
    {
        $db      = \Config\Database::connect();
        $year=date("Y"); 
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.plm_areadestino, sum(m.material) as mat, sum(a.auspicio) as aup, round((sum(m.material)-sum(a.auspicio)-(sum(m.material)*sum(a.auspiciop)/100)),2) as diferencia'); 
        $builder->join('(select tbl_plan_mercadeo_material.plm_id as plmid,sum(tbl_plan_mercadeo_material.pma_total) as material from tbl_plan_mercadeo_material group by tbl_plan_mercadeo_material.plm_id) as m','m.plmid=tbl_plan_mercadeo.plm_id','left');
        $builder->join('(select tbl_auspiciante_plan_mercadeo.plm_id as plmid,sum(tbl_auspiciante_plan_mercadeo.aup_valor) as auspicio , sum(tbl_auspiciante_plan_mercadeo.aup_porcentaje) as auspiciop from tbl_auspiciante_plan_mercadeo where pro_id!=382 group by tbl_auspiciante_plan_mercadeo.plm_id) as a','a.plmid=tbl_plan_mercadeo.plm_id','left');
        $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)',$year);
        $builder->where('tbl_plan_mercadeo.plm_areadestino',$are_id);
        $builder->groupBy('tbl_plan_mercadeo.plm_areadestino');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area');
        $builder->set($data);
		$builder->insert();

    }
    public function insertarAreaPresupuesto($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area_presupuesto');
        $builder->set($data);
		$builder->insert();

    }
    public function actualizar($are_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area');
        $builder->where('tbl_area.are_id', $are_id);
		return $builder->update($data);        
    }
    
    public function actualizarAreaPresupuesto($arp_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area_presupuesto');
        $builder->where('tbl_area_presupuesto.arp_id', $arp_id);
		return $builder->update($data);        
    }
    public function eliminar($are_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_area');
        $builder->where('tbl_area.are_id', $are_id);   
		$builder->update($data);        
    }

}