<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class PlanComercialmodel extends Model
{
    public function getPlan($plc_nombreplan,$fechadesde,$fechahasta ,$can_id,$plc_totalgastomateriales,$esp_id,$are_id)
    {
        $db      = \Config\Database::connect();
        $year = 2022;//date("Y"); 
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        
        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_codigo',$plc_nombreplan);    
            $builder->orlike('tbl_plan_comercial.plc_nombreplan', $plc_nombreplan);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_comercial.plc_fechacreacion >=',$fechadesde);
            $builder->where('tbl_plan_comercial.plc_fechacreacion <=',$fechahasta);
        }
        else{
            $builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)>=',$year);
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_comercial.plc_areadestino',$are_id);    
        }
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_comercial.can_id',$can_id);    
            $builder->orwhere('tbl_plan_comercial.can_id','1');
        }*/
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_comercial.esp_id',$esp_id);    
        }
        
        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        
        if(!empty($coordinador)){
           $builder->groupBy('tbl_plan_comercial.plc_id');
        }
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function getPlanAreaSolicitante($plc_nombreplan,$fechadesde,$fechahasta ,$can_id,$plc_totalgastomateriales,$esp_id,$are_id,$coordinador,$usu_id)
    {
        $db      = \Config\Database::connect();
        $year = date("Y"); 
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($coordinador)){
            $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plc_id=tbl_plan_comercial.plc_id');
            $builder->join('tbl_proveedor', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_proveedor.pro_id');
            $builder->where('tbl_proveedor.pro_coordinador',$coordinador);    
        }
        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_nombreplan',$plc_nombreplan);    
            $builder->orlike('tbl_plan_comercial.plc_codigo', $plc_nombreplan);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_comercial.plc_fechacreacion >=',$fechadesde);
            $builder->where('tbl_plan_comercial.plc_fechacreacion <=',$fechahasta);
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_comercial.plc_areadestino',$are_id);    
        }
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_comercial.can_id',$can_id);    
            $builder->orwhere('tbl_plan_comercial.can_id','1');
        }*/
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_comercial.esp_id',$esp_id);    
        }
        
        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        //$builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)',$year);
        $builder->where('tbl_plan_comercial.usu_id',$usu_id);
        if(!empty($coordinador)){
           $builder->groupBy('tbl_plan_comercial.plc_id');
        }
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getCodigoPlanId($plc_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*');   
        $builder->where('tbl_plan_comercial.plc_id',$plc_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    
    public function getPlanNegociador($plc_nombreplan,$plc_fechacreacion,$can_id,$plc_totalgastomateriales,$esp_id,$are_id,$usu_id)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plc_id=tbl_plan_comercial.plc_id');
        $builder->join('tbl_usuario_proveedor', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_usuario_proveedor.pro_id');   

        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_nombreplan',$plc_nombreplan);    
        }
        if(!empty($plc_fechacreacion)){
            $builder->where('tbl_plan_comercial.plc_fechacreacion',$plc_fechacreacion);    
        }
        
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_comercial.can_id',$can_id);    
            $builder->orwhere('tbl_plan_comercial.can_id','1');
        }*/
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_comercial.esp_id',$esp_id);    
        }

        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->where('tbl_usuario_proveedor.usu_id',$usu_id);
        $builder->where('tbl_plan_comercial.esp_id',6);
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        //$builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function getPlanAuspicios($plc_nombreplan,$fechadesde,$fechahasta ,$plc_totalgastomateriales,$esp_id,$coordinador)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('*');     
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');
        $builder->join('tbl_auspiciante_plan_comercial', 'tbl_plan_comercial.plc_id=tbl_auspiciante_plan_comercial.plc_id','left');
        $builder->join('tbl_proveedor', 'tbl_proveedor.pro_id=tbl_auspiciante_plan_comercial.pro_id','left');
        $builder->join('tbl_usuario', 'tbl_proveedor.pro_coordinador=tbl_usuario.usu_id','left');
        $builder->join('tbl_datos_personales', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID','left');
        
        $builder->join('(select aup_id, sum(`par_valor`) a , GROUP_CONCAT(`par_numero_documento`) b from tbl_plan_comercial_auspiciante_real group by 1) as pago_real','pago_real.aup_id=tbl_auspiciante_plan_comercial.aup_id','left');
        //$builder->where('tbl_plan_comercial.esp_id = 6'); 
        
        if(!empty($coordinador)){
            $builder->where('tbl_proveedor.pro_coordinador',$coordinador);    
        }
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_comercial.esp_id',$esp_id);    
        }
        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_nombreplan',$plc_nombreplan);    
            $builder->orlike('tbl_plan_comercial.plc_codigo', $plc_nombreplan);
        }
        if(empty($fechadesde) && empty($fechahasta) && empty($plc_nombreplan)){
            //$builder->where('YEAR(tbl_plan_comercial.plc_fechainicioplan)',$year);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_comercial.plc_fechainicioplan>=',$fechadesde);    
        }
        if(!empty($fechahasta)){
            $builder->where('tbl_plan_comercial.plc_fechainicioplan<=',$fechahasta);    
        }
        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlanaprobador($plc_nombreplan,$plc_fechacreacion,$plc_totalgastomateriales, $are_id)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   

        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_codigo',$plc_nombreplan);    
            $builder->orlike('tbl_plan_comercial.plc_nombreplan', $plc_nombreplan);
        }
        if(!empty($plc_fechacreacion)){
            $builder->where('tbl_plan_comercial.plc_fechacreacion',$plc_fechacreacion);    
        }
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_comercial.plc_areadestino',$are_id);    
        }
        $builder->where('(tbl_plan_comercial.esp_id != 10');
        //$builder->where('(tbl_plan_comercial.esp_id = 1 OR tbl_plan_comercial.esp_id = 12 OR tbl_plan_comercial.esp_id = 3 OR tbl_plan_comercial.esp_id = 2 OR tbl_plan_comercial.esp_id = 4 OR tbl_plan_comercial.esp_id = 5)'); 
        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        //$builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPlanautorizador($plc_nombreplan,$plc_fechacreacion,$plc_totalgastomateriales)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   

        if(!empty($plc_nombreplan)){
            $builder->like('tbl_plan_comercial.plc_codigo',$plc_nombreplan);    
            $builder->orlike('tbl_plan_comercial.plc_nombreplan', $plc_nombreplan);
        }
        if(!empty($plc_fechacreacion)){
            $builder->where('tbl_plan_comercial.plc_fechacreacion',$plc_fechacreacion);    
        }
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        
        $builder->where('(tbl_plan_comercial.esp_id = 4 OR tbl_plan_comercial.esp_id = 6 OR tbl_plan_comercial.esp_id = 7 OR tbl_plan_comercial.esp_id = 8)'); 
        //$builder->where('tbl_plan_comercial.plc_padre',0);
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        //$builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlancontabilidad($plc_totalgastomateriales)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($plc_totalgastomateriales)){
            $builder->where('tbl_plan_comercial.plc_totalgastomateriales',$plc_totalgastomateriales);    
        }
        //$builder->where('tbl_plan_comercial.plc_padre',0); 
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        //$builder->where('YEAR(tbl_plan_comercial.plc_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getPlanID($plc_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID' );   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_cargo', 'tbl_cargo.car_id=tbl_usuario.CAR_ID');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id =tbl_plan_mercadeo_estado.esp_id ');
        $builder->join('tbl_canal_venta', 'tbl_canal_venta.cav_id =tbl_plan_comercial.cav_id ');
        
        $builder->where('tbl_plan_comercial.plc_id',$plc_id);  
        $builder->orderBy('tbl_plan_comercial.plc_codigo','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    
    public function getPlanPadres()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_plan_mercadeo_estado.*');     
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');
        //$builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_plan_comercial.plc_id=tbl_auspiciante_plan_mercadeo.plc_id');
        //$builder->join('tbl_proveedor', 'tbl_proveedor.pro_id=tbl_auspiciante_plan_mercadeo.pro_id');
        //$builder->where('tbl_plan_comercial.plc_padre',0);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    
    public function getPlanMaterialesRealesSuma($plc_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->selectSum('tbl_plan_comercial_material_real.pmr_subtotal');     
        $builder->join('tbl_plan_comercial_material', 'tbl_plan_comercial.plc_id=tbl_plan_comercial_material.plc_id');
        $builder->join('tbl_plan_comercial_material_real', 'tbl_plan_comercial_material_real.pma_id=tbl_plan_comercial_material.pma_id');
        //$builder->where('tbl_plan_comercial.esp_id = 6'); 
        $builder->where('tbl_plan_comercial.plc_id', $plc_id); 
        $builder->orWhere('tbl_plan_comercial.plc_padre', $plc_id); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPlanArchivo($usu_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*, tbl_cargo.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID' );   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_cargo', 'tbl_cargo.car_id=tbl_usuario.CAR_ID');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id =tbl_plan_mercadeo_estado.esp_id ');
        $builder->where('tbl_plan_comercial.usu_id',$usu_id);    
        $builder->where('tbl_plan_comercial.plc_archivar',1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlanplmpadre($plc_padre)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_comercial.plc_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_comercial.plc_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_comercial.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($plc_padre)){
            $builder->where('tbl_plan_comercial.plc_padre',$plc_padre);    
        }
        $builder->where('tbl_plan_comercial.plc_archivar',0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCodigoPlan()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->selectMax('tbl_plan_comercial.plc_id');    
        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getCoordinadoresPlan()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_datos_personales');
        $builder->distinct('tbl_datos_personales.DAP_NOMBRES,tbl_usuario.USU_ID');
        $builder->join('tbl_usuario', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID');   
        $builder->join('tbl_proveedor', 'tbl_proveedor.pro_coordinador=tbl_usuario.USU_ID'); 
        $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_proveedor.pro_id'); 
        $builder->join('tbl_plan_comercial', 'tbl_auspiciante_plan_mercadeo.plc_id=tbl_plan_comercial.plc_id'); 
        $builder->groupby('tbl_usuario.USU_ID'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getAccionesPlan($rol_id, $esp_id)
    {
        try {
            $db = \Config\Database::connect();
            $builder = $db->table('tbl_accion');
            $builder->distinct('tbl_accion.acc_accion, tbl_accion.acc_id');
            $builder->join('tbl_accion_rol', 'tbl_accion.acc_id = tbl_accion_rol.acc_id');
            $builder->join('tbl_rol', 'tbl_rol.ROL_ID=tbl_accion_rol.rol_id');
            $builder->join('tbl_accion_rol_estado', 'tbl_accion_rol_estado.acr_id=tbl_accion_rol.acr_id');
            $builder->where('tbl_accion.acc_modulo', 3);
            $builder->where('tbl_accion_rol_estado.aro_estado', 1);
            $builder->where('tbl_accion_rol.rol_id', $rol_id);
            $builder->where('(tbl_accion_rol_estado.esp_id ='.$esp_id.' OR tbl_accion_rol_estado.esp_id IS NULL)');
            //$builder->groupBy('tbl_accion.acc_accion, tbl_accion.acc_id');
            $query = $builder->get();
            $resultado = $query->getResultArray();
            return $resultado;
        } catch (\Exception $e) {
            return 'Error: ' . $e->getMessage();
        }
    }
    public function getAccionesArgumentos($acc_id,$tipo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_accion_argumento');
        $builder->select('tbl_accion_argumento.aca_argumento,tbl_accion_argumento.aca_json_encode');
        $builder->where('tbl_accion_argumento.acc_id', $acc_id);
        $builder->where('tbl_accion_argumento.aca_funcion', $tipo);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data,$plc_nombreplan,$plc_codigo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
		$builder->insert($data);
		
        
        $builder->selectMax('tbl_plan_comercial.plc_id');
        $builder->where('tbl_plan_comercial.plc_nombreplan',$plc_nombreplan);
        $builder->where('tbl_plan_comercial.plc_codigo', $plc_codigo);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;

    }
    public function actualizar($plc_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->where('tbl_plan_comercial.plc_id', $plc_id);
		return $builder->update($data);        
    }
    
    public function ArchivarPlanTiempo($plc_fechacreacion, $usu_id, $data)
    {
        $db      = \Config\Database::connect();
        $r=0;
        $builder = $db->table('tbl_plan_comercial');
        $builder->select('tbl_plan_comercial.plc_codigo');    
        $builder->where('tbl_plan_comercial.plc_fechacreacion', $plc_fechacreacion);
        $builder->where('tbl_plan_comercial.esp_id!= 6');
        $builder->where('tbl_plan_comercial.usu_id', $usu_id);
        $builder->where('tbl_plan_comercial.plc_archivar', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        
        if(count($resultado)>0){
            $builder = $db->table('tbl_plan_comercial');
            $builder->where('tbl_plan_comercial.plc_fechacreacion', $plc_fechacreacion);
            $builder->where('tbl_plan_comercial.esp_id != 6');
            $builder->where('tbl_plan_comercial.usu_id', $usu_id);
            $builder->where('tbl_plan_comercial.plc_archivar', 0);
            $builder->update($data); 
            $r=1;
        }
		return $r;       
    }
    
    public function eliminar($are_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial');
        $builder->where('tbl_plan_comercial.are_id', $are_id);   
		$builder->update($data);        
    }

public function modelPrueba ()
	{
	    return 'prueba';
	}
	
}