<?php 
namespace App\Models;

use CodeIgniter\Model;

class Plancomercialauspicianterealmodel extends Model
{
    public function getAuspicianterealrealsegunaupid($aup_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial_auspiciante_real');
        $builder->select('tbl_plan_comercial_auspiciante_real.*,tbl_proveedor.*'); 
        $builder->join('tbl_proveedor','tbl_proveedor.pro_id=tbl_plan_comercial_auspiciante_real.pro_id'); 
        $builder->where('tbl_plan_comercial_auspiciante_real.aup_id', $aup_id);  
        $builder->orderBy('tbl_plan_comercial_auspiciante_real.par_fecha_cobro', 'ASC'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function getValorCobradoPorAuspicio($pro_id, $aup_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial_auspiciante_real');
        $builder->select('SUM(tbl_plan_comercial_auspiciante_real.par_valor) AS suma_valor'); // Asigna un alias a la suma
        $builder->join('tbl_proveedor','tbl_proveedor.pro_id=tbl_plan_comercial_auspiciante_real.pro_id'); 
        $builder->join('tbl_auspiciante_plan_comercial','tbl_auspiciante_plan_comercial.aup_id=tbl_plan_comercial_auspiciante_real.aup_id'); 
        $builder->where('tbl_auspiciante_plan_comercial.aup_id', $aup_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial_auspiciante_real');
        $builder->set($data);
        $builder->insert();

    }
    public function eliminar($par_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_comercial_auspiciante_real');
        $builder->where('tbl_plan_comercial_auspiciante_real.par_id', $par_id);   
        $builder->delete();        
    }
    
    public function getResumenauspicios($are_id){
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.plm_codigo,tbl_plan_comercial_auspiciante_real.*');   

        $builder->join('tbl_auspiciante_plan_comercial', 'tbl_plan_mercadeo.plm_id=tbl_auspiciante_plan_comercial.plm_id');
        $builder->join('tbl_plan_comercial_auspiciante_real', 'tbl_auspiciante_plan_comercial.aup_id=tbl_plan_comercial_auspiciante_real.aup_id');
        
        if(!empty($are_id)){
            $builder->where('tbl_plan_mercadeo.plm_areadestino',$are_id);    
        }
       
        $builder->orderBy('tbl_plan_comercial_auspiciante_real.aur_fecha'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

   

    
}