<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Planmodel extends Model
{
    public function getPlan($plm_nombreplan,$fechadesde,$fechahasta ,$can_id,$plm_totalgastomateriales,$esp_id,$are_id,$coordinador)
    {
        $db      = \Config\Database::connect();
        $year = 2022;//date("Y"); 
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($coordinador)){
            $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plm_id=tbl_plan_mercadeo.plm_id');
            $builder->join('tbl_proveedor', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_proveedor.pro_id');
            $builder->where('tbl_proveedor.pro_coordinador',$coordinador);    
        }
        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_codigo',$plm_nombreplan);    
            $builder->orlike('tbl_plan_mercadeo.plm_nombreplan', $plm_nombreplan);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion >=',$fechadesde);
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion <=',$fechahasta);
        }
        else{
            $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)>=',$year);
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_mercadeo.plm_areadestino',$are_id);    
        }
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_mercadeo.can_id',$can_id);    
            $builder->orwhere('tbl_plan_mercadeo.can_id','1');
        }*/
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_mercadeo.esp_id',$esp_id);    
        }
        
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        
        if(!empty($coordinador)){
           $builder->groupBy('tbl_plan_mercadeo.plm_id');
        }
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function getPlanAreaSolicitante($plm_nombreplan,$fechadesde,$fechahasta ,$can_id,$plm_totalgastomateriales,$esp_id,$are_id,$coordinador,$usu_id)
    {
        $db      = \Config\Database::connect();
        $year = date("Y"); 
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($coordinador)){
            $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plm_id=tbl_plan_mercadeo.plm_id');
            $builder->join('tbl_proveedor', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_proveedor.pro_id');
            $builder->where('tbl_proveedor.pro_coordinador',$coordinador);    
        }
        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_nombreplan',$plm_nombreplan);    
            $builder->orlike('tbl_plan_mercadeo.plm_codigo', $plm_nombreplan);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion >=',$fechadesde);
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion <=',$fechahasta);
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_mercadeo.plm_areadestino',$are_id);    
        }
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_mercadeo.can_id',$can_id);    
            $builder->orwhere('tbl_plan_mercadeo.can_id','1');
        }*/
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_mercadeo.esp_id',$esp_id);    
        }
        
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
       
        if(!empty($coordinador)){
           $builder->groupBy('tbl_plan_mercadeo.plm_id');
        }
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getCodigoPlanId($plm_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*');   
        $builder->where('tbl_plan_mercadeo.plm_id',$plm_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    
    public function getPlanNegociador($plm_nombreplan,$plm_fechacreacion,$can_id,$plm_totalgastomateriales,$esp_id,$are_id,$usu_id)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plm_id=tbl_plan_mercadeo.plm_id');
        $builder->join('tbl_usuario_proveedor', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_usuario_proveedor.pro_id');   

        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_nombreplan',$plm_nombreplan);    
        }
        if(!empty($plm_fechacreacion)){
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion',$plm_fechacreacion);    
        }
        
        /*if(!empty($can_id)){
            $builder->where('tbl_plan_mercadeo.can_id',$can_id);    
            $builder->orwhere('tbl_plan_mercadeo.can_id','1');
        }*/
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_mercadeo.esp_id',$esp_id);    
        }

        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
        $builder->where('tbl_usuario_proveedor.usu_id',$usu_id);
        $builder->where('tbl_plan_mercadeo.esp_id',6);
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function getPlanAuspicios($plm_nombreplan,$fechadesde,$fechahasta ,$plm_totalgastomateriales,$esp_id,$coordinador)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_plan_mercadeo_estado.*,tbl_auspiciante_plan_mercadeo.*,tbl_proveedor.*,tbl_datos_personales.*');     
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');
        $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_plan_mercadeo.plm_id=tbl_auspiciante_plan_mercadeo.plm_id','left');
        $builder->join('tbl_proveedor', 'tbl_proveedor.pro_id=tbl_auspiciante_plan_mercadeo.pro_id','left');
        $builder->join('tbl_usuario', 'tbl_proveedor.pro_coordinador=tbl_usuario.usu_id','left');
        $builder->join('tbl_datos_personales', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID','left');
        $builder->where('tbl_plan_mercadeo.esp_id = 6'); 
        
        if(!empty($coordinador)){
            $builder->where('tbl_proveedor.pro_coordinador',$coordinador);    
        }
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        if(!empty($esp_id)){
            $builder->where('tbl_plan_mercadeo.esp_id',$esp_id);    
        }
        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_nombreplan',$plm_nombreplan);    
            $builder->orlike('tbl_plan_mercadeo.plm_codigo', $plm_nombreplan);
        }
        if(empty($fechadesde) && empty($fechahasta) && empty($plm_nombreplan)){
            $builder->where('YEAR(tbl_plan_mercadeo.plm_fechainicioplan)',$year);
        }
        if(!empty($fechadesde)){
            $builder->where('tbl_plan_mercadeo.plm_fechainicioplan>=',$fechadesde);    
        }
        if(!empty($fechahasta)){
            $builder->where('tbl_plan_mercadeo.plm_fechainicioplan<=',$fechahasta);    
        }
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlanaprobador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales, $are_id)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   

        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_codigo',$plm_nombreplan);    
            $builder->orlike('tbl_plan_mercadeo.plm_nombreplan', $plm_nombreplan);
        }
        if(!empty($plm_fechacreacion)){
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion',$plm_fechacreacion);    
        }
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        if(!empty($are_id)){
            $builder->where('tbl_plan_mercadeo.plm_areadestino',$are_id);    
        }
        $builder->where('(tbl_plan_mercadeo.esp_id != 10');
        //$builder->where('(tbl_plan_mercadeo.esp_id = 1 OR tbl_plan_mercadeo.esp_id = 12 OR tbl_plan_mercadeo.esp_id = 3 OR tbl_plan_mercadeo.esp_id = 2 OR tbl_plan_mercadeo.esp_id = 4 OR tbl_plan_mercadeo.esp_id = 5)'); 
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPlanautorizador($plm_nombreplan,$plm_fechacreacion,$plm_totalgastomateriales)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   

        if(!empty($plm_nombreplan)){
            $builder->like('tbl_plan_mercadeo.plm_codigo',$plm_nombreplan);    
            $builder->orlike('tbl_plan_mercadeo.plm_nombreplan', $plm_nombreplan);
        }
        if(!empty($plm_fechacreacion)){
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion',$plm_fechacreacion);    
        }
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        
        $builder->where('(tbl_plan_mercadeo.esp_id = 4 OR tbl_plan_mercadeo.esp_id = 6 OR tbl_plan_mercadeo.esp_id = 7 OR tbl_plan_mercadeo.esp_id = 8)'); 
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlancontabilidad($plm_totalgastomateriales)
    {
        $year = date("Y"); 
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($plm_totalgastomateriales)){
            $builder->where('tbl_plan_mercadeo.plm_totalgastomateriales',$plm_totalgastomateriales);    
        }
        //$builder->where('tbl_plan_mercadeo.plm_padre',0); 
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        $builder->where('YEAR(tbl_plan_mercadeo.plm_fechacreacion)',$year);
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getPlanID($plm_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID' );   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_cargo', 'tbl_cargo.car_id=tbl_usuario.CAR_ID');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id =tbl_plan_mercadeo_estado.esp_id ');
        
        $builder->where('tbl_plan_mercadeo.plm_id',$plm_id);  
        $builder->orderBy('tbl_plan_mercadeo.plm_fechacreacion','desc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    
    public function getPlanPadres()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_plan_mercadeo_estado.*');     
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');
        //$builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_plan_mercadeo.plm_id=tbl_auspiciante_plan_mercadeo.plm_id');
        //$builder->join('tbl_proveedor', 'tbl_proveedor.pro_id=tbl_auspiciante_plan_mercadeo.pro_id');
        //$builder->where('tbl_plan_mercadeo.plm_padre',0);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    
    public function getPlanMaterialesRealesSuma($plm_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->selectSum('tbl_plan_mercadeo_material_real.pmr_subtotal');     
        $builder->join('tbl_plan_mercadeo_material', 'tbl_plan_mercadeo.plm_id=tbl_plan_mercadeo_material.plm_id');
        $builder->join('tbl_plan_mercadeo_material_real', 'tbl_plan_mercadeo_material_real.pma_id=tbl_plan_mercadeo_material.pma_id');
        //$builder->where('tbl_plan_mercadeo.esp_id = 6'); 
        $builder->where('tbl_plan_mercadeo.plm_id', $plm_id); 
        $builder->orWhere('tbl_plan_mercadeo.plm_padre', $plm_id); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPlanArchivo($usu_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*, tbl_cargo.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID' );   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_cargo', 'tbl_cargo.car_id=tbl_usuario.CAR_ID');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id =tbl_plan_mercadeo_estado.esp_id ');
        $builder->where('tbl_plan_mercadeo.usu_id',$usu_id);    
        $builder->where('tbl_plan_mercadeo.plm_archivar',1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPlanplmpadre($plm_padre)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.*,tbl_area.*,tbl_usuario.*,tbl_datos_personales.*,tbl_plan_mercadeo_estado.*');   
        $builder->join('tbl_usuario', 'tbl_plan_mercadeo.plm_solicitante=tbl_usuario.USU_ID');   
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');   
        $builder->join('tbl_area', 'tbl_plan_mercadeo.plm_areadestino=tbl_area.are_id');
        $builder->join('tbl_plan_mercadeo_estado', 'tbl_plan_mercadeo.esp_id=tbl_plan_mercadeo_estado.esp_id');   
        if(!empty($plm_padre)){
            $builder->where('tbl_plan_mercadeo.plm_padre',$plm_padre);    
        }
        $builder->where('tbl_plan_mercadeo.plm_archivar',0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCodigoPlan()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->selectMax('tbl_plan_mercadeo.plm_codigo');    
        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getCoordinadoresPlan()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_datos_personales');
        $builder->distinct('tbl_datos_personales.DAP_NOMBRES,tbl_usuario.USU_ID');
        $builder->join('tbl_usuario', 'tbl_datos_personales.DAP_ID=tbl_usuario.DAP_ID');   
        $builder->join('tbl_proveedor', 'tbl_proveedor.pro_coordinador=tbl_usuario.USU_ID'); 
        $builder->join('tbl_auspiciante_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.pro_id=tbl_proveedor.pro_id'); 
        $builder->join('tbl_plan_mercadeo', 'tbl_auspiciante_plan_mercadeo.plm_id=tbl_plan_mercadeo.plm_id'); 
        $builder->groupby('tbl_usuario.USU_ID'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getAccionesPlan($rol_id, $esp_id)
    {
        $esp=[$esp_id,NULL];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_accion');
        $builder->distinct('tbl_accion.acc_accion, tbl_accion.acc_id');
        $builder->distinct('tbl_accion.acc_id');
        $builder->join('tbl_accion_rol', 'tbl_accion.acc_id = tbl_accion_rol.acc_id');   
        $builder->join('tbl_rol', 'tbl_rol.ROL_ID=tbl_accion_rol.rol_id'); 
        $builder->join('tbl_accion_rol_estado', 'tbl_accion_rol_estado.acr_id=tbl_accion_rol.acr_id'); 
        $builder->where('tbl_accion.acc_modulo',1);
        $builder->where('tbl_accion_rol_estado.aro_estado',1);
        $builder->where('tbl_accion_rol.rol_id', $rol_id);
        $builder->where('(tbl_accion_rol_estado.esp_id ='.$esp_id.' or tbl_accion_rol_estado.esp_id is NULL)');
        //$builder->orwhere('');
        $builder->groupby('tbl_accion.acc_id'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getAccionesArgumentos($acc_id,$tipo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_accion_argumento');
        $builder->select('tbl_accion_argumento.aca_argumento,tbl_accion_argumento.aca_json_encode');
        $builder->where('tbl_accion_argumento.acc_id', $acc_id);
        $builder->where('tbl_accion_argumento.aca_funcion', $tipo);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data,$plm_nombreplan,$plm_codigo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
		$builder->insert($data);
        
        $builder->selectMax('tbl_plan_mercadeo.plm_id');
        $builder->where('tbl_plan_mercadeo.plm_nombreplan',$plm_nombreplan);
        $builder->where('tbl_plan_mercadeo.plm_codigo', $plm_codigo);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;

    }
    public function actualizar($plm_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->where('tbl_plan_mercadeo.plm_id', $plm_id);
		return $builder->update($data);        
    }
    
    public function ArchivarPlanTiempo($plm_fechacreacion, $usu_id, $data)
    {
        $db      = \Config\Database::connect();
        $r=0;
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->select('tbl_plan_mercadeo.plm_codigo');    
        $builder->where('tbl_plan_mercadeo.plm_fechacreacion', $plm_fechacreacion);
        $builder->where('tbl_plan_mercadeo.esp_id!= 6');
        $builder->where('tbl_plan_mercadeo.usu_id', $usu_id);
        $builder->where('tbl_plan_mercadeo.plm_archivar', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        
        if(count($resultado)>0){
            $builder = $db->table('tbl_plan_mercadeo');
            $builder->where('tbl_plan_mercadeo.plm_fechacreacion', $plm_fechacreacion);
            $builder->where('tbl_plan_mercadeo.esp_id != 6');
            $builder->where('tbl_plan_mercadeo.usu_id', $usu_id);
            $builder->where('tbl_plan_mercadeo.plm_archivar', 0);
            $builder->update($data); 
            $r=1;
        }
		return $r;       
    }
    
    public function eliminar($are_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_plan_mercadeo');
        $builder->where('tbl_plan_mercadeo.are_id', $are_id);   
		$builder->update($data);        
    }

public function modelPrueba ()
	{
	    return 'prueba';
	}
	
}