<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamosmodel extends Model
{
    public function getPrestamos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*,tbl_punto_venta.*');    
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->set($data);
		$builder->insert();

    }
    public function getSoloPrestamos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');   
        $builder->where('tbl_prestamos.pre_estado', 1); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnPrestamosnombrepuvid($pre_nombre,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');  
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);  
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnPrestamosidpuvid($pre_id,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');  
        $builder->where('tbl_prestamos.puv_id', $puv_id); 
        $builder->where('tbl_prestamos.pre_id', $pre_id); 
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getPrestamosdesdehasta($pre_fecha_desde,$pre_fecha_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');    
        $builder->where('tbl_prestamos.pre_fecha_desde <=', $pre_fecha_desde); 
        $builder->where('tbl_prestamos.pre_fecha_hasta >=', $pre_fecha_hasta); 
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPrestamosdesdehastaDistinct($pre_fecha_desde,$pre_fecha_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.pre_nombre');    
        $builder->distinct();
        $builder->where('tbl_prestamos.pre_fecha_desde <=', $pre_fecha_desde); 
        $builder->where('tbl_prestamos.pre_fecha_hasta >=', $pre_fecha_hasta);
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function actualizar($pre_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->where('tbl_prestamos.pre_id', $pre_id);
        return $builder->update($data);        
    }
    public function eliminar($pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->where('tbl_prestamos.pre_id', $pre_id);   
        $builder->delete();        
    }
    

}