<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Ventamodel extends Model
{
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->set($data);
		$builder->insert();

    }

    public function getVentasegunpuvidmes($puv_id,$mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.puv_id', $puv_id); 
        $builder->where('tbl_venta.ven_mes', $mes );
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getVentaspormes($mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.ven_mes', $mes );
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function actualizar($ven_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_id', $ven_id);
        return $builder->update($data);        
    }
    public function eliminarpormes($ven_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_mes', $ven_mes);
        return $builder->delete();        
    }
    
    public function getTotalVentasMes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('sum(ven_venta_neta) as valor, monthname(ven_fecha_contable)as mes');    
        $builder->where('year(curdate())=year(ven_fecha_contable) GROUP by mes');
        $builder->orderBy('ven_fecha_contable','asc');  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function getTotalVentasMesPDV()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('distinct(puv_punto_venta_nombre) as pdv,sum(ven_venta_neta) as valor, monthname(ven_fecha_contable)as mes');    
        $builder->where('year(curdate())=year(ven_fecha_contable) and month(curdate()- INTERVAL 1 MONTH)=month(ven_fecha_contable) GROUP by mes,pdv');
        $builder->orderBy('ven_fecha_contable','asc');  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 

}