<?php

namespace Config;

use CodeIgniter\Config\Services;

// Crea instancia de rutas
$routes = Services::routes();

// Carga rutas del sistema (no tocar)
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * Router Setup
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Auth');   // opcional
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);            // ðŸ”’ Evita rutas fantasma
$routes->get('health', function(){ return 'ok'; });
$routes->get('vtest', function(){ return view('vtest'); });


/**
 * Definiciones de rutas
 */

$routes->get('/', 'Auth::index');                   // https://.../precios/

// Salud/diagnÃ³stico
$routes->get('health', function() { return 'ok'; });
$routes->get('sincronizar/productos', 'Sincronizacion::productos');
$routes->get('sincronizar/test', 'Sincronizacion::test');
$routes->get('sincronizar/productos-async', 'Sincronizacion::productos_async');
$routes->get('sincronizar/iniciar',             'Sincronizacion::iniciar');
$routes->post('sincronizar/continuar/(:num)',   'Sincronizacion::continuar/$1');
$routes->get('sincronizar/estado/(:num)',       'Sincronizacion::estado/$1');


$routes->get('sincronizar/productos-prefijo', 'Sincronizacion::productos_prefijo');
$routes->get('sincronizar/productos-prefijo-v2', 'Sincronizacion::productos_prefijo_v2');
$routes->get('sincronizar/precios-pdv', 'SincronizacionPrecios::precios_pdv'); 
$routes->get('sincronizar/price-lists', 'SincronizacionListas::price_lists');




 // proteger con filtro 'auth'


// ----- AUTH (todo minÃºsculas) -----

$routes->group('auth', function($r){
  $r->get('/', 'Auth::index');
  $r->post('login', 'Auth::login');
  $r->get('logout', 'Auth::logout');
});
$routes->get('/', 'Home::index');       // raÃ­z al Home
$routes->get('Home', 'Home::index');
// ----- MATRICES -----
$routes->group('matrices', function($r) {
    $r->get('(:num)', 'MatrizController::view/$1');           // GET /matrices/{mat_id}
    $r->post('(:num)/save', 'MatrizController::save/$1');     // POST /matrices/{mat_id}/save
    $r->post('(:num)/recalc', 'MatrizController::recalc/$1'); // POST /matrices/{mat_id}/recalc
});

// ----- ESPACIO DE TRABAJO -----
$routes->group('workspace', function($r) {
    $r->get('(:num)/campos', 'EspacioTrabajoController::listCampos/$1'); // GET /workspace/{mat_id}/campos
    $r->post('(:num)/campos', 'EspacioTrabajoController::createCampo/$1'); // POST /workspace/{mat_id}/campos
    $r->post('campo/(:num)/formula', 'EspacioTrabajoController::setFormula/$1'); // POST /workspace/campo/{mac_id}/formula
});

// ----- CARGAS -----
$routes->group('cargas', function($r) {
    $r->post('enqueue', 'CargasController::enqueue'); // POST /cargas/enqueue
    $r->get('(:num)', 'CargasController::status/$1'); // GET  /cargas/{car_id}
});

$routes->get('inicio', 'Inicio::index'); 

$routes->get('diag/viewinfo', function() {
    $paths = new \Config\Paths();
    $file  = rtrim($paths->viewDirectory, '/\\') . DIRECTORY_SEPARATOR . 'vtest.php';
    echo "viewDirectory: {$paths->viewDirectory}<br>";
    echo "Exists(vtest): " . (file_exists($file) ? 'YES' : 'NO') . " @ $file";
});

$routes->group('matrices', static function($r){
    $r->get('/',               'MatrizUI::index');
    $r->get('(:num)/campos',   'MatrizUI::campos/$1');              // vista
    $r->get('(:num)/datos',    'MatrizUI::datos/$1');      

    // Preferencias de usuario (AJAX)
    $r->post('(:num)/vista/save',     'MatrizUI::saveUserView/$1');
    $r->get('(:num)/vista/current',   'MatrizUI::getUserView/$1');
});
$routes->get('matrices/(:num)/campos',           'MatrizUI::campos/$1');
$routes->get('matrices/(:num)/campos/list',      'MatrizUI::camposList/$1');
$routes->post('matrices/(:num)/campos/save',     'MatrizUI::campoSave/$1');
$routes->post('matrices/(:num)/campos/update',   'MatrizUI::campoUpdate/$1');
$routes->post('matrices/(:num)/campos/delete',   'MatrizUI::campoDelete/$1');
$routes->post('matrices/(:num)/campos/test-value','MatrizUI::campoTestValue/$1');


$routes->group('precios', static function($r){
    $r->get('reglas', 'PreciosController::index');
    $r->post('descuentos/guardar', 'PreciosController::guardarDescuentos');
    $r->post('margen/guardar', 'PreciosController::guardarMargen');
});

$routes->get('productos/importar', 'ProductosImportController::index');
$routes->post('productos/importar/preview', 'ProductosImportController::preview');
$routes->post('productos/importar/aplicar', 'ProductosImportController::apply');
$routes->get('productos/plantilla', 'ProductosImportController::plantilla');
$routes->get('productos/matriz', 'ProductoPreciosController::index');
$routes->get('productos/matriz/data', 'ProductoPreciosController::data');

$routes->get ('productos/matriz/detail', 'ProductoPreciosController::detail');
$routes->post('productos/matriz/save',   'ProductoPreciosController::saveDetail');

$routes->group('campos', function($r){
    $r->get('/',           'CamposController::index');
    $r->get('list',        'CamposController::list');
    $r->post('save',       'CamposController::save');
    $r->post('update/(:num)', 'CamposController::update/$1');
    $r->post('delete/(:num)', 'CamposController::delete/$1');
    $r->post('test/(:num)',   'CamposController::test/$1');
});

$routes->group('matrices2', static function($routes){

    // listado
    $routes->get('/',             'Matrices2Controller::index');

    // constructor
    $routes->get('(:num)/builder','Matrices2Controller::builder/$1');

    // grilla UI
    $routes->get('(:num)/grid',   'Matrices2Controller::grid/$1');

    // ⚠️ DataTables server-side (acepta GET y POST)
    $routes->match(['get','post'], '(:num)/data', 'Matrices2Controller::data/$1');

    // API builder
    $routes->post('(:num)/add-fields', 'Matrices2Controller::addFields/$1');
    $routes->post('ref/(:num)/update', 'Matrices2Controller::updateRef/$1');
    $routes->post('ref/(:num)/remove', 'Matrices2Controller::removeRef/$1');

    // inline edit manual
    $routes->post('(:num)/save-manual', 'Matrices2Controller::saveManual/$1');

    // export opcional
    $routes->get('(:num)/export', 'Matrices2Controller::export/$1'); // si lo tienes
});
$routes->post('matrices2/(:num)/eval', 'Matrices2Controller::eval/$1');

$routes->get('matrices2/(:num)/debug-sources', 'Matrices2Controller::debugSources/$1');
$routes->group('matrices2', function($r){
    $r->post('(:num)/versions/create', 'Matrices2Controller::createVersion/$1');
    $r->get ('(:num)/versions',        'Matrices2Controller::versions/$1');
    $r->get ('versions/json/(:num)',   'Matrices2Controller::versionJson/$1');
});
// app/Config/Routes.php
$routes->get('matrices2/versions/view/(:num)', 'Matrices2Controller::versionView/$1');


/**
 * Rutas especÃ­ficas por entorno (opcional)
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}