<?php namespace App\Models;

use CodeIgniter\Model;

class MatrizCampoModel extends Model
{
    protected $table = 'tbl_matriz_campo';
    protected $primaryKey = 'mac_id';
    protected $allowedFields = ['mat_id','mac_nombre','mac_titulo','mac_tipo','mac_formato','mac_color','mac_orden','mac_visible'];

    public function camposDeMatriz(int $matId): array
    {
        return $this->where('mat_id',$matId)->orderBy('mac_orden','ASC')->findAll();
    }
}

class FormulaModel extends Model
{
    protected $table = 'tbl_formula';
    protected $primaryKey = 'for_id';
    protected $allowedFields = ['mac_id','for_expresion'];

    public function mapFormulasPorCampo(int $matId): array
    {
        $sql = "SELECT mc.mac_nombre, f.for_expresion
                  FROM tbl_formula f
             LEFT JOIN tbl_matriz_campo mc ON mc.mac_id = f.mac_id
                 WHERE mc.mat_id = ?";
        $rows = $this->db->query($sql, [$matId])->getResultArray();
        $map  = [];
        foreach ($rows as $r) $map[$r['mac_nombre']] = $r['for_expresion'];
        return $map;
    }
}
