<?php namespace App\Models;

use CodeIgniter\Model;

class MenuModel extends Model
{
    protected $DBGroup = 'postgres';
    protected $table   = 'tbl_menu';
    protected $primaryKey = 'men_id';
    protected $returnType = 'array';

    /** Menú completo (padres e hijos) con alias en MAYÚSCULAS para tu vista */
    public function menuCompleto(): array
    {
        $sql = "SELECT 
                    m.men_id   AS MEN_ID,
                    m.men_nombre AS MEN_NOMBRE,
                    m.men_ruta AS MEN_LINK,
                    COALESCE(men_padre, 0) AS MEN_PADRE,
                    COALESCE(m.men_icono,'') AS MEN_ICONO,
                    m.men_orden AS MEN_ORDEN,
                    m.men_estado AS MEN_ESTADO
                FROM tbl_menu m
                WHERE m.men_estado = 1
                ORDER BY m.men_padre, m.men_orden, m.men_id";
        return $this->db->query($sql)->getResultArray();
    }

    /**
     * Relación rol→menú (ids de menús que el rol puede ver)
     * Retorna array de filas con MEN_ID (como usas en la vista)
     */
    public function menuIdsPorRoles(array $rolesNombres): array
    {
        if (empty($rolesNombres)) return [];
        $in = str_repeat('?,', count($rolesNombres)-1) . '?';

        $sql = "SELECT DISTINCT m.men_id AS MEN_ID
                  FROM tbl_menu m
                  JOIN tbl_menu_rol mr ON mr.men_id = m.men_id
                  JOIN tbl_rol r       ON r.rol_id  = mr.rol_id
                 WHERE m.men_estado = 1
                   AND r.rol_nombre IN ($in)";
        return $this->db->query($sql, $rolesNombres)->getResultArray();
    }

    /** Versión por usuario (si prefieres por usuario en vez de por nombre de rol) */
    public function menuIdsPorUsuario(int $usuId): array
    {
        $sql = "SELECT DISTINCT m.men_id AS MEN_ID
                  FROM tbl_menu m
                  JOIN tbl_menu_rol mr  ON mr.men_id = m.men_id
                  JOIN tbl_rol r        ON r.rol_id  = mr.rol_id
                  JOIN tbl_usuario_rol ur ON ur.rol_id = r.rol_id
                 WHERE m.men_estado = 1
                   AND ur.usu_id = ?";
        return $this->db->query($sql, [$usuId])->getResultArray();
    }
}
