<?php namespace App\Models;

use CodeIgniter\Model;

class PreciosSyncModel extends Model
{
    protected $DBGroup = 'postgres';

    /**
     * Ejecuta en TRANSACCIÓN: upsert de productos + upsert de stocks.
     * - Detecta errores inmediatamente tras CADA operación.
     * - Si hay error, hace ROLLBACK y devuelve ['ok'=>false,'error'=>...].
     */
    public function syncPage(array $rows, array $stocks): array
    {
        // Conexión nueva por página para evitar quedar “aborted” de páginas previas
        $db = \Config\Database::connect($this->DBGroup, true);

        $prod  = new \App\Models\ProductoModel();
        $stock = new \App\Models\ProductoStockModel();

        $db->transBegin();

        // 1) UPSERT productos
        try {
            $counters = $prod->upsertBatchWithHash($rows);
        } catch (\Throwable $e) {
            $db->transRollback();
            return ['ok' => false, 'error' => ['message' => 'UPSERT productos: '.$e->getMessage()]];
        }
        $err = $db->error();
        if (!empty($err['code'])) {
            $db->transRollback();
            return ['ok' => false, 'error' => ['message' => 'UPSERT productos BD: '.$err['message'], 'code'=>$err['code']]];
        }

        // 2) UPSERT stocks
        try {
            $stock->upsertStocks($stocks);
        } catch (\Throwable $e) {
            $db->transRollback();
            return ['ok' => false, 'error' => ['message' => 'UPSERT stocks: '.$e->getMessage()]];
        }
        $err = $db->error();
        if (!empty($err['code'])) {
            $db->transRollback();
            return ['ok' => false, 'error' => ['message' => 'UPSERT stocks BD: '.$err['message'], 'code'=>$err['code']]];
        }

        // Commit final
        if (!$db->transCommit()) {
            // Si commit falló, deja rastro
            $err = $db->error();
            $db->transRollback();
            return ['ok' => false, 'error' => ['message' => 'COMMIT falló: '.($err['message'] ?? 'sin detalle')]];
        }

        return ['ok' => true] + $counters;
    }
}
