<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">Catálogo global de campos</h2>
    <button class="btn btn-sm btn-primary" id="btn-nuevo">Nuevo campo</button>
  </div>

  <div class="card">
    <div class="card-body">
      <table id="tbl-campos" class="table table-sm table-striped table-bordered w-100">
        <thead>
          <tr>
            <th>ID</th><th>Nombre</th><th>Título</th><th>Origen</th><th>Tipo</th><th>Activo</th><th>Acciones</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
      <small class="text-muted">Origen: <b>lectura</b>, <b>param</b> o <b>formula</b>. Todo con 4 decimales para números.</small>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalCampo" tabindex="-1">
  <div class="modal-dialog modal-lg"><div class="modal-content">
    <form id="frmCampo" autocomplete="off">
      <div class="modal-header">
        <h5 class="modal-title">Campo</h5>
        <button type="button" class="close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="cam_id">

        <div class="row g-2">
          <div class="col-md-4">
            <label class="form-label">Nombre</label>
            <input class="form-control" id="cam_nombre" name="cam_nombre" required>
          </div>
          <div class="col-md-5">
            <label class="form-label">Título</label>
            <input class="form-control" id="cam_titulo" name="cam_titulo" required>
          </div>
          <div class="col-md-3">
            <label class="form-label">Activo</label>
            <select class="form-select" id="cam_activo" name="cam_activo">
              <option value="1">Sí</option><option value="0">No</option>
            </select>
          </div>
        </div>

        <div class="row g-2 mt-1">
          <div class="col-md-3">
            <label class="form-label">Origen</label>
            <select class="form-select" id="cam_origen" name="cam_origen">
              <option value="lectura">lectura</option>
              <option value="param">param</option>
              <option value="formula">formula</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Tipo</label>
            <select class="form-select" id="cam_tipo" name="cam_tipo">
              <option>text</option><option>number</option><option>money</option>
              <option>percent</option><option>date</option><option>bool</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Formato</label>
            <input class="form-control" id="cam_formato" name="cam_formato" placeholder="0,0.0000">
          </div>
          <div class="col-md-3">
            <label class="form-label">Color</label>
            <input class="form-control" id="cam_color" name="cam_color" placeholder="#RRGGBB">
          </div>
        </div>

        <div id="blk-lectura" class="border rounded p-2 mt-2" style="display:none">
          <label class="form-label"><b>Fuente (JSON)</b></label>
          <textarea class="form-control" id="cam_source" name="cam_source" rows="3" placeholder='{"table":"tbl_producto","column":"pro_cost","fallbacks":["vw_pdv_last_price.price","const:0"]}'></textarea>
        </div>

        <div id="blk-formula" class="border rounded p-2 mt-2" style="display:none">
          <label class="form-label"><b>Fórmula</b></label>
          <textarea class="form-control" id="cam_formula" name="cam_formula" rows="3" placeholder="ROUND( (pp_actual - precio_hoy_megapos) / NULLIF(pp_actual,0), 4 )"></textarea>
          <label class="form-label mt-2">Dependencias (JSON array)</label>
          <input class="form-control" id="cam_depends" name="cam_depends" placeholder='["pp_actual","precio_hoy_megapos"]'>
          <div class="row g-2 mt-2">
            <div class="col-md-4"><input class="form-control" id="test_pro_id" placeholder="pro_id prueba"></div>
            <div class="col-md-3"><button type="button" id="btn-probar" class="btn btn-outline-secondary w-100">Probar</button></div>
            <div class="col-md-5"><small id="test_result" class="text-info"></small></div>
          </div>
        </div>

      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
        <button class="btn btn-primary" type="submit">Guardar</button>
      </div>
    </form>
  </div></div>
</div>

<script>
$(function(){
  const base = '<?= site_url('campos'); ?>';

  const dt = $('#tbl-campos').DataTable({
    ajax: { url: base + '/list', dataSrc: 'data' },
    columns: [
      {data:'cam_id'},{data:'cam_nombre'},{data:'cam_titulo'},{data:'cam_origen'},{data:'cam_tipo'},
      {data:'cam_activo', render:v=> parseInt(v,10)===1?'<span class="badge bg-success">Sí</span>':'<span class="badge bg-secondary">No</span>'},
      {data:null, orderable:false, render:r=>`
        <button class="btn btn-sm btn-outline-primary btn-edit" data-id="${r.cam_id}">Editar</button>
        <button class="btn btn-sm btn-outline-danger btn-del" data-id="${r.cam_id}">Eliminar</button>`}
    ],
    pageLength:25, order:[[1,'asc']],
    language:{url:'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json'}
  });

  function toggleBlocks(){
    const v = $('#cam_origen').val();
    $('#blk-lectura').toggle(v==='lectura');
    $('#blk-formula').toggle(v==='formula');
  }
  $('#cam_origen').on('change', toggleBlocks);

  $('#btn-nuevo').on('click', ()=>{
    $('#frmCampo')[0].reset();
    $('#cam_id').val('');
    $('#cam_nombre').prop('disabled', false);
    $('#test_result').text('');
    toggleBlocks();
    $('#modalCampo').modal('show');

  });

  $('#tbl-campos').on('click','.btn-edit', function(){
    const r = dt.row($(this).closest('tr')).data();
    if(!r) return;
    $('#frmCampo')[0].reset();
    $('#cam_id').val(r.cam_id);
    $('#cam_nombre').val(r.cam_nombre).prop('disabled', true);
    $('#cam_titulo').val(r.cam_titulo);
    $('#cam_origen').val(r.cam_origen);
    $('#cam_tipo').val(r.cam_tipo);
    $('#cam_formato').val(r.cam_formato || '');
    $('#cam_color').val(r.cam_color || '');
    $('#cam_activo').val(r.cam_activo);
    $('#cam_source').val(r.cam_source ? (typeof r.cam_source==='string'? r.cam_source : JSON.stringify(r.cam_source)) : '');
    $('#cam_formula').val(r.cam_formula || '');
    $('#cam_depends').val(r.cam_depends ? (typeof r.cam_depends==='string'? r.cam_depends : JSON.stringify(r.cam_depends)) : '[]');
    $('#test_result').text('');
    toggleBlocks();
    $('#modalCampo').modal('show');

  });

  $('#tbl-campos').on('click','.btn-del', function(){
    if(!confirm('¿Eliminar campo?')) return;
    $.post(base + '/delete/' + $(this).data('id')).done(()=>dt.ajax.reload(null,false));
  });

  $('#frmCampo').on('submit', function(e){
    e.preventDefault();
    const id = $('#cam_id').val();
    const url = id ? (base + '/update/' + id) : (base + '/save');
    $.post(url, $(this).serialize())
      .done(()=>{ $('#modalCampo').modal('hide'); dt.ajax.reload(null,false); })
      .fail(x=>alert(x.responseJSON?.msg || 'Error'));
  });

  $('#btn-probar').on('click', function(){
    const id = $('#cam_id').val();
    const pro = parseInt($('#test_pro_id').val()||'0',10);
    if(!id) return alert('Guarda el campo primero');
    if(!pro) return alert('Ingresa pro_id');
    $.post(base + '/test/' + id, {pro_id: pro})
      .done(r=> $('#test_result').text('Resultado: ' + (r.value ?? 'NULL')))
      .fail(x=> $('#test_result').text('Error: ' + (x.responseJSON?.msg || 'falló')));
  });
});
</script>
