<script>
(function(){
  var matId = <?= $matId ?>;
  var base = '<?= rtrim(site_url('matrices'), '/') ?>/' + matId + '/campos';

  var $tbl = $('#tbl-campos');
  var dt = $tbl.DataTable({
    ajax: {
      url: base + '/list',
      dataSrc: function(json){
        return (json && json.data) ? json.data : [];
      }
    },
    columns: [
      { data: 'mac_id' },
      { data: 'mac_nombre' },
      { data: 'mac_titulo' },
      { data: 'mac_tipo' },
      { data: 'mac_formato', defaultContent: '' },
      { data: 'mac_color', defaultContent: '' },
      { data: 'mac_orden', defaultContent: '' },
      { data: 'mac_visible', render: function(v){ return (parseInt(v,10)===1) ? '<span class="badge bg-success">Sí</span>' : '<span class="badge bg-secondary">No</span>'; } },
      { data: null, orderable:false, render: function(row){
          return ''+
            '<button type="button" class="btn btn-xs btn-outline-primary btn-edit" data-id="'+row.mac_id+'">Editar</button> '+
            '<button type="button" class="btn btn-xs btn-outline-danger btn-del" data-id="'+row.mac_id+'">Eliminar</button>';
        }
      }
    ],
    pageLength: 25,
    order: [[6,'asc'], [0,'asc']],
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });

  // Nuevo
  $('#btn-nuevo').on('click', function(){
    $('#frmCampo')[0].reset();
    $('#mac_id').val('');
    $('#mac_nombre').prop('disabled', false);
    $('#modalCampo').modal('show');
  });

  // Editar
  $tbl.on('click', '.btn-edit', function(){
    var row = dt.row($(this).closest('tr')).data();
    if(!row) return;

    $('#mac_id').val(row.mac_id);
    $('#mac_nombre').val(row.mac_nombre).prop('disabled', true);
    $('#mac_titulo').val(row.mac_titulo);
    $('#mac_tipo').val(row.mac_tipo);
    $('#mac_formato').val(row.mac_formato || '');
    $('#mac_color').val(row.mac_color || '');
    $('#mac_orden').val(row.mac_orden || '');
    $('#mac_visible').val(row.mac_visible);

    $('#modalCampo').modal('show');
  });

  // Eliminar
  $tbl.on('click', '.btn-del', function(){
    if(!confirm('¿Eliminar este campo?')) return;
    var id = $(this).data('id');

    $.post(base + '/delete', { mac_id:id })
      .done(function(){ dt.ajax.reload(null,false); })
      .fail(function(x){ alert((x.responseJSON && x.responseJSON.msg) ? x.responseJSON.msg : 'Error al eliminar'); });
  });

  // Guardar (crear/actualizar)
  $('#frmCampo').on('submit', function(e){
    e.preventDefault();
    var id  = $('#mac_id').val();
    var url = id ? (base + '/update') : (base + '/save');

    $.post(url, $(this).serialize())
      .done(function(){
        $('#modalCampo').modal('hide');
        dt.ajax.reload(null,false);
      })
      .fail(function(x){
        alert((x.responseJSON && x.responseJSON.msg) ? x.responseJSON.msg : 'Error al guardar');
      });
  });
})();
</script>
