<?php $matId=(int)$mat['mat_id']; ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
  /* ===== Base blanco ===== */
  body{ background:#fff; }
  .page-wrap{ margin-top:80px; }
  .page-header{
    background:#fff; border:1px solid #e9ecef; border-radius:16px; padding:16px 18px;
    box-shadow:0 4px 14px rgba(0,0,0,.03)
  }
  .page-header h2{ margin:0; font-weight:700; letter-spacing:.2px }
  .chip{ background:#fff; border:1px solid #e9ecef; border-radius:999px; padding:4px 10px; font-size:.8rem; color:#6c757d; display:inline-flex; gap:6px; align-items:center }
  .card{ border-radius:16px; border:1px solid #eef0f3; box-shadow:0 2px 10px rgba(0,0,0,.02) }
  .card-body h5{ font-weight:700; margin-bottom:10px }
  .sticky-title{ background:#fff; padding-top:6px }

  /* ===== Tablas: contenedor con scroll SIN sticky ===== */
  .table-wrap{
    position: relative;
    max-height: 62vh;           /* scroll interno cómodo */
    overflow: auto;
    background:#fff;
    border: 1px solid #eef0f3;
    border-radius: 12px;
  }
  .table-wrap table{ margin-bottom:0 }
  .table-wrap table thead th{
    position: static;           /* <- NO sticky */
    top: auto;
    background:#fff;
    box-shadow: none;
  }
  .table tbody tr:hover{ background:#fbfcfd }

  /* ===== Catálogo ===== */
  #tbl-cat td code{ font-size:.875rem; }
  .match-highlight{ background:#fff3bf; border-radius:4px; padding:0 2px }

  /* ===== Matriz ===== */
  #sortable tr{ transition: background .18s ease }
  #sortable tr.dragging{ background:#f8f9fa }
  .row-handle{ cursor:grab; user-select:none; color:#868e96; font-size:1rem }
  .row-handle:active{ cursor:grabbing }
  .actions .btn{ margin-right:6px }
  .form-control-sm, .form-select-sm{ border-radius:10px }
  .orden{ text-align:center; font-weight:600; }
  .orden::-webkit-outer-spin-button,
  .orden::-webkit-inner-spin-button{ margin:0 }
  .col-orden{ width:90px }

  /* Vacíos y estado */
  .empty{ border:1px dashed #e9ecef; border-radius:14px; padding:22px; color:#6c757d; text-align:center; background:#fff }
  .dirty-banner{ display:none; background:#fff; border:1px solid #ffe8a1; color:#7a5b00; border-radius:10px; padding:8px 12px; margin-bottom:8px }
  .dirty-banner.show{ display:flex; align-items:center; gap:8px }
  :focus-visible{ outline:2px solid #5c7cfa; outline-offset:2px; border-radius:8px }
  .btn .spinner-border{ --bs-spinner-width:1rem; --bs-spinner-height:1rem }

  /* Fullscreen opcional del card */
  .card-fullscreen-toggle{ border:none; background:transparent; padding:6px 8px; border-radius:8px }
  .card-fullscreen-toggle:hover{ background:#f5f6f8 }
  .card.fullscreen{
    position: fixed; inset: 12px; z-index: 1090; background:#fff;
    border:1px solid #e9ecef; border-radius:14px; box-shadow: 0 10px 30px rgba(0,0,0,.12);
    display:flex; flex-direction:column;
  }
  .card.fullscreen .card-body{ flex:1; display:flex; flex-direction:column }
  .card.fullscreen .table-wrap{ max-height: calc(100% - 10px); }
</style>

<div class="container-fluid page-wrap">
  <div class="page-header d-flex justify-content-between align-items-center mb-3">
    <div class="d-flex align-items-center gap-3">
      <i class="bi bi-bricks fs-4 text-primary"></i>
      <h2>
        Constructor — <?= esc($mat['mat_nombre']) ?>
        <small class="text-muted">(<?= esc($mat['mat_tipo']) ?>)</small>
      </h2>
      <span class="chip" title="ID de la matriz"><i class="bi bi-hash"></i> <?= $matId ?></span>
    </div>
    <a class="btn btn-sm btn-outline-dark" href="<?= site_url('matrices2/'.$matId.'/grid'); ?>">
      <i class="bi bi-table"></i> Ver matriz
    </a>
  </div>

  <div class="row g-3">
    <!-- ===== Col: Catálogo ===== -->
    <div class="col-md-5">
      <div class="card" id="card-cat">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-2">Catálogo de campos</h5>
            <div class="d-flex align-items-center gap-2">
              <span class="chip"><i class="bi bi-journal-code"></i> <span id="cat-count"><?= count($campos??[]) ?></span></span>
              <button type="button" class="card-fullscreen-toggle" data-target="#card-cat" title="Expandir/contraer">
                <i class="bi bi-arrows-fullscreen"></i>
              </button>
            </div>
          </div>

          <div class="input-group input-group-sm mb-2" role="search">
            <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
            <input class="form-control" id="q" placeholder="Busca por nombre, título, origen o tipo (atajo: /)">
            <button class="btn btn-outline-secondary" id="btn-q">Buscar</button>
            <button class="btn btn-outline-secondary" id="btn-clear" title="Limpiar (Esc)"><i class="bi bi-x-circle"></i></button>
          </div>

          <?php if (empty($campos)): ?>
            <div class="empty"><i class="bi bi-emoji-neutral me-1"></i> No hay campos en el catálogo.</div>
          <?php else: ?>
          <div class="table-wrap">
            <table class="table table-sm table-hover align-middle" id="tbl-cat">
              <thead>
                <tr>
                  <th style="min-width:220px">Nombre</th>
                  <th>Origen</th>
                  <th>Tipo</th>
                  <th style="width:110px"></th>
                </tr>
              </thead>
              <tbody>
                <?php foreach(($campos??[]) as $c): ?>
                <tr data-id="<?= (int)$c['cam_id'] ?>">
                  <td>
                    <div class="fw-semibold text-dark"><code data-field="cam_nombre"><?= esc($c['cam_nombre']) ?></code></div>
                    <small class="text-muted" data-field="cam_titulo"><?= esc($c['cam_titulo']) ?></small>
                  </td>
                  <td><span class="badge text-bg-light border" data-field="cam_origen"><?= esc($c['cam_origen']) ?></span></td>
                  <td><span class="badge text-bg-light border" data-field="cam_tipo"><?= esc($c['cam_tipo']) ?></span></td>
                  <td class="text-end">
                    <button class="btn btn-xs btn-outline-primary btn-add" data-id="<?= (int)$c['cam_id'] ?>">
                      <i class="bi bi-plus-circle"></i> Agregar
                    </button>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- ===== Col: Matriz ===== -->
    <div class="col-md-7">
      <div class="card" id="card-refs">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-2">Campos de la matriz</h5>
            <div class="d-flex align-items-center gap-2">
              <div id="dirty-banner" class="dirty-banner">
                <i class="bi bi-exclamation-triangle"></i> Cambios sin guardar
              </div>
              <button id="btn-save-all" class="btn btn-sm btn-primary">
                <i class="bi bi-save2"></i> Guardar todo
              </button>
              <button type="button" class="card-fullscreen-toggle" data-target="#card-refs" title="Expandir/contraer">
                <i class="bi bi-arrows-fullscreen"></i>
              </button>
            </div>
          </div>
          <small class="text-muted">Arrastra con <i class="bi bi-grip-vertical"></i> o edita “Orden”.</small>

          <?php if (empty($refs)): ?>
            <div class="empty"><i class="bi bi-inboxes"></i> Aún no has agregado campos. Usa el catálogo de la izquierda.</div>
          <?php else: ?>
          <div class="table-wrap">
            <table class="table table-sm table-striped align-middle" id="tbl-refs">
              <thead>
                <tr>
                  <th style="width:40px"></th>
                  <th class="col-orden">Orden</th>
                  <th>Nombre</th>
                  <th style="width:40%">Título</th>
                  <th style="width:110px">Visible</th>
                  <th style="width:170px">Acciones</th>
                </tr>
              </thead>
              <tbody id="sortable">
                <?php foreach(($refs??[]) as $r): ?>
                <tr data-mcr="<?= (int)$r['mcr_id'] ?>">
                  <td class="text-center"><span class="row-handle bi bi-grip-vertical" title="Arrastrar para reordenar"></span></td>
                  <td style="width:160px">
  <input class="form-control form-control-sm orden" type="number" style="width:100%" value="<?= esc($r['mcr_orden']) ?>">
</td>

                  <td><code><?= esc($r['cam_nombre']) ?></code></td>
                  <td><input class="form-control form-control-sm titulo" value="<?= esc($r['mcr_titulo'] ?: $r['cam_titulo']) ?>" placeholder="Título visible"></td>
                  <td>
                    <select class="form-select form-select-sm visible">
                      <option value="1" <?= ((int)$r['mcr_visible']===1?'selected':'') ?>>Sí</option>
                      <option value="0" <?= ((int)$r['mcr_visible']===0?'selected':'') ?>>No</option>
                    </select>
                  </td>
                  <td class="actions">
                    <button class="btn btn-xs btn-outline-secondary btn-save"><i class="bi bi-check2-circle"></i> Guardar</button>
                    <button class="btn btn-xs btn-outline-danger btn-del"><i class="bi bi-trash3"></i> Quitar</button>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Sortable -->
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.2/Sortable.min.js"></script>

<script>
$(function(){
  const base = '<?= site_url('matrices2'); ?>';
  const matId = <?= $matId ?>;
  const $dirty = $('#dirty-banner');

  // ==== Helpers ====
  const deb = (fn, d=200)=>{let t; return (...a)=>{clearTimeout(t); t=setTimeout(()=>fn.apply(this,a), d)}}
  const notify = (msg, ok=true)=>{
    if (window.toastr){ ok? toastr.success(msg): toastr.error(msg); }
    else {
      const el=$('<div class="position-fixed" style="right:16px; bottom:16px; z-index:1080"></div>');
      el.html(`<div class="alert ${ok?'alert-success':'alert-danger'} shadow-sm py-2 px-3 mb-0">${msg}</div>`);
      $('body').append(el); setTimeout(()=>el.fadeOut(300,()=>el.remove()), 1600);
    }
  }
  const withSpinner = (btn, doing=true, keepText=false)=>{
    if(!btn) return;
    if(doing){
      $(btn).prop('disabled', true)
        .data('orig', $(btn).html())
        .html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>${keepText ? $(btn).text().trim() : ''}`);
    }else{
      $(btn).prop('disabled', false).html($(btn).data('orig'));
    }
  }
  const markDirty = ()=> $dirty.addClass('show');
  const clearDirty = ()=> $dirty.removeClass('show');

  // ==== RENUMERAR 1..N ====
  function renumberOrders(){
    $('#sortable tr').each(function(i){
      $(this).find('.orden').val(i+1);
    });
    markDirty();
  }

  // ==== Sortable con handle y renumeración ====
  new Sortable(document.getElementById('sortable'), {
    animation:150,
    handle: '.row-handle',
    onStart: (evt)=> $(evt.item).addClass('dragging'),
    onEnd:   (evt)=> { $(evt.item).removeClass('dragging'); renumberOrders(); }
  });

  // ==== Catálogo: Agregar ====
  $('.btn-add').on('click', function(){
    const id = $(this).data('id');
    withSpinner(this, true);
    $.post(`${base}/${matId}/add-fields`, {cam_ids:id})
      .done(()=> location.reload())
      .fail(()=> notify('No se pudo agregar el campo', false))
      .always(()=> withSpinner(this, false));
  });

  // ==== Matriz: Guardar fila ====
  $('#tbl-refs').on('click','.btn-save', function(){
    const tr = $(this).closest('tr');
    const id = tr.data('mcr');
    const orden = tr.find('.orden').val();
    const titulo= tr.find('.titulo').val();
    const vis   = tr.find('.visible').val();
    withSpinner(this, true);
    $.post(`${base}/ref/${id}/update`, {mcr_orden:orden, mcr_titulo:titulo, mcr_visible:vis})
      .done(()=> { notify('Guardado'); clearDirty(); })
      .fail(()=> notify('Error al guardar', false))
      .always(()=> withSpinner(this, false));
  });

  // ==== Matriz: Quitar ====
  $('#tbl-refs').on('click','.btn-del', function(){
    if(!confirm('Quitar de la matriz?')) return;
    const btn = this;
    const id = $(btn).closest('tr').data('mcr');
    withSpinner(btn, true);
    $.post(`${base}/ref/${id}/delete`)
      .done(()=> location.reload())
      .fail(()=> notify('No se pudo quitar', false))
      .always(()=> withSpinner(btn, false));
  });

  // ==== Guardar TODO ====
  $('#btn-save-all').on('click', async function(){
    const btn = this;
    withSpinner(btn, true, true);
    const rows = $('#sortable tr');
    const calls = [];
    rows.each(function(){
      const $tr = $(this);
      const id = $tr.data('mcr');
      const orden = $tr.find('.orden').val();
      const titulo= $tr.find('.titulo').val();
      const vis   = $tr.find('.visible').val();
      calls.push($.post(`${base}/ref/${id}/update`, {mcr_orden:orden, mcr_titulo:titulo, mcr_visible:vis}));
    });
    try{
      await Promise.all(calls);
      notify('Todos los cambios fueron guardados');
      clearDirty();
    }catch(e){
      notify('Algunos cambios no se pudieron guardar', false);
    }finally{
      withSpinner(btn, false);
    }
  });

  // Marcar “dirty” en cambios manuales
  $('#tbl-refs').on('input change', '.orden, .titulo, .visible', deb(markDirty, 50));

  // ==== Búsqueda catálogo con debounce + resaltado ====
  const $q = $('#q'), $count = $('#cat-count');
  const highlight = (text, q)=>{
    if(!q) return text;
    const esc = q.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    return text.replace(new RegExp(`(${esc})`,'ig'), '<span class="match-highlight">$1</span>');
  }
  const clearHighlights = ($cell)=> $cell.html($cell.text());

  function applyFilter(){
    const q = ($q.val()||'').trim().toLowerCase();
    let shown=0;
    $('#tbl-cat tbody tr').each(function(){
      const $tr = $(this);
      const txt = $tr.text().toLowerCase();
      const ok = !q || txt.indexOf(q)>=0;
      $tr.toggle(ok);
      const cells = $tr.find('[data-field]');
      if(ok && q){ cells.each(function(){ const $c=$(this); $c.html(highlight($c.text(), q)); }); }
      else{ cells.each(function(){ clearHighlights($(this)) }) }
      shown += ok?1:0;
    });
    $count.text(shown);
  }
  $('#btn-q').on('click', applyFilter);
  $('#btn-clear').on('click', ()=>{ $q.val(''); applyFilter(); $q.trigger('focus') });
  $q.on('input', deb(applyFilter, 200));
  $(document).on('keydown', function(e){
    if(e.key==='/'){ e.preventDefault(); $q.trigger('focus'); }
    if(e.key==='Escape'){ $('#btn-clear').click(); }
  });

  // ==== Fullscreen de cada card (opcional) ====
  $(document).on('click', '.card-fullscreen-toggle', function(){
    const target = $(this).data('target');
    const $card = $(target);
    if(!$card.length) return;
    $card.toggleClass('fullscreen');
  });
});
</script>
