<?php
/** @var array $matrices  Lista de matrices: mat_id, mat_tipo, mat_nombre, mat_estado */
?>
<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">Matrices v2</h2>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-outline-secondary" href="<?= site_url('matrices'); ?>">
        Ir a Matrices v1
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <table id="tbl-matrices2" class="table table-sm table-striped table-bordered w-100">
        <thead>
          <tr>
            <th style="width:80px;">ID</th>
            <th style="width:160px;">Tipo</th>
            <th>Nombre</th>
            <th style="width:120px;">Estado</th>
            <th style="width:280px;">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($matrices)): ?>
            <?php foreach ($matrices as $m): ?>
              <tr>
                <td><?= (int)$m['mat_id'] ?></td>
                <td>
                  <!-- Si usas Bootstrap 4 cambia a: badge badge-secondary -->
                  <span class="badge bg-secondary"><?= esc($m['mat_tipo']) ?></span>
                </td>
                <td><?= esc($m['mat_nombre'] ?? '') ?></td>
                <td>
                  <?php if ((int)($m['mat_estado'] ?? 1) === 1): ?>
                    <span class="badge bg-success">Activo</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Inactivo</span>
                  <?php endif; ?>
                </td>
                <td class="text-nowrap">
                  <a class="btn btn-sm btn-outline-primary"
                     href="<?= site_url('matrices2/'.$m['mat_id'].'/builder'); ?>">
                    Constructor
                  </a>
                  <a class="btn btn-sm btn-outline-dark"
                     href="<?= site_url('matrices2/'.$m['mat_id'].'/grid'); ?>">
                    Ver matriz
                  </a>
                  <a class="btn btn-sm btn-outline-success"
                     href="<?= site_url('matrices2/'.$m['mat_id'].'/export'); ?>">
                    Exportar CSV
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>

      <?php if (empty($matrices)): ?>
        <div class="alert alert-info mb-0">
          No hay matrices creadas aún.
          <a href="<?= site_url('matrices'); ?>">Ir a crear una matriz</a>.
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
(function(){
  // Inicializa SOLO el listado de matrices (sin AJAX, sin $matId)
  if (window.jQuery && $.fn && $.fn.DataTable) {
    $('#tbl-matrices2').DataTable({
      pageLength: 25,
      lengthMenu: [[25,50,100,500,1000,-1],[25,50,100,500,1000,'Todos']],
      order: [[0,'asc']],
      language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
    });
  } else {
    console.warn('DataTables no está cargado. La tabla funcionará sin paginación.');
  }
})();
</script>
