<?php
// app/Views/matrices2/version_view.php
$v   = $version ?? [];
$rows= $rows ?? [];
$cols= $columns ?? [];
$hdrs= $headers ?? [];
$meta= $meta ?? [];
?>
<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h2 class="mb-0">
      Versión #<?= (int)$v['mver_id'] ?> — <?= esc($v['mver_nombre']) ?>
      <small class="text-muted">[<?= esc($v['mver_tipo']) ?> · <?= esc(date('Y-m-d H:i', strtotime($v['created_at']))) ?>]</small>
    </h2>
    <div>
      <a href="<?= site_url('matrices2/'.$v['mat_id'].'/versions') ?>" class="btn btn-sm btn-default">Volver</a>
      <a href="<?= site_url('matrices2/versions/json/'.$v['mver_id']) ?>" class="btn btn-sm btn-outline-dark">Descargar JSON</a>
    </div>
  </div>

  <div class="card mb-2 p-2">
    <div><strong>Usuario:</strong> <?= esc($v['mver_usuario']) ?></div>
    <div><strong>Filas:</strong> <?= number_format((int)$v['mver_rows']) ?></div>
    <div><strong>Meta:</strong>
      Hasta: <strong><?= esc($meta['hasta'] ?? '') ?></strong> ·
      Promo: <strong><?= !empty($meta['promo']) ? 'Sí' : 'No' ?></strong> ·
      Motivo: <em><?= esc($meta['motivo'] ?? '') ?></em>
    </div>
  </div>

  <div class="card" style="position:relative">
    <div id="ver-grid" class="excel2007" style="height: calc(100vh - 260px); background:#fff"></div>
  </div>
</div>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/handsontable@14.4.0/dist/handsontable.full.min.css" />
<script src="https://cdn.jsdelivr.net/npm/handsontable@14.4.0/dist/handsontable.full.min.js"></script>

<script>
(function(){
  const mount   = document.getElementById('ver-grid');
  const data    = <?= json_encode($rows, JSON_UNESCAPED_UNICODE) ?>;
  const columns = <?= json_encode($cols, JSON_UNESCAPED_UNICODE) ?>;
  const headers = <?= json_encode($hdrs, JSON_UNESCAPED_UNICODE) ?>;

  // Compacto/solo lectura
  new Handsontable(mount, {
    data,
    columns,
    colHeaders: headers,
    rowHeaders: true,
    licenseKey: 'non-commercial-and-evaluation',
    readOnly: true,
    disableVisualSelection: false,
    manualColumnResize: true,
    manualColumnMove: true,
    height: 'calc(100vh - 260px)',
    stretchH: 'all',
    filters: true,
    dropdownMenu: {
      items: { 'filter_by_condition': {}, 'filter_by_value': {}, 'filter_action_bar': {} }
    },
    columnSorting: true,
    className: 'htCenter'
  });
})();
</script>

<style>
/* Reutiliza tu tema excel2007 */
#ver-grid.excel2007 {
  --xl07-head-top:#d4e4ef; --xl07-head-mid:#d4e4ef; --xl07-head-bot:#b7c3cc;
  --xl07-head-text:#0d2a44; --xl07-border-h:#9EB6CE; --xl07-border-c:#D0D7E5;
  --xl07-row-hover:#f3f7fb; --xl07-edit-outline:rgba(25,118,210,.22);
  --xl07-font: Calibri, Roboto, system-ui, -apple-system, "Segoe UI", Arial, sans-serif;
}
#ver-grid.excel2007 .handsontable td,
#ver-grid.excel2007 .handsontable th {
  font-family: var(--xl07-font); font-size:10.5px; line-height:16px; height:16px;
  padding:0 4px; border-color:var(--xl07-border-c) !important; white-space:nowrap;
}
#ver-grid.excel2007 .handsontable th {
  color:var(--xl07-head-text); font-weight:600;
  background:linear-gradient(to bottom,var(--xl07-head-top),var(--xl07-head-mid) 35%,var(--xl07-head-bot)) !important;
  border:1px solid var(--xl07-border-h) !important; height:17px; line-height:17px; padding:0 4px;
}
#ver-grid.excel2007 .handsontable tbody tr:hover td { background-color:var(--xl07-row-hover) !important; }
</style>
